/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.security.ipmacbinding;

import com.tplink.smb.omada.manager.configuration.api.web.site.firewall.dto.IpMacBindingGlobalSettingVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import java.util.List;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;

@Schema(name="IPMacBindingGeneralSetting")
public class IpMacBindingGeneralSettingOpenApiVO {
    @NotNull
    @Schema(name="enable", description="Enable of the IP MAC binding general setting, If applied, fill in at least one of LAN and WAN.")
    private Boolean enable;
    @Schema(name="lanIds", description="LANs of the IP MAC binding general setting. LAN Network can be created using 'Create LAN network' interface, and LAN Network ID can be obtained from 'Get LAN network list' interface.")
    private List<String> lanIds;
    @Schema(name="wanIds", description="WANs of the IP MAC binding general setting. WAN port ID can be obtained from 'Get internet basic info' interface.")
    private List<String> wanIds;
    @Schema(name="imbPass", description="ImbPass of the IP MAC binding general setting.")
    private Boolean imbPass;
    @Schema(name="garp", description="GARP of the IP MAC binding general setting.")
    private Boolean garp;
    @Schema(name="interval", description="Interval should be within the range of 1\u201310000.")
    @Range(min=1L, max=10000L, message="Interval is from 1 to 10000 ms.")
    private @Range(min=1L, max=10000L, message="Interval is from 1 to 10000 ms.") Integer interval;

    public static IpMacBindingGeneralSettingOpenApiVO toOpenApiVO(IpMacBindingGlobalSettingVO vo) {
        if (vo == null) {
            return new IpMacBindingGeneralSettingOpenApiVO();
        }
        IpMacBindingGeneralSettingOpenApiVO ipMacBindingGeneralSettingOpenApiVO = new IpMacBindingGeneralSettingOpenApiVO();
        ipMacBindingGeneralSettingOpenApiVO.setEnable(vo.getEnable());
        ipMacBindingGeneralSettingOpenApiVO.setLanIds(vo.getLanIds());
        ipMacBindingGeneralSettingOpenApiVO.setWanIds(vo.getWanIds());
        ipMacBindingGeneralSettingOpenApiVO.setImbPass(vo.getImbPass());
        ipMacBindingGeneralSettingOpenApiVO.setGarp(vo.getGarp());
        ipMacBindingGeneralSettingOpenApiVO.setInterval(vo.getInterval());
        return ipMacBindingGeneralSettingOpenApiVO;
    }

    public static IpMacBindingGlobalSettingVO toVO(IpMacBindingGeneralSettingOpenApiVO openApiVO) {
        IpMacBindingGlobalSettingVO vo = new IpMacBindingGlobalSettingVO();
        vo.setEnable(openApiVO.getEnable());
        vo.setLanIds(openApiVO.getLanIds());
        vo.setWanIds(openApiVO.getWanIds());
        vo.setImbPass(openApiVO.getImbPass());
        vo.setGarp(openApiVO.getGarp());
        vo.setInterval(openApiVO.getInterval());
        return vo;
    }

    @Generated
    public Boolean getEnable() {
        return this.enable;
    }

    @Generated
    public List<String> getLanIds() {
        return this.lanIds;
    }

    @Generated
    public List<String> getWanIds() {
        return this.wanIds;
    }

    @Generated
    public Boolean getImbPass() {
        return this.imbPass;
    }

    @Generated
    public Boolean getGarp() {
        return this.garp;
    }

    @Generated
    public Integer getInterval() {
        return this.interval;
    }

    @Generated
    public void setEnable(Boolean enable) {
        this.enable = enable;
    }

    @Generated
    public void setLanIds(List<String> lanIds) {
        this.lanIds = lanIds;
    }

    @Generated
    public void setWanIds(List<String> wanIds) {
        this.wanIds = wanIds;
    }

    @Generated
    public void setImbPass(Boolean imbPass) {
        this.imbPass = imbPass;
    }

    @Generated
    public void setGarp(Boolean garp) {
        this.garp = garp;
    }

    @Generated
    public void setInterval(Integer interval) {
        this.interval = interval;
    }

    @Generated
    public String toString() {
        return "IpMacBindingGeneralSettingOpenApiVO(enable=" + this.getEnable() + ", lanIds=" + this.getLanIds() + ", wanIds=" + this.getWanIds() + ", imbPass=" + this.getImbPass() + ", garp=" + this.getGarp() + ", interval=" + this.getInterval() + ")";
    }

    @Generated
    public IpMacBindingGeneralSettingOpenApiVO(Boolean enable, List<String> lanIds, List<String> wanIds, Boolean imbPass, Boolean garp, Integer interval) {
        this.enable = enable;
        this.lanIds = lanIds;
        this.wanIds = wanIds;
        this.imbPass = imbPass;
        this.garp = garp;
        this.interval = interval;
    }

    @Generated
    public IpMacBindingGeneralSettingOpenApiVO() {
    }
}

