/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.security.attackdefense;

import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.security.attackdefense.SpecifiedOptionOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.firewall.dto.AttackDefenseVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;

@Schema(name="AttackDefenseSetting")
public class AttackDefenseSettingOpenApiVO {
    @NotNull
    @Schema(name="tcpConnEnable", description="Multi-connections TCP SYN flood enable of the attack defense setting.")
    private Boolean tcpConnEnable;
    @Schema(name="tcpConnLimit", description="Multi-connections TCP SYN flood limit should be within the range of 100\u201399999.")
    @Range(min=100L, max=99999L, message="Number should be between 100 and 99999.")
    private @Range(min=100L, max=99999L, message="Number should be between 100 and 99999.") Integer tcpConnLimit;
    @NotNull
    @Schema(name="udpConnEnable", description="Multi-connections UDP flood enable of the attack defense setting.")
    private Boolean udpConnEnable;
    @Schema(name="udpConnLimit", description="Multi-connections UDP flood limit should be within the range of 100\u201399999.")
    @Range(min=100L, max=99999L, message="Number should be between 100 and 99999.")
    private @Range(min=100L, max=99999L, message="Number should be between 100 and 99999.") Integer udpConnLimit;
    @NotNull
    @Schema(name="icmpConnEnable", description="Multi-connections ICMP flood enable of the attack defense setting.")
    private Boolean icmpConnEnable;
    @Schema(name="icmpConnLimit", description="Multi-connections ICMP flood limit should be within the range of 100\u201399999.")
    @Range(min=100L, max=99999L, message="Number should be between 100 and 99999.")
    private @Range(min=100L, max=99999L, message="Number should be between 100 and 99999.") Integer icmpConnLimit;
    @NotNull
    @Schema(name="tcpSrcEnable", description="Stationary source TCP SYN flood enable of the attack defense setting.")
    private Boolean tcpSrcEnable;
    @Schema(name="tcpSrcLimit", description="Stationary source TCP SYN flood limit should be within the range of 100\u201399999.")
    @Range(min=100L, max=99999L, message="Number should be between 100 and 99999.")
    private @Range(min=100L, max=99999L, message="Number should be between 100 and 99999.") Integer tcpSrcLimit;
    @NotNull
    @Schema(name="udpSrcEnable", description="Stationary source UDP flood enable of the attack defense setting.")
    private Boolean udpSrcEnable;
    @Schema(name="udpSrcLimit", description="Stationary source UDP flood limit should be within the range of 100\u201399999.")
    @Range(min=100L, max=99999L, message="Number should be between 100 and 99999.")
    private @Range(min=100L, max=99999L, message="Number should be between 100 and 99999.") Integer udpSrcLimit;
    @NotNull
    @Schema(name="icmpSrcEnable", description="Stationary source ICMP flood enable of the attack defense setting.")
    private Boolean icmpSrcEnable;
    @Schema(name="icmpSrcLimit", description="Stationary source ICMP flood limit should be within the range of 100\u201399999.")
    @Range(min=100L, max=99999L, message="Number should be between 100 and 99999.")
    private @Range(min=100L, max=99999L, message="Number should be between 100 and 99999.") Integer icmpSrcLimit;
    @NotNull
    @Schema(name="tcpScanEnable", description="Block TCP scan enable of the attack defense setting.")
    private Boolean tcpScanEnable;
    @Schema(name="tcpScanReject", description="Block TCP scan with reject of the attack defense setting.")
    private Boolean tcpScanReject;
    @NotNull
    @Schema(name="pingDeathEnable", description="Block ping of death of the attack defense setting.")
    private Boolean pingDeathEnable;
    @NotNull
    @Schema(name="largePingEnable", description="Block large ping of the attack defense setting.")
    private Boolean largePingEnable;
    @Range(min=28L, max=65535L, message="Value of Large Ping is 28 to 65535")
    @Schema(name="largePingThreshold", description="Block large ping threshold of the attack defense setting, Value is between 28 and 65535.")
    private @Range(min=28L, max=65535L, message="Value of Large Ping is 28 to 65535") Integer largePingThreshold;
    @NotNull
    @Schema(name="pingWanEnable", description="Block ping from WAN of the attack defense setting.")
    private Boolean pingWanEnable;
    @NotNull
    @Schema(name="winNukeAttackEnable", description="Block WinNuke attack of the attack defense setting.")
    private Boolean winNukeAttackEnable;
    @NotNull
    @Schema(name="tcpSynFinEnable", description="Block TCP packets with SYN and FIN Bits set of the attack defense setting.")
    private Boolean tcpSynFinEnable;
    @NotNull
    @Schema(name="tcpFinNoAckEnable", description="Block TCP packets with FIN Bit set but no ACK Bit set of the attack defense setting.")
    private Boolean tcpFinNoAckEnable;
    @NotNull
    @Schema(name="specifiedOptionEnable", description="Block packets with specified options of the attack defense setting.")
    private Boolean specifiedOptionEnable;
    @Schema(name="specifiedOption", description="Specified option of the attack defense setting.")
    private SpecifiedOptionOpenApiVO specifiedOption;
    @Schema(name="icmpTimestampRequestReject", description="ICMP Timestamp Request setting of the attack defense setting.")
    private Boolean icmpTimestampRequestReject;

    public static AttackDefenseSettingOpenApiVO toOpenApiVO(AttackDefenseVO vo) {
        if (vo == null) {
            return new AttackDefenseSettingOpenApiVO();
        }
        AttackDefenseSettingOpenApiVO openApiVO = new AttackDefenseSettingOpenApiVO();
        openApiVO.setTcpConnEnable(vo.getTcpConnEnable());
        openApiVO.setTcpConnLimit(vo.getTcpConnLimit());
        openApiVO.setUdpConnEnable(vo.getUdpConnEnable());
        openApiVO.setUdpConnLimit(vo.getUdpConnLimit());
        openApiVO.setIcmpConnEnable(vo.getIcmpConnEnable());
        openApiVO.setIcmpConnLimit(vo.getIcmpConnLimit());
        openApiVO.setTcpSrcEnable(vo.getTcpSrcEnable());
        openApiVO.setTcpSrcLimit(vo.getTcpSrcLimit());
        openApiVO.setUdpSrcEnable(vo.getUdpSrcEnable());
        openApiVO.setUdpSrcLimit(vo.getUdpSrcLimit());
        openApiVO.setIcmpSrcEnable(vo.getIcmpSrcEnable());
        openApiVO.setIcmpSrcLimit(vo.getIcmpSrcLimit());
        openApiVO.setTcpScanEnable(vo.getTcpNoflagEnable());
        openApiVO.setTcpScanReject(vo.getTcpScanReject());
        openApiVO.setPingDeathEnable(vo.getPingDeathEnable());
        openApiVO.setLargePingEnable(vo.getPingLargeEnable());
        openApiVO.setLargePingThreshold(vo.getPingLargeThreshold());
        openApiVO.setPingWanEnable(vo.getPingWanEnable());
        openApiVO.setWinNukeAttackEnable(vo.getTcpWinnukeEnable());
        openApiVO.setTcpSynFinEnable(vo.getTcpFinSynEnable());
        openApiVO.setTcpFinNoAckEnable(vo.getTcpFinNoackEnable());
        openApiVO.setSpecifiedOptionEnable(vo.getIpOptionEnable());
        openApiVO.setIcmpTimestampRequestReject(vo.getIcmpTimestampRequestReject());
        if (Boolean.TRUE.equals(vo.getIpOptionEnable())) {
            openApiVO.setSpecifiedOption(SpecifiedOptionOpenApiVO.toOpenApiVO(vo));
        }
        return openApiVO;
    }

    public static AttackDefenseVO toVO(AttackDefenseSettingOpenApiVO openApiVO) {
        AttackDefenseVO vo = new AttackDefenseVO();
        vo.setTcpConnEnable(openApiVO.getTcpConnEnable());
        vo.setTcpConnLimit(openApiVO.getTcpConnLimit());
        vo.setUdpConnEnable(openApiVO.getUdpConnEnable());
        vo.setUdpConnLimit(openApiVO.getUdpConnLimit());
        vo.setIcmpConnEnable(openApiVO.getIcmpConnEnable());
        vo.setIcmpConnLimit(openApiVO.getIcmpConnLimit());
        vo.setTcpSrcEnable(openApiVO.getTcpSrcEnable());
        vo.setTcpSrcLimit(openApiVO.getTcpSrcLimit());
        vo.setUdpSrcEnable(openApiVO.getUdpSrcEnable());
        vo.setUdpSrcLimit(openApiVO.getUdpSrcLimit());
        vo.setIcmpSrcEnable(openApiVO.getIcmpSrcEnable());
        vo.setIcmpSrcLimit(openApiVO.getIcmpSrcLimit());
        vo.setTcpNoflagEnable(openApiVO.getTcpScanEnable());
        vo.setTcpScanReject(openApiVO.getTcpScanReject());
        vo.setPingDeathEnable(openApiVO.getPingDeathEnable());
        vo.setPingLargeEnable(openApiVO.getLargePingEnable());
        vo.setPingLargeThreshold(openApiVO.getLargePingThreshold());
        vo.setPingWanEnable(openApiVO.getPingWanEnable());
        vo.setTcpWinnukeEnable(openApiVO.getWinNukeAttackEnable());
        vo.setTcpFinSynEnable(openApiVO.getTcpSynFinEnable());
        vo.setTcpFinNoackEnable(openApiVO.getTcpFinNoAckEnable());
        vo.setIpOptionEnable(openApiVO.getSpecifiedOptionEnable());
        if (Boolean.TRUE.equals(openApiVO.getSpecifiedOptionEnable())) {
            SpecifiedOptionOpenApiVO.toVO(openApiVO.getSpecifiedOption(), vo);
        }
        vo.setExistIcmpTimestampRequest(openApiVO.getIcmpTimestampRequestReject());
        return vo;
    }

    @Generated
    public Boolean getTcpConnEnable() {
        return this.tcpConnEnable;
    }

    @Generated
    public Integer getTcpConnLimit() {
        return this.tcpConnLimit;
    }

    @Generated
    public Boolean getUdpConnEnable() {
        return this.udpConnEnable;
    }

    @Generated
    public Integer getUdpConnLimit() {
        return this.udpConnLimit;
    }

    @Generated
    public Boolean getIcmpConnEnable() {
        return this.icmpConnEnable;
    }

    @Generated
    public Integer getIcmpConnLimit() {
        return this.icmpConnLimit;
    }

    @Generated
    public Boolean getTcpSrcEnable() {
        return this.tcpSrcEnable;
    }

    @Generated
    public Integer getTcpSrcLimit() {
        return this.tcpSrcLimit;
    }

    @Generated
    public Boolean getUdpSrcEnable() {
        return this.udpSrcEnable;
    }

    @Generated
    public Integer getUdpSrcLimit() {
        return this.udpSrcLimit;
    }

    @Generated
    public Boolean getIcmpSrcEnable() {
        return this.icmpSrcEnable;
    }

    @Generated
    public Integer getIcmpSrcLimit() {
        return this.icmpSrcLimit;
    }

    @Generated
    public Boolean getTcpScanEnable() {
        return this.tcpScanEnable;
    }

    @Generated
    public Boolean getTcpScanReject() {
        return this.tcpScanReject;
    }

    @Generated
    public Boolean getPingDeathEnable() {
        return this.pingDeathEnable;
    }

    @Generated
    public Boolean getLargePingEnable() {
        return this.largePingEnable;
    }

    @Generated
    public Integer getLargePingThreshold() {
        return this.largePingThreshold;
    }

    @Generated
    public Boolean getPingWanEnable() {
        return this.pingWanEnable;
    }

    @Generated
    public Boolean getWinNukeAttackEnable() {
        return this.winNukeAttackEnable;
    }

    @Generated
    public Boolean getTcpSynFinEnable() {
        return this.tcpSynFinEnable;
    }

    @Generated
    public Boolean getTcpFinNoAckEnable() {
        return this.tcpFinNoAckEnable;
    }

    @Generated
    public Boolean getSpecifiedOptionEnable() {
        return this.specifiedOptionEnable;
    }

    @Generated
    public SpecifiedOptionOpenApiVO getSpecifiedOption() {
        return this.specifiedOption;
    }

    @Generated
    public Boolean getIcmpTimestampRequestReject() {
        return this.icmpTimestampRequestReject;
    }

    @Generated
    public void setTcpConnEnable(Boolean tcpConnEnable) {
        this.tcpConnEnable = tcpConnEnable;
    }

    @Generated
    public void setTcpConnLimit(Integer tcpConnLimit) {
        this.tcpConnLimit = tcpConnLimit;
    }

    @Generated
    public void setUdpConnEnable(Boolean udpConnEnable) {
        this.udpConnEnable = udpConnEnable;
    }

    @Generated
    public void setUdpConnLimit(Integer udpConnLimit) {
        this.udpConnLimit = udpConnLimit;
    }

    @Generated
    public void setIcmpConnEnable(Boolean icmpConnEnable) {
        this.icmpConnEnable = icmpConnEnable;
    }

    @Generated
    public void setIcmpConnLimit(Integer icmpConnLimit) {
        this.icmpConnLimit = icmpConnLimit;
    }

    @Generated
    public void setTcpSrcEnable(Boolean tcpSrcEnable) {
        this.tcpSrcEnable = tcpSrcEnable;
    }

    @Generated
    public void setTcpSrcLimit(Integer tcpSrcLimit) {
        this.tcpSrcLimit = tcpSrcLimit;
    }

    @Generated
    public void setUdpSrcEnable(Boolean udpSrcEnable) {
        this.udpSrcEnable = udpSrcEnable;
    }

    @Generated
    public void setUdpSrcLimit(Integer udpSrcLimit) {
        this.udpSrcLimit = udpSrcLimit;
    }

    @Generated
    public void setIcmpSrcEnable(Boolean icmpSrcEnable) {
        this.icmpSrcEnable = icmpSrcEnable;
    }

    @Generated
    public void setIcmpSrcLimit(Integer icmpSrcLimit) {
        this.icmpSrcLimit = icmpSrcLimit;
    }

    @Generated
    public void setTcpScanEnable(Boolean tcpScanEnable) {
        this.tcpScanEnable = tcpScanEnable;
    }

    @Generated
    public void setTcpScanReject(Boolean tcpScanReject) {
        this.tcpScanReject = tcpScanReject;
    }

    @Generated
    public void setPingDeathEnable(Boolean pingDeathEnable) {
        this.pingDeathEnable = pingDeathEnable;
    }

    @Generated
    public void setLargePingEnable(Boolean largePingEnable) {
        this.largePingEnable = largePingEnable;
    }

    @Generated
    public void setLargePingThreshold(Integer largePingThreshold) {
        this.largePingThreshold = largePingThreshold;
    }

    @Generated
    public void setPingWanEnable(Boolean pingWanEnable) {
        this.pingWanEnable = pingWanEnable;
    }

    @Generated
    public void setWinNukeAttackEnable(Boolean winNukeAttackEnable) {
        this.winNukeAttackEnable = winNukeAttackEnable;
    }

    @Generated
    public void setTcpSynFinEnable(Boolean tcpSynFinEnable) {
        this.tcpSynFinEnable = tcpSynFinEnable;
    }

    @Generated
    public void setTcpFinNoAckEnable(Boolean tcpFinNoAckEnable) {
        this.tcpFinNoAckEnable = tcpFinNoAckEnable;
    }

    @Generated
    public void setSpecifiedOptionEnable(Boolean specifiedOptionEnable) {
        this.specifiedOptionEnable = specifiedOptionEnable;
    }

    @Generated
    public void setSpecifiedOption(SpecifiedOptionOpenApiVO specifiedOption) {
        this.specifiedOption = specifiedOption;
    }

    @Generated
    public void setIcmpTimestampRequestReject(Boolean icmpTimestampRequestReject) {
        this.icmpTimestampRequestReject = icmpTimestampRequestReject;
    }

    @Generated
    public String toString() {
        return "AttackDefenseSettingOpenApiVO(tcpConnEnable=" + this.getTcpConnEnable() + ", tcpConnLimit=" + this.getTcpConnLimit() + ", udpConnEnable=" + this.getUdpConnEnable() + ", udpConnLimit=" + this.getUdpConnLimit() + ", icmpConnEnable=" + this.getIcmpConnEnable() + ", icmpConnLimit=" + this.getIcmpConnLimit() + ", tcpSrcEnable=" + this.getTcpSrcEnable() + ", tcpSrcLimit=" + this.getTcpSrcLimit() + ", udpSrcEnable=" + this.getUdpSrcEnable() + ", udpSrcLimit=" + this.getUdpSrcLimit() + ", icmpSrcEnable=" + this.getIcmpSrcEnable() + ", icmpSrcLimit=" + this.getIcmpSrcLimit() + ", tcpScanEnable=" + this.getTcpScanEnable() + ", tcpScanReject=" + this.getTcpScanReject() + ", pingDeathEnable=" + this.getPingDeathEnable() + ", largePingEnable=" + this.getLargePingEnable() + ", largePingThreshold=" + this.getLargePingThreshold() + ", pingWanEnable=" + this.getPingWanEnable() + ", winNukeAttackEnable=" + this.getWinNukeAttackEnable() + ", tcpSynFinEnable=" + this.getTcpSynFinEnable() + ", tcpFinNoAckEnable=" + this.getTcpFinNoAckEnable() + ", specifiedOptionEnable=" + this.getSpecifiedOptionEnable() + ", specifiedOption=" + this.getSpecifiedOption() + ", icmpTimestampRequestReject=" + this.getIcmpTimestampRequestReject() + ")";
    }

    @Generated
    public AttackDefenseSettingOpenApiVO(Boolean tcpConnEnable, Integer tcpConnLimit, Boolean udpConnEnable, Integer udpConnLimit, Boolean icmpConnEnable, Integer icmpConnLimit, Boolean tcpSrcEnable, Integer tcpSrcLimit, Boolean udpSrcEnable, Integer udpSrcLimit, Boolean icmpSrcEnable, Integer icmpSrcLimit, Boolean tcpScanEnable, Boolean tcpScanReject, Boolean pingDeathEnable, Boolean largePingEnable, Integer largePingThreshold, Boolean pingWanEnable, Boolean winNukeAttackEnable, Boolean tcpSynFinEnable, Boolean tcpFinNoAckEnable, Boolean specifiedOptionEnable, SpecifiedOptionOpenApiVO specifiedOption, Boolean icmpTimestampRequestReject) {
        this.tcpConnEnable = tcpConnEnable;
        this.tcpConnLimit = tcpConnLimit;
        this.udpConnEnable = udpConnEnable;
        this.udpConnLimit = udpConnLimit;
        this.icmpConnEnable = icmpConnEnable;
        this.icmpConnLimit = icmpConnLimit;
        this.tcpSrcEnable = tcpSrcEnable;
        this.tcpSrcLimit = tcpSrcLimit;
        this.udpSrcEnable = udpSrcEnable;
        this.udpSrcLimit = udpSrcLimit;
        this.icmpSrcEnable = icmpSrcEnable;
        this.icmpSrcLimit = icmpSrcLimit;
        this.tcpScanEnable = tcpScanEnable;
        this.tcpScanReject = tcpScanReject;
        this.pingDeathEnable = pingDeathEnable;
        this.largePingEnable = largePingEnable;
        this.largePingThreshold = largePingThreshold;
        this.pingWanEnable = pingWanEnable;
        this.winNukeAttackEnable = winNukeAttackEnable;
        this.tcpSynFinEnable = tcpSynFinEnable;
        this.tcpFinNoAckEnable = tcpFinNoAckEnable;
        this.specifiedOptionEnable = specifiedOptionEnable;
        this.specifiedOption = specifiedOption;
        this.icmpTimestampRequestReject = icmpTimestampRequestReject;
    }

    @Generated
    public AttackDefenseSettingOpenApiVO() {
    }
}

