/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.schedule;

import com.tplink.smb.omada.a.a;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.schedule.BaseScheduleTimeOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.servicesetting.dto.ScheduleUpgradeVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import java.util.List;
import java.util.Objects;
import lombok.Generated;

public class UpgradeScheduleQueryOpenApiVO {
    @Schema(name="id", description="Reboot Schedule ID.")
    private String id;
    @NotNull
    @Pattern(regexp="^[^ ]$|^[^ ].{0,126}[^ ]$", message="Parameter [name] should be 1 ~ 128 characters.")
    @Schema(name="name", description="Reboot Schedule name should contain 1 to 128 characters.")
    private @NotNull @Pattern(regexp="^[^ ]$|^[^ ].{0,126}[^ ]$", message="Parameter [name] should be 1 ~ 128 characters.") String name;
    @NotNull
    @Schema(name="status", description="Reboot Schedule status.")
    private Boolean status;
    @NotNull
    @Schema(name="deviceMacs", description="MAC address of the selected devices.")
    @a
    private List<String> deviceMacs;
    @NotNull
    @Schema(name="type", description="Type should be a value as follows: 0: execute only once; 1: repeat")
    private Integer type;
    @Schema(name="nextExecuteTime", description="Execution timeStamp(ms). Required when type is 0.")
    private Long nextExecuteTime;
    @Schema(name="occurrenceTime", description="Execution occurrence setting. Required when type is 1.")
    private BaseScheduleTimeOpenApiVO occurrenceTime;

    public static UpgradeScheduleQueryOpenApiVO fromWeb(ScheduleUpgradeVO vo) {
        UpgradeScheduleQueryOpenApiVO res = new UpgradeScheduleQueryOpenApiVO();
        if (Objects.isNull(vo)) {
            return res;
        }
        res.setId(vo.getId());
        res.setName(vo.getName());
        res.setStatus(vo.getStatus());
        res.setType(vo.getType());
        if (Objects.equals(res.getType(), 0)) {
            res.setNextExecuteTime(vo.getNextExecute());
        } else {
            res.setOccurrenceTime(BaseScheduleTimeOpenApiVO.fromWeb(vo.getOccurrence()));
        }
        res.setDeviceMacs(vo.getDeviceMacs());
        return res;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Boolean getStatus() {
        return this.status;
    }

    @Generated
    public List<String> getDeviceMacs() {
        return this.deviceMacs;
    }

    @Generated
    public Integer getType() {
        return this.type;
    }

    @Generated
    public Long getNextExecuteTime() {
        return this.nextExecuteTime;
    }

    @Generated
    public BaseScheduleTimeOpenApiVO getOccurrenceTime() {
        return this.occurrenceTime;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setStatus(Boolean status) {
        this.status = status;
    }

    @Generated
    public void setDeviceMacs(List<String> deviceMacs) {
        this.deviceMacs = deviceMacs;
    }

    @Generated
    public void setType(Integer type) {
        this.type = type;
    }

    @Generated
    public void setNextExecuteTime(Long nextExecuteTime) {
        this.nextExecuteTime = nextExecuteTime;
    }

    @Generated
    public void setOccurrenceTime(BaseScheduleTimeOpenApiVO occurrenceTime) {
        this.occurrenceTime = occurrenceTime;
    }

    @Generated
    public String toString() {
        return "UpgradeScheduleQueryOpenApiVO(id=" + this.getId() + ", name=" + this.getName() + ", status=" + this.getStatus() + ", deviceMacs=" + this.getDeviceMacs() + ", type=" + this.getType() + ", nextExecuteTime=" + this.getNextExecuteTime() + ", occurrenceTime=" + this.getOccurrenceTime() + ")";
    }

    @Generated
    public UpgradeScheduleQueryOpenApiVO(String id, String name, Boolean status, List<String> deviceMacs, Integer type, Long nextExecuteTime, BaseScheduleTimeOpenApiVO occurrenceTime) {
        this.id = id;
        this.name = name;
        this.status = status;
        this.deviceMacs = deviceMacs;
        this.type = type;
        this.nextExecuteTime = nextExecuteTime;
        this.occurrenceTime = occurrenceTime;
    }

    @Generated
    public UpgradeScheduleQueryOpenApiVO() {
    }
}

