/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.schedule;

import com.tplink.smb.omada.a.a;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.schedule.BaseScheduleTimeOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.servicesetting.dto.ScheduleUpgradeVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;

public class UpgradeScheduleOpenApiVO {
    @NotNull
    @Pattern(regexp="^[^ ]$|^[^ ].{0,126}[^ ]$", message="Parameter [name] should be 1 ~ 128 characters.")
    @Schema(name="name", description="Upgrade schedule name should contain 1 to 128 characters.")
    private @NotNull @Pattern(regexp="^[^ ]$|^[^ ].{0,126}[^ ]$", message="Parameter [name] should be 1 ~ 128 characters.") String name;
    @NotNull
    @Schema(name="status", description="Upgrade schedule status.")
    private Boolean status;
    @NotNull
    @Schema(name="type", description="Type should be a value as follows: 0: execute only once; 1: repeat")
    @Range(min=0L, max=1L)
    private @NotNull @Range(min=0L, max=1L) Integer type;
    @Schema(name="nextExecuteTime", description="Execution timeStamp(ms). Required when type is 0.")
    private Long nextExecuteTime;
    @Schema(name="occurrenceTime", description="Execution occurrence setting. Required when type is 1.")
    private BaseScheduleTimeOpenApiVO occurrenceTime;
    @NotNull
    @Schema(name="deviceMacs", description="MAC address of the selected devices. E.g. AA-BB-CC-DD-11-22")
    @a
    private List<String> deviceMacs;

    public static ScheduleUpgradeVO toWeb(UpgradeScheduleOpenApiVO vo) {
        ScheduleUpgradeVO res = new ScheduleUpgradeVO();
        if (Objects.isNull(vo)) {
            return res;
        }
        res.setName(vo.getName());
        res.setStatus(vo.getStatus());
        res.setType(vo.getType());
        if (Objects.equals(res.getType(), 0)) {
            res.setNextExecute(vo.getNextExecuteTime());
        } else {
            res.setOccurrence(BaseScheduleTimeOpenApiVO.toWeb(vo.getOccurrenceTime()));
        }
        res.setDeviceMacs(vo.getDeviceMacs());
        return res;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Boolean getStatus() {
        return this.status;
    }

    @Generated
    public Integer getType() {
        return this.type;
    }

    @Generated
    public Long getNextExecuteTime() {
        return this.nextExecuteTime;
    }

    @Generated
    public BaseScheduleTimeOpenApiVO getOccurrenceTime() {
        return this.occurrenceTime;
    }

    @Generated
    public List<String> getDeviceMacs() {
        return this.deviceMacs;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setStatus(Boolean status) {
        this.status = status;
    }

    @Generated
    public void setType(Integer type) {
        this.type = type;
    }

    @Generated
    public void setNextExecuteTime(Long nextExecuteTime) {
        this.nextExecuteTime = nextExecuteTime;
    }

    @Generated
    public void setOccurrenceTime(BaseScheduleTimeOpenApiVO occurrenceTime) {
        this.occurrenceTime = occurrenceTime;
    }

    @Generated
    public void setDeviceMacs(List<String> deviceMacs) {
        this.deviceMacs = deviceMacs;
    }

    @Generated
    public String toString() {
        return "UpgradeScheduleOpenApiVO(name=" + this.getName() + ", status=" + this.getStatus() + ", type=" + this.getType() + ", nextExecuteTime=" + this.getNextExecuteTime() + ", occurrenceTime=" + this.getOccurrenceTime() + ", deviceMacs=" + this.getDeviceMacs() + ")";
    }

    @Generated
    public UpgradeScheduleOpenApiVO(String name, Boolean status, Integer type, Long nextExecuteTime, BaseScheduleTimeOpenApiVO occurrenceTime, List<String> deviceMacs) {
        this.name = name;
        this.status = status;
        this.type = type;
        this.nextExecuteTime = nextExecuteTime;
        this.occurrenceTime = occurrenceTime;
        this.deviceMacs = deviceMacs;
    }

    @Generated
    public UpgradeScheduleOpenApiVO() {
    }
}

