/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.schedule;

import com.tplink.smb.omada.a.a;
import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.common.gridquery.GridVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.schedule.RebootScheduleTimeOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.servicesetting.dto.RebootScheduleVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.annotation.Nonnull;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;

public class RebootScheduleOpenApiVO {
    @Schema(name="id", description="Reboot Schedule Id.")
    private String id;
    @NotNull
    @Pattern(regexp="^[^ ]$|^[^ ].{0,126}[^ ]$", message="Parameter [name] should be 1 ~ 128 characters.")
    @Schema(name="name", description="Reboot Schedule name should contain 1 to 128 characters.")
    private @NotNull @Pattern(regexp="^[^ ]$|^[^ ].{0,126}[^ ]$", message="Parameter [name] should be 1 ~ 128 characters.") String name;
    @NotNull
    @Schema(name="status", description="Reboot Schedule status.")
    private Boolean status;
    @NotNull
    @Schema(name="deviceMacs", description="MAC address of the selected devices. E.g. AA-BB-CC-DD-11-22")
    @a
    private List<String> deviceMacs;
    @NotNull
    @Valid
    @Schema(name="time", description="Execution time setting.")
    private RebootScheduleTimeOpenApiVO time;

    public static RebootScheduleVO toWeb(RebootScheduleOpenApiVO vo) {
        RebootScheduleVO res = new RebootScheduleVO();
        if (Objects.isNull(vo)) {
            return res;
        }
        res.setId(vo.getId());
        res.setName(vo.getName());
        res.setStatus(vo.getStatus());
        res.setDeviceMacs(vo.getDeviceMacs());
        res.setOccurrence(RebootScheduleTimeOpenApiVO.toWeb(vo.getTime()));
        return res;
    }

    public static RebootScheduleOpenApiVO fromWeb(@Nonnull RebootScheduleVO rebootScheduleVO) {
        RebootScheduleOpenApiVO rebootScheduleOpenApiVO = new RebootScheduleOpenApiVO();
        rebootScheduleOpenApiVO.setId(rebootScheduleVO.getId());
        rebootScheduleOpenApiVO.setName(rebootScheduleVO.getName());
        rebootScheduleOpenApiVO.setStatus(rebootScheduleVO.getStatus());
        rebootScheduleOpenApiVO.setDeviceMacs(rebootScheduleVO.getDeviceMacs());
        rebootScheduleOpenApiVO.setTime(RebootScheduleTimeOpenApiVO.fromWeb(rebootScheduleVO.getOccurrence()));
        return rebootScheduleOpenApiVO;
    }

    public static GridVO<RebootScheduleOpenApiVO> fromWebGrid(@Nonnull GridVO<RebootScheduleVO> gridVO) {
        GridVO openApiGridVO = new GridVO();
        openApiGridVO.setTotalRows(gridVO.getTotalRows());
        openApiGridVO.setCurrentPage(gridVO.getCurrentPage());
        openApiGridVO.setCurrentSize(gridVO.getCurrentSize());
        openApiGridVO.setData(gridVO.getData().stream().map(RebootScheduleOpenApiVO::fromWeb).collect(Collectors.toList()));
        return openApiGridVO;
    }

    public OperationResponse check() {
        return this.time.check();
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Boolean getStatus() {
        return this.status;
    }

    @Generated
    public List<String> getDeviceMacs() {
        return this.deviceMacs;
    }

    @Generated
    public RebootScheduleTimeOpenApiVO getTime() {
        return this.time;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setStatus(Boolean status) {
        this.status = status;
    }

    @Generated
    public void setDeviceMacs(List<String> deviceMacs) {
        this.deviceMacs = deviceMacs;
    }

    @Generated
    public void setTime(RebootScheduleTimeOpenApiVO time) {
        this.time = time;
    }

    @Generated
    public String toString() {
        return "RebootScheduleOpenApiVO(id=" + this.getId() + ", name=" + this.getName() + ", status=" + this.getStatus() + ", deviceMacs=" + this.getDeviceMacs() + ", time=" + this.getTime() + ")";
    }

    @Generated
    public RebootScheduleOpenApiVO(String id, String name, Boolean status, List<String> deviceMacs, RebootScheduleTimeOpenApiVO time) {
        this.id = id;
        this.name = name;
        this.status = status;
        this.deviceMacs = deviceMacs;
        this.time = time;
    }

    @Generated
    public RebootScheduleOpenApiVO() {
    }
}

