/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.schedule;

import com.tplink.smb.omada.manager.configuration.api.web.site.servicesetting.dto.embed.BaseScheduleTimeVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import java.util.Objects;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;

public class BaseScheduleTimeOpenApiVO {
    @NotNull
    @Range(min=1L, max=3L)
    @Schema(name="timingType", description="Time type should be a value as follows: 1:Daily; 2:Weekly; 3:Monthly")
    private @NotNull @Range(min=1L, max=3L) Integer timingType;
    @Range(min=0L, max=6L)
    @Schema(name="dayOfWeek", description="It should be within the range of 0(Sunday)~6(Saturday). Required when parameter [timingType] is 2.")
    private @Range(min=0L, max=6L) Integer dayOfWeek;
    @Range(min=1L, max=31L)
    @Schema(name="dayOfMonth", description="It should be within the range of 1~31. Required when parameter [timingType] is 3.")
    private @Range(min=1L, max=31L) Integer dayOfMonth;
    @Range(min=1L, max=12L)
    @Schema(name="monthOfYear", description="It should be within the range of 1~12. Required when parameter [timingType] is 4.")
    private @Range(min=1L, max=12L) Integer monthOfYear;
    @NotNull(message="Operator parameter [hour] should not be null.")
    @Range(min=0L, max=23L)
    @Schema(name="hour", description="It should be within the range of 0~23")
    private @NotNull(message="Operator parameter [hour] should not be null.") @Range(min=0L, max=23L) Integer hour;
    @NotNull(message="Operator parameter [minute] should not be null.")
    @Range(min=0L, max=59L)
    @Schema(name="minute", description="It should be within the range of 0~59")
    private @NotNull(message="Operator parameter [minute] should not be null.") @Range(min=0L, max=59L) Integer minute;

    public static BaseScheduleTimeOpenApiVO fromWeb(BaseScheduleTimeVO vo) {
        BaseScheduleTimeOpenApiVO res = new BaseScheduleTimeOpenApiVO();
        if (vo == null) {
            return res;
        }
        res.setMinute(vo.getMinute());
        res.setHour(vo.getHour());
        res.setTimingType(vo.getTimingType());
        if (Objects.equals(res.getTimingType(), 2)) {
            res.setDayOfWeek(vo.getDayOfWeek());
        } else if (Objects.equals(res.getTimingType(), 3)) {
            res.setDayOfMonth(vo.getDayOfMonth());
        }
        return res;
    }

    public static BaseScheduleTimeVO toWeb(BaseScheduleTimeOpenApiVO vo) {
        BaseScheduleTimeVO res = new BaseScheduleTimeVO();
        if (vo == null) {
            return res;
        }
        res.setMinute(vo.getMinute());
        res.setHour(vo.getHour());
        res.setTimingType(vo.getTimingType());
        if (Objects.equals(res.getTimingType(), 2)) {
            res.setDayOfWeek(vo.getDayOfWeek());
            res.setDayOfMonth(Integer.valueOf(1));
            res.setMonthOfYear(Integer.valueOf(1));
        } else if (Objects.equals(res.getTimingType(), 3)) {
            res.setDayOfMonth(vo.getDayOfMonth());
            res.setDayOfWeek(Integer.valueOf(0));
            res.setMonthOfYear(Integer.valueOf(1));
        } else if (Objects.equals(res.getTimingType(), 1)) {
            res.setDayOfWeek(Integer.valueOf(0));
            res.setDayOfMonth(Integer.valueOf(1));
            res.setMonthOfYear(Integer.valueOf(1));
        }
        return res;
    }

    @Generated
    public Integer getTimingType() {
        return this.timingType;
    }

    @Generated
    public Integer getDayOfWeek() {
        return this.dayOfWeek;
    }

    @Generated
    public Integer getDayOfMonth() {
        return this.dayOfMonth;
    }

    @Generated
    public Integer getMonthOfYear() {
        return this.monthOfYear;
    }

    @Generated
    public Integer getHour() {
        return this.hour;
    }

    @Generated
    public Integer getMinute() {
        return this.minute;
    }

    @Generated
    public void setTimingType(Integer timingType) {
        this.timingType = timingType;
    }

    @Generated
    public void setDayOfWeek(Integer dayOfWeek) {
        this.dayOfWeek = dayOfWeek;
    }

    @Generated
    public void setDayOfMonth(Integer dayOfMonth) {
        this.dayOfMonth = dayOfMonth;
    }

    @Generated
    public void setMonthOfYear(Integer monthOfYear) {
        this.monthOfYear = monthOfYear;
    }

    @Generated
    public void setHour(Integer hour) {
        this.hour = hour;
    }

    @Generated
    public void setMinute(Integer minute) {
        this.minute = minute;
    }

    @Generated
    public String toString() {
        return "BaseScheduleTimeOpenApiVO(timingType=" + this.getTimingType() + ", dayOfWeek=" + this.getDayOfWeek() + ", dayOfMonth=" + this.getDayOfMonth() + ", monthOfYear=" + this.getMonthOfYear() + ", hour=" + this.getHour() + ", minute=" + this.getMinute() + ")";
    }
}

