/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.ratelimit;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;

public class CreateRateLimitProfileOpenApiVO {
    @NotNull(message="Parameter [name] should not be null.")
    @Pattern(regexp="^[^ ]$|^[^ ].{0,62}[^ ]$", message="Parameter [name] should be 1 - 64 characters")
    @Schema(name="name", description="Rate limit profile name should contain 1 to 64 characters.")
    private @NotNull(message="Parameter [name] should not be null.") @Pattern(regexp="^[^ ]$|^[^ ].{0,62}[^ ]$", message="Parameter [name] should be 1 - 64 characters") String name;
    @NotNull(message="Parameter [downLimitEnable] should not be null")
    @Schema(name="downLimitEnable", description="Whether to enable download limit")
    private @NotNull(message="Parameter [downLimitEnable] should not be null") Boolean downLimitEnable;
    @Range(min=1L, max=0xA00000L, message="Parameter [downLimit] should be between from 1 and 10485760.")
    @Schema(name="downLimit", description="Download limit(Unit: Kbps), this field is required when parameter [downLimitEnable] is true; It should be within the range of 1\u201310485760.")
    private @Range(min=1L, max=0xA00000L, message="Parameter [downLimit] should be between from 1 and 10485760.") Long downLimit;
    @NotNull(message="Parameter [upLimitEnable] should not be null")
    @Schema(name="upLimitEnable", description="Whether to enable upload limit")
    private @NotNull(message="Parameter [upLimitEnable] should not be null") Boolean upLimitEnable;
    @Range(min=1L, max=0xA00000L, message="Parameter [upLimit] should be between from 1 and 10485760.")
    @Schema(name="upLimit", description="Upload limit(Unit: Kbps), this field is required when parameter [upLimitEnable] is true; It should be within the range of 1\u201310485760.")
    private @Range(min=1L, max=0xA00000L, message="Parameter [upLimit] should be between from 1 and 10485760.") Long upLimit;

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Boolean getDownLimitEnable() {
        return this.downLimitEnable;
    }

    @Generated
    public Long getDownLimit() {
        return this.downLimit;
    }

    @Generated
    public Boolean getUpLimitEnable() {
        return this.upLimitEnable;
    }

    @Generated
    public Long getUpLimit() {
        return this.upLimit;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setDownLimitEnable(Boolean downLimitEnable) {
        this.downLimitEnable = downLimitEnable;
    }

    @Generated
    public void setDownLimit(Long downLimit) {
        this.downLimit = downLimit;
    }

    @Generated
    public void setUpLimitEnable(Boolean upLimitEnable) {
        this.upLimitEnable = upLimitEnable;
    }

    @Generated
    public void setUpLimit(Long upLimit) {
        this.upLimit = upLimit;
    }

    @Generated
    public String toString() {
        return "CreateRateLimitProfileOpenApiVO(name=" + this.getName() + ", downLimitEnable=" + this.getDownLimitEnable() + ", downLimit=" + this.getDownLimit() + ", upLimitEnable=" + this.getUpLimitEnable() + ", upLimit=" + this.getUpLimit() + ")";
    }

    @Generated
    public CreateRateLimitProfileOpenApiVO() {
    }

    @Generated
    public CreateRateLimitProfileOpenApiVO(String name, Boolean downLimitEnable, Long downLimit, Boolean upLimitEnable, Long upLimit) {
        this.name = name;
        this.downLimitEnable = downLimitEnable;
        this.downLimit = downLimit;
        this.upLimitEnable = upLimitEnable;
        this.upLimit = upLimit;
    }
}

