/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.radiusprofile;

import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.radiusprofile.RadiusAcctServerOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.radiusprofile.RadiusAuthServerOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.authentication.radiusprofile.RadiusProfileVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.authentication.radiusprofile.embed.RadiusCoaServerVO;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.util.CollectionUtils;

public class RadiusProfileOpenApiVO {
    @Schema(name="radiusProfileId", description="Radius profile ID")
    private String radiusProfileId;
    @Schema(name="name", description="Radius profile name")
    private String name;
    @Schema(name="authServer", description="Radius authentication server list")
    private List<RadiusAuthServerOpenApiVO> authServer;
    @Schema(name="radiusAccountingEnable", description="Radius accounting enable status")
    private Boolean radiusAccountingEnable;
    @Schema(name="interimUpdateEnable", description="When radius accounting enables, interval update enable status")
    private Boolean interimUpdateEnable;
    @Schema(name="interimUpdateInterval", description="When interval update enables, interval update duration")
    private Integer interimUpdateInterval;
    @Schema(name="acctServer", description="Radius accounting server list, valid when parameter [radiusAccountingEnable] is true")
    private List<RadiusAcctServerOpenApiVO> acctServer;
    @Schema(name="wirelessVlanAssignment", description="VLAN assignment for wireless network enable status")
    private Boolean wirelessVlanAssignment;
    @Schema(name="domainEnable", description="Domain enable status")
    private Boolean domainEnable;
    @Schema(name="coaEnable", description="Radius CoA enable status")
    private Boolean coaEnable;
    @Schema(name="coaPassword", description="Radius CoA password, valid when parameter [coaEnable] is true")
    private String coaPassword;
    @Schema(name="builtInServer", description="Is this Radius server a built-in server")
    private Boolean builtInServer;
    @Schema(name="serverEnable", description="Built-in Radius server enable status, valid when parameter [builtInServer] is true")
    private Boolean serverEnable;
    @Schema(name="tunnelReplyEnable", description="Built-in Radius server tunneled reply enable status, valid when parameter [builtInServer] is true")
    private Boolean tunnelReplyEnable;
    @Schema(name="builtInServerSecret", description="Built-in Radius server secret, valid when parameter [builtInServer] is true")
    private String builtInServerSecret;
    @Schema(name="ipType", description="Built-in Radius server IP type, 0: auto\uff0c1: custom, valid when parameter [builtInServer] is true")
    private Integer ipType;
    @Schema(name="customIp", description="Built-in Radius server custom IP, valid when parameter [builtInServer] is true and [ipType] is 1")
    private String customIp;

    public static RadiusProfileOpenApiVO toRadiusProfileOpenApiVO(RadiusProfileVO vo) {
        RadiusProfileOpenApiVO openApiVO = new RadiusProfileOpenApiVO();
        openApiVO.setRadiusProfileId(vo.getRadiusProfileId());
        openApiVO.setName(vo.getName());
        openApiVO.setAuthServer(CollectionUtils.isEmpty((Collection)vo.getAuthServer()) ? null : vo.getAuthServer().stream().map(RadiusAuthServerOpenApiVO::toRadiusAuthServerOpenApiVO).collect(Collectors.toList()));
        openApiVO.setRadiusAccountingEnable(vo.getRadiusAccountingEnable());
        openApiVO.setInterimUpdateEnable(vo.getInterimUpdateEnable());
        openApiVO.setInterimUpdateInterval(vo.getInterimUpdateInterval());
        openApiVO.setAcctServer(CollectionUtils.isEmpty((Collection)vo.getAcctServer()) ? null : vo.getAcctServer().stream().map(RadiusAcctServerOpenApiVO::toRadiusAcctServerOpenApiVO).collect(Collectors.toList()));
        openApiVO.setWirelessVlanAssignment(vo.getWirelessVlanAssignment());
        openApiVO.setDomainEnable(vo.getDomainEnable());
        openApiVO.setCoaEnable(vo.getCoaEnable());
        openApiVO.setCoaPassword(CollectionUtils.isEmpty((Collection)vo.getCoaServer()) ? null : ((RadiusCoaServerVO)vo.getCoaServer().get(0)).getCoaPwd());
        openApiVO.setBuiltInServer(vo.getBuiltInServer());
        if (Boolean.TRUE.equals(vo.getBuiltInServer())) {
            openApiVO.setServerEnable(vo.getServerEnable()).setTunnelReplyEnable(vo.getTunnelReplyEnable()).setBuiltInServerSecret(vo.getBuiltInServerSecret()).setIpType(vo.getIpType()).setCustomIp(vo.getCustomIp());
        }
        return openApiVO;
    }

    @Generated
    public String getRadiusProfileId() {
        return this.radiusProfileId;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public List<RadiusAuthServerOpenApiVO> getAuthServer() {
        return this.authServer;
    }

    @Generated
    public Boolean getRadiusAccountingEnable() {
        return this.radiusAccountingEnable;
    }

    @Generated
    public Boolean getInterimUpdateEnable() {
        return this.interimUpdateEnable;
    }

    @Generated
    public Integer getInterimUpdateInterval() {
        return this.interimUpdateInterval;
    }

    @Generated
    public List<RadiusAcctServerOpenApiVO> getAcctServer() {
        return this.acctServer;
    }

    @Generated
    public Boolean getWirelessVlanAssignment() {
        return this.wirelessVlanAssignment;
    }

    @Generated
    public Boolean getDomainEnable() {
        return this.domainEnable;
    }

    @Generated
    public Boolean getCoaEnable() {
        return this.coaEnable;
    }

    @Generated
    public String getCoaPassword() {
        return this.coaPassword;
    }

    @Generated
    public Boolean getBuiltInServer() {
        return this.builtInServer;
    }

    @Generated
    public Boolean getServerEnable() {
        return this.serverEnable;
    }

    @Generated
    public Boolean getTunnelReplyEnable() {
        return this.tunnelReplyEnable;
    }

    @Generated
    public String getBuiltInServerSecret() {
        return this.builtInServerSecret;
    }

    @Generated
    public Integer getIpType() {
        return this.ipType;
    }

    @Generated
    public String getCustomIp() {
        return this.customIp;
    }

    @Generated
    public RadiusProfileOpenApiVO setRadiusProfileId(String radiusProfileId) {
        this.radiusProfileId = radiusProfileId;
        return this;
    }

    @Generated
    public RadiusProfileOpenApiVO setName(String name) {
        this.name = name;
        return this;
    }

    @Generated
    public RadiusProfileOpenApiVO setAuthServer(List<RadiusAuthServerOpenApiVO> authServer) {
        this.authServer = authServer;
        return this;
    }

    @Generated
    public RadiusProfileOpenApiVO setRadiusAccountingEnable(Boolean radiusAccountingEnable) {
        this.radiusAccountingEnable = radiusAccountingEnable;
        return this;
    }

    @Generated
    public RadiusProfileOpenApiVO setInterimUpdateEnable(Boolean interimUpdateEnable) {
        this.interimUpdateEnable = interimUpdateEnable;
        return this;
    }

    @Generated
    public RadiusProfileOpenApiVO setInterimUpdateInterval(Integer interimUpdateInterval) {
        this.interimUpdateInterval = interimUpdateInterval;
        return this;
    }

    @Generated
    public RadiusProfileOpenApiVO setAcctServer(List<RadiusAcctServerOpenApiVO> acctServer) {
        this.acctServer = acctServer;
        return this;
    }

    @Generated
    public RadiusProfileOpenApiVO setWirelessVlanAssignment(Boolean wirelessVlanAssignment) {
        this.wirelessVlanAssignment = wirelessVlanAssignment;
        return this;
    }

    @Generated
    public RadiusProfileOpenApiVO setDomainEnable(Boolean domainEnable) {
        this.domainEnable = domainEnable;
        return this;
    }

    @Generated
    public RadiusProfileOpenApiVO setCoaEnable(Boolean coaEnable) {
        this.coaEnable = coaEnable;
        return this;
    }

    @Generated
    public RadiusProfileOpenApiVO setCoaPassword(String coaPassword) {
        this.coaPassword = coaPassword;
        return this;
    }

    @Generated
    public RadiusProfileOpenApiVO setBuiltInServer(Boolean builtInServer) {
        this.builtInServer = builtInServer;
        return this;
    }

    @Generated
    public RadiusProfileOpenApiVO setServerEnable(Boolean serverEnable) {
        this.serverEnable = serverEnable;
        return this;
    }

    @Generated
    public RadiusProfileOpenApiVO setTunnelReplyEnable(Boolean tunnelReplyEnable) {
        this.tunnelReplyEnable = tunnelReplyEnable;
        return this;
    }

    @Generated
    public RadiusProfileOpenApiVO setBuiltInServerSecret(String builtInServerSecret) {
        this.builtInServerSecret = builtInServerSecret;
        return this;
    }

    @Generated
    public RadiusProfileOpenApiVO setIpType(Integer ipType) {
        this.ipType = ipType;
        return this;
    }

    @Generated
    public RadiusProfileOpenApiVO setCustomIp(String customIp) {
        this.customIp = customIp;
        return this;
    }

    @Generated
    public String toString() {
        return "RadiusProfileOpenApiVO(radiusProfileId=" + this.getRadiusProfileId() + ", name=" + this.getName() + ", authServer=" + this.getAuthServer() + ", radiusAccountingEnable=" + this.getRadiusAccountingEnable() + ", interimUpdateEnable=" + this.getInterimUpdateEnable() + ", interimUpdateInterval=" + this.getInterimUpdateInterval() + ", acctServer=" + this.getAcctServer() + ", wirelessVlanAssignment=" + this.getWirelessVlanAssignment() + ", domainEnable=" + this.getDomainEnable() + ", coaEnable=" + this.getCoaEnable() + ", coaPassword=" + this.getCoaPassword() + ", builtInServer=" + this.getBuiltInServer() + ", serverEnable=" + this.getServerEnable() + ", tunnelReplyEnable=" + this.getTunnelReplyEnable() + ", builtInServerSecret=" + this.getBuiltInServerSecret() + ", ipType=" + this.getIpType() + ", customIp=" + this.getCustomIp() + ")";
    }

    @Generated
    public RadiusProfileOpenApiVO(String radiusProfileId, String name, List<RadiusAuthServerOpenApiVO> authServer, Boolean radiusAccountingEnable, Boolean interimUpdateEnable, Integer interimUpdateInterval, List<RadiusAcctServerOpenApiVO> acctServer, Boolean wirelessVlanAssignment, Boolean domainEnable, Boolean coaEnable, String coaPassword, Boolean builtInServer, Boolean serverEnable, Boolean tunnelReplyEnable, String builtInServerSecret, Integer ipType, String customIp) {
        this.radiusProfileId = radiusProfileId;
        this.name = name;
        this.authServer = authServer;
        this.radiusAccountingEnable = radiusAccountingEnable;
        this.interimUpdateEnable = interimUpdateEnable;
        this.interimUpdateInterval = interimUpdateInterval;
        this.acctServer = acctServer;
        this.wirelessVlanAssignment = wirelessVlanAssignment;
        this.domainEnable = domainEnable;
        this.coaEnable = coaEnable;
        this.coaPassword = coaPassword;
        this.builtInServer = builtInServer;
        this.serverEnable = serverEnable;
        this.tunnelReplyEnable = tunnelReplyEnable;
        this.builtInServerSecret = builtInServerSecret;
        this.ipType = ipType;
        this.customIp = customIp;
    }

    @Generated
    public RadiusProfileOpenApiVO() {
    }
}

