/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.radiusprofile;

import com.tplink.nbu.common.pii.annotation.PII;
import com.tplink.nbu.common.pii.constant.PIIMaskStrategy;
import com.tplink.smb.omada.manager.configuration.api.web.site.authentication.radiusprofile.embed.RadiusAuthServerVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;

public class RadiusAuthServerOpenApiVO {
    @NotNull(message="Parameter [radiusServerIp] should not be null.")
    @PII(strategy=PIIMaskStrategy.ENCRYPT)
    @Pattern(regexp="((\\d{1,2}|1\\d\\d|2[0-4]\\d|25[0-5])(\\.(\\d{1,2}|1\\d\\d|2[0-4]\\d|25[0-5])){3}|([a-zA-Z0-9]([a-zA-Z0-9\\-]{0,61}[a-zA-Z0-9])?\\.)+[a-zA-Z]{2,6})", message="Parameter [radiusServerIp] Invalid.")
    @Schema(name="radiusServerIp", description="Radius authentication server IP. In Pro Site of the Omada Pro Controller, [radiusServerIp] should be a valid IP or domain address. In Omada Controller and Basic Site of the Omada Pro Controller, [radiusServerIp] should be a valid IP address.")
    private @NotNull(message="Parameter [radiusServerIp] should not be null.") @Pattern(regexp="((\\d{1,2}|1\\d\\d|2[0-4]\\d|25[0-5])(\\.(\\d{1,2}|1\\d\\d|2[0-4]\\d|25[0-5])){3}|([a-zA-Z0-9]([a-zA-Z0-9\\-]{0,61}[a-zA-Z0-9])?\\.)+[a-zA-Z]{2,6})", message="Parameter [radiusServerIp] Invalid.") String radiusServerIp;
    @NotNull(message="Parameter [radiusPort] should not be null.")
    @Range(min=1L, max=65535L, message="Parameter [radiusPort] should between 1-65535.")
    @Schema(name="radiusPort", description="Radius authentication server port, radiusPort should be within the range of 1-65535")
    private @NotNull(message="Parameter [radiusPort] should not be null.") @Range(min=1L, max=65535L, message="Parameter [radiusPort] should between 1-65535.") Integer radiusPort;
    @NotNull(message="Parameter [radiusPwd] should not be null.")
    @Pattern(regexp="^[\\041-\\0176]{1,128}$", message="RADIUS password should be 1~128 visible ASCII characters.")
    @PII(strategy=PIIMaskStrategy.ENCRYPT)
    @Schema(name="radiusPwd", description="Radius authentication server password, radiusPwd should contain 1 to 64 characters,The question mark (?), double quote (\"), percent sign (%), and backslash (\\) may cause the RADIUS function to fail and are not recommended.")
    private @NotNull(message="Parameter [radiusPwd] should not be null.") @Pattern(regexp="^[\\041-\\0176]{1,128}$", message="RADIUS password should be 1~128 visible ASCII characters.") String radiusPwd;
    @Schema(name="radSecEnable", description="Radius RadSec enable status")
    private Boolean radSecEnable;
    @Schema(name="caCert", description="CA certification profile id")
    private String caCert;
    @Schema(name="clientCert", description="Client certification profile id")
    private String clientCert;

    public static RadiusAuthServerOpenApiVO toRadiusAuthServerOpenApiVO(RadiusAuthServerVO vo) {
        RadiusAuthServerOpenApiVO radiusAuthServerOpenApiVO = new RadiusAuthServerOpenApiVO();
        radiusAuthServerOpenApiVO.setRadiusServerIp(vo.getRadiusServerIp());
        radiusAuthServerOpenApiVO.setRadiusPort(vo.getRadiusPort());
        radiusAuthServerOpenApiVO.setRadiusPwd(vo.getRadiusPwd());
        radiusAuthServerOpenApiVO.setRadSecEnable(vo.getRadSecEnable());
        radiusAuthServerOpenApiVO.setCaCert(vo.getCaCert());
        radiusAuthServerOpenApiVO.setClientCert(vo.getClientCert());
        return radiusAuthServerOpenApiVO;
    }

    public static RadiusAuthServerVO toRadiusAuthServerVO(RadiusAuthServerOpenApiVO openApiVO) {
        RadiusAuthServerVO vo = new RadiusAuthServerVO();
        vo.setRadiusServerIp(openApiVO.getRadiusServerIp());
        vo.setRadiusPort(openApiVO.getRadiusPort());
        vo.setRadiusPwd(openApiVO.getRadiusPwd());
        vo.setRadSecEnable(openApiVO.getRadSecEnable());
        vo.setCaCert(openApiVO.getCaCert());
        vo.setClientCert(openApiVO.getClientCert());
        return vo;
    }

    @Generated
    public String getRadiusServerIp() {
        return this.radiusServerIp;
    }

    @Generated
    public Integer getRadiusPort() {
        return this.radiusPort;
    }

    @Generated
    public String getRadiusPwd() {
        return this.radiusPwd;
    }

    @Generated
    public Boolean getRadSecEnable() {
        return this.radSecEnable;
    }

    @Generated
    public String getCaCert() {
        return this.caCert;
    }

    @Generated
    public String getClientCert() {
        return this.clientCert;
    }

    @Generated
    public void setRadiusServerIp(String radiusServerIp) {
        this.radiusServerIp = radiusServerIp;
    }

    @Generated
    public void setRadiusPort(Integer radiusPort) {
        this.radiusPort = radiusPort;
    }

    @Generated
    public void setRadiusPwd(String radiusPwd) {
        this.radiusPwd = radiusPwd;
    }

    @Generated
    public void setRadSecEnable(Boolean radSecEnable) {
        this.radSecEnable = radSecEnable;
    }

    @Generated
    public void setCaCert(String caCert) {
        this.caCert = caCert;
    }

    @Generated
    public void setClientCert(String clientCert) {
        this.clientCert = clientCert;
    }

    @Generated
    public String toString() {
        return "RadiusAuthServerOpenApiVO(radiusServerIp=" + this.getRadiusServerIp() + ", radiusPort=" + this.getRadiusPort() + ", radiusPwd=" + this.getRadiusPwd() + ", radSecEnable=" + this.getRadSecEnable() + ", caCert=" + this.getCaCert() + ", clientCert=" + this.getClientCert() + ")";
    }

    @Generated
    public RadiusAuthServerOpenApiVO(String radiusServerIp, Integer radiusPort, String radiusPwd, Boolean radSecEnable, String caCert, String clientCert) {
        this.radiusServerIp = radiusServerIp;
        this.radiusPort = radiusPort;
        this.radiusPwd = radiusPwd;
        this.radSecEnable = radSecEnable;
        this.caCert = caCert;
        this.clientCert = clientCert;
    }

    @Generated
    public RadiusAuthServerOpenApiVO() {
    }
}

