/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.radiusprofile;

import com.tplink.nbu.common.pii.annotation.PII;
import com.tplink.nbu.common.pii.constant.PIIMaskStrategy;
import com.tplink.smb.omada.manager.configuration.api.web.site.authentication.radiusprofile.embed.RadiusAcctServerVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;

public class RadiusAcctServerOpenApiVO {
    @NotNull(message="Parameter [accountingServerIp] should not be null.")
    @PII(strategy=PIIMaskStrategy.ENCRYPT)
    @Pattern(regexp="((\\d{1,2}|1\\d\\d|2[0-4]\\d|25[0-5])(\\.(\\d{1,2}|1\\d\\d|2[0-4]\\d|25[0-5])){3}|([a-zA-Z0-9]([a-zA-Z0-9\\-]{0,61}[a-zA-Z0-9])?\\.)+[a-zA-Z]{2,6})", message="Parameter [accountingServerIp] Invalid.")
    @Schema(name="accountingServerIp", description="Radius Accounting Server IP.In Pro Site of the Omada Pro Controller, [accountingServerIp] should be a valid IP or domain address. In Omada Controller and Basic Site of the Omada Pro Controller, [accountingServerIp] should be a valid IP address.")
    private @NotNull(message="Parameter [accountingServerIp] should not be null.") @Pattern(regexp="((\\d{1,2}|1\\d\\d|2[0-4]\\d|25[0-5])(\\.(\\d{1,2}|1\\d\\d|2[0-4]\\d|25[0-5])){3}|([a-zA-Z0-9]([a-zA-Z0-9\\-]{0,61}[a-zA-Z0-9])?\\.)+[a-zA-Z]{2,6})", message="Parameter [accountingServerIp] Invalid.") String accountingServerIp;
    @Range(min=1L, max=65535L, message="Parameter [accountingServerPort] should between 1-65535.")
    @NotNull(message="Parameter [accountingServerPort] should not be null.")
    @Schema(name="accountingServerPort", description="Radius Accounting port. AccountingServerPort should be within the range of 1-65535")
    private @Range(min=1L, max=65535L, message="Parameter [accountingServerPort] should between 1-65535.") @NotNull(message="Parameter [accountingServerPort] should not be null.") Integer accountingServerPort;
    @NotNull(message="Parameter [accountingServerPwd] should not be null.")
    @PII(strategy=PIIMaskStrategy.ENCRYPT)
    @Schema(name="accountingServerPwd", description="Radius Accounting password,The question mark (?), double quote (\"), percent sign (%), and backslash (\\) may cause the RADIUS function to fail and are not recommended.")
    private @NotNull(message="Parameter [accountingServerPwd] should not be null.") String accountingServerPwd;
    @Schema(name="radSecEnable", description="Radius RadSec enable status")
    private Boolean radSecEnable;
    @Schema(name="caCert", description="CA certification profile id")
    private String caCert;
    @Schema(name="clientCert", description="Client certification profile id")
    private String clientCert;

    public static RadiusAcctServerOpenApiVO toRadiusAcctServerOpenApiVO(RadiusAcctServerVO vo) {
        RadiusAcctServerOpenApiVO radiusAcctServerOpenApiVO = new RadiusAcctServerOpenApiVO();
        radiusAcctServerOpenApiVO.setAccountingServerIp(vo.getAccountingServerIp());
        radiusAcctServerOpenApiVO.setAccountingServerPort(vo.getAccountingServerPort());
        radiusAcctServerOpenApiVO.setAccountingServerPwd(vo.getAccountingServerPwd());
        radiusAcctServerOpenApiVO.setRadSecEnable(vo.getRadSecEnable());
        radiusAcctServerOpenApiVO.setCaCert(vo.getCaCert());
        radiusAcctServerOpenApiVO.setClientCert(vo.getClientCert());
        return radiusAcctServerOpenApiVO;
    }

    public static RadiusAcctServerVO toRadiusAcctServerVO(RadiusAcctServerOpenApiVO openApiVO) {
        RadiusAcctServerVO vo = new RadiusAcctServerVO();
        vo.setAccountingServerIp(openApiVO.getAccountingServerIp());
        vo.setAccountingServerPort(openApiVO.getAccountingServerPort());
        vo.setAccountingServerPwd(openApiVO.getAccountingServerPwd());
        vo.setRadSecEnable(openApiVO.getRadSecEnable());
        vo.setCaCert(openApiVO.getCaCert());
        vo.setClientCert(openApiVO.getClientCert());
        return vo;
    }

    @Generated
    public String getAccountingServerIp() {
        return this.accountingServerIp;
    }

    @Generated
    public Integer getAccountingServerPort() {
        return this.accountingServerPort;
    }

    @Generated
    public String getAccountingServerPwd() {
        return this.accountingServerPwd;
    }

    @Generated
    public Boolean getRadSecEnable() {
        return this.radSecEnable;
    }

    @Generated
    public String getCaCert() {
        return this.caCert;
    }

    @Generated
    public String getClientCert() {
        return this.clientCert;
    }

    @Generated
    public void setAccountingServerIp(String accountingServerIp) {
        this.accountingServerIp = accountingServerIp;
    }

    @Generated
    public void setAccountingServerPort(Integer accountingServerPort) {
        this.accountingServerPort = accountingServerPort;
    }

    @Generated
    public void setAccountingServerPwd(String accountingServerPwd) {
        this.accountingServerPwd = accountingServerPwd;
    }

    @Generated
    public void setRadSecEnable(Boolean radSecEnable) {
        this.radSecEnable = radSecEnable;
    }

    @Generated
    public void setCaCert(String caCert) {
        this.caCert = caCert;
    }

    @Generated
    public void setClientCert(String clientCert) {
        this.clientCert = clientCert;
    }

    @Generated
    public String toString() {
        return "RadiusAcctServerOpenApiVO(accountingServerIp=" + this.getAccountingServerIp() + ", accountingServerPort=" + this.getAccountingServerPort() + ", accountingServerPwd=" + this.getAccountingServerPwd() + ", radSecEnable=" + this.getRadSecEnable() + ", caCert=" + this.getCaCert() + ", clientCert=" + this.getClientCert() + ")";
    }

    @Generated
    public RadiusAcctServerOpenApiVO(String accountingServerIp, Integer accountingServerPort, String accountingServerPwd, Boolean radSecEnable, String caCert, String clientCert) {
        this.accountingServerIp = accountingServerIp;
        this.accountingServerPort = accountingServerPort;
        this.accountingServerPwd = accountingServerPwd;
        this.radSecEnable = radSecEnable;
        this.caCert = caCert;
        this.clientCert = clientCert;
    }

    @Generated
    public RadiusAcctServerOpenApiVO() {
    }
}

