/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.radiusprofile;

import com.tplink.smb.omada.a.a;
import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.common.g.b;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.radiusprofile.RadiusUserInfoOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.authentication.radiusprofile.radiusserver.RadiusUserVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.Objects;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;

public class CreateRadiusUserOpenApiVO {
    @NotNull(message="Parameter [type] should nor be null.")
    @Range(min=0L, max=1L)
    @Schema(name="type", description="Type of Build-in Radius profile user, 0: user auth; 1: MAC auth")
    private @NotNull(message="Parameter [type] should nor be null.") @Range(min=0L, max=1L) Integer type;
    @Valid
    @Schema(name="userInfo", description="User name and password, required when parameter [type] is 0.")
    private RadiusUserInfoOpenApiVO userInfo;
    @Schema(name="macAddress", description="MAC address, required when parameter [type] is 1. Should be a valid MAC address format")
    @a
    private String macAddress;
    @Range(min=1L, max=0xA00000L, message="Value of limit is from 1 to 10485760 Kbps.")
    @Schema(name="upRateLimit", description="Build-in Radius profile user uplink rate limit, unit: Kbps. UpRateLimit should be within the range of 1-10485760")
    private @Range(min=1L, max=0xA00000L, message="Value of limit is from 1 to 10485760 Kbps.") Long upRateLimit;
    @Range(min=1L, max=0xA00000L, message="Value of limit is from 1 to 10485760 Kbps.")
    @Schema(name="downRateLimit", description="Build-in Radius profile user downlink rate limit, unit: Kbps. DownRateLimit should be within the range of 1-10485760")
    private @Range(min=1L, max=0xA00000L, message="Value of limit is from 1 to 10485760 Kbps.") Long downRateLimit;
    @Range(min=1L, max=0xA00000L, message="Value of limit is from 1 to 10485760 MB.")
    @Schema(name="upLimit", description="Build-in Radius profile user uplink traffic limit, unit: MB. UpLimit should be within the range of 1-10485760")
    private @Range(min=1L, max=0xA00000L, message="Value of limit is from 1 to 10485760 MB.") Long upLimit;
    @Range(min=1L, max=0xA00000L, message="Value of limit is from 1 to 10485760 MB.")
    @Schema(name="downLimit", description="Build-in Radius profile user downlink traffic limit, unit: MB. DownLimit should be within the range of 1-10485760")
    private @Range(min=1L, max=0xA00000L, message="Value of limit is from 1 to 10485760 MB.") Long downLimit;
    @Range(min=0L, max=4096L, message="Value of vlan is from 1 to 4096.")
    @Schema(name="vlanId", description="VLAN ID. VlanId should be within the range of 1-4096")
    private @Range(min=0L, max=4096L, message="Value of vlan is from 1 to 4096.") Integer vlanId;
    @Schema(name="timeout", description="Session timeout, unit: second")
    private Integer timeout;

    public OperationResponse check() {
        if (this.type == 0 && Objects.isNull(this.userInfo)) {
            return new OperationResponse(b.d, "Parameter [userInfo] should not be null.", null);
        }
        if (this.type == 1 && Objects.isNull(this.macAddress)) {
            return new OperationResponse(b.d, "Parameter [macAddress] should not be null.", null);
        }
        return OperationResponse.SUCCESS;
    }

    public RadiusUserVO toRadiusUserVO() {
        RadiusUserVO vo = new RadiusUserVO();
        vo.setType(this.type);
        vo.setUpRateLimit(this.upRateLimit);
        vo.setDownRateLimit(this.downRateLimit);
        vo.setUpLimit(this.upLimit);
        vo.setDownLimit(this.downLimit);
        vo.setVlanId(this.vlanId);
        vo.setTimeout(this.timeout);
        if (this.type == 0) {
            vo.setUsername(this.userInfo.getUsername());
            vo.setPassword(this.userInfo.getPassword());
        } else {
            vo.setUsername(this.macAddress);
            vo.setPassword(this.macAddress);
        }
        return vo;
    }

    @Generated
    public Integer getType() {
        return this.type;
    }

    @Generated
    public RadiusUserInfoOpenApiVO getUserInfo() {
        return this.userInfo;
    }

    @Generated
    public String getMacAddress() {
        return this.macAddress;
    }

    @Generated
    public Long getUpRateLimit() {
        return this.upRateLimit;
    }

    @Generated
    public Long getDownRateLimit() {
        return this.downRateLimit;
    }

    @Generated
    public Long getUpLimit() {
        return this.upLimit;
    }

    @Generated
    public Long getDownLimit() {
        return this.downLimit;
    }

    @Generated
    public Integer getVlanId() {
        return this.vlanId;
    }

    @Generated
    public Integer getTimeout() {
        return this.timeout;
    }

    @Generated
    public void setType(Integer type) {
        this.type = type;
    }

    @Generated
    public void setUserInfo(RadiusUserInfoOpenApiVO userInfo) {
        this.userInfo = userInfo;
    }

    @Generated
    public void setMacAddress(String macAddress) {
        this.macAddress = macAddress;
    }

    @Generated
    public void setUpRateLimit(Long upRateLimit) {
        this.upRateLimit = upRateLimit;
    }

    @Generated
    public void setDownRateLimit(Long downRateLimit) {
        this.downRateLimit = downRateLimit;
    }

    @Generated
    public void setUpLimit(Long upLimit) {
        this.upLimit = upLimit;
    }

    @Generated
    public void setDownLimit(Long downLimit) {
        this.downLimit = downLimit;
    }

    @Generated
    public void setVlanId(Integer vlanId) {
        this.vlanId = vlanId;
    }

    @Generated
    public void setTimeout(Integer timeout) {
        this.timeout = timeout;
    }

    @Generated
    public String toString() {
        return "CreateRadiusUserOpenApiVO(type=" + this.getType() + ", userInfo=" + this.getUserInfo() + ", macAddress=" + this.getMacAddress() + ", upRateLimit=" + this.getUpRateLimit() + ", downRateLimit=" + this.getDownRateLimit() + ", upLimit=" + this.getUpLimit() + ", downLimit=" + this.getDownLimit() + ", vlanId=" + this.getVlanId() + ", timeout=" + this.getTimeout() + ")";
    }

    @Generated
    public CreateRadiusUserOpenApiVO(Integer type, RadiusUserInfoOpenApiVO userInfo, String macAddress, Long upRateLimit, Long downRateLimit, Long upLimit, Long downLimit, Integer vlanId, Integer timeout) {
        this.type = type;
        this.userInfo = userInfo;
        this.macAddress = macAddress;
        this.upRateLimit = upRateLimit;
        this.downRateLimit = downRateLimit;
        this.upLimit = upLimit;
        this.downLimit = downLimit;
        this.vlanId = vlanId;
        this.timeout = timeout;
    }

    @Generated
    public CreateRadiusUserOpenApiVO() {
    }
}

