/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.radiusprofile;

import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.common.g.b;
import com.tplink.smb.omada.common.util.T;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.radiusprofile.RadiusAcctServerOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.radiusprofile.RadiusAuthServerOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.authentication.radiusprofile.RadiusProfileVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.authentication.radiusprofile.embed.RadiusCoaServerVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.Range;
import org.springframework.util.CollectionUtils;

public class CreateRadiusProfileOpenApiVO {
    @NotNull(message="Parameter [name] should not be null.")
    @Pattern(regexp="^[^ \\+\\-\\@\\=]$|^[^ \\+\\-\\@\\=].{0,62}[^ ]$", message="Radius profile name should be 1~64.")
    @Schema(name="name", description="Radius profile name should contain 1 to 64 characters")
    private @NotNull(message="Parameter [name] should not be null.") @Pattern(regexp="^[^ \\+\\-\\@\\=]$|^[^ \\+\\-\\@\\=].{0,62}[^ ]$", message="Radius profile name should be 1~64.") String name;
    @Valid
    @NotNull(message="Parameter [authServer] should not be null.")
    @Schema(name="authServer", description="Radius authentication server list")
    private @Valid @NotNull(message="Parameter [authServer] should not be null.") List<RadiusAuthServerOpenApiVO> authServer;
    @NotNull(message="Parameter [radiusAccountingEnable] should not be null.")
    @Schema(name="radiusAccountingEnable", description="Radius accounting enable status")
    private @NotNull(message="Parameter [radiusAccountingEnable] should not be null.") Boolean radiusAccountingEnable;
    @Schema(name="interimUpdateEnable", description="When radius accounting enables, interval update enable status")
    private Boolean interimUpdateEnable;
    @Range(min=60L, max=86400L, message="Parameter [interimUpdateInterval] should between 60 and 86400.")
    @Schema(name="interimUpdateInterval", description="When interval update enables, interval update duration, unit: second. InterimUpdateInterval should be within the range of 60-86400")
    private @Range(min=60L, max=86400L, message="Parameter [interimUpdateInterval] should between 60 and 86400.") Integer interimUpdateInterval;
    @Valid
    @Schema(name="acctServer", description="Radius accounting server list, valid when parameter [radiusAccountingEnable] is true")
    private List<RadiusAcctServerOpenApiVO> acctServer;
    @NotNull(message="Parameter [wirelessVlanAssignment] should not be null.")
    @Schema(name="wirelessVlanAssignment", description="VLAN assignment for wireless network enable status")
    private @NotNull(message="Parameter [wirelessVlanAssignment] should not be null.") Boolean wirelessVlanAssignment;
    @Schema(name="coaEnable", description="Radius CoA enable status")
    private Boolean coaEnable;
    @Length(min=1, max=128, message="CoaPassword should contain 1 to 128 characters")
    @Schema(name="coaPassword", description="Radius CoA password, required when parameter [coaEnable] is true. CoaPassword should contain 1 to 128 characters. The question mark (?), double quote (\"), percent sign (%), and backslash (\\) may cause the RADIUS function to fail and are not recommended.")
    private @Length(min=1, max=128, message="CoaPassword should contain 1 to 128 characters") String coaPassword;

    public OperationResponse check() {
        if (CollectionUtils.isEmpty(this.authServer)) {
            return new OperationResponse(b.d, "Parameter [authServer] should not be empty.", null);
        }
        if (this.authServer.size() > 4) {
            return new OperationResponse(b.d, "Parameter [authServer] size should not exceed 4.", null);
        }
        if (Boolean.TRUE.equals(this.radiusAccountingEnable) && Objects.isNull(this.interimUpdateEnable)) {
            return new OperationResponse(b.d, "Parameter [interimUpdateEnable] should not be null.", null);
        }
        if (Boolean.TRUE.equals(this.interimUpdateEnable) && Objects.isNull(this.interimUpdateInterval)) {
            return new OperationResponse(b.d, "Parameter [interimUpdateInterval] should not be null.", null);
        }
        if (Boolean.TRUE.equals(this.radiusAccountingEnable) && CollectionUtils.isEmpty(this.acctServer)) {
            return new OperationResponse(b.d, "Parameter [acctServer] should not be null or empty.", null);
        }
        if (Boolean.TRUE.equals(this.radiusAccountingEnable) && this.acctServer.size() > 4) {
            return new OperationResponse(b.d, "Parameter [acctServer] size should not exceed 4.", null);
        }
        if (Boolean.TRUE.equals(this.coaEnable) && Objects.isNull(this.coaPassword)) {
            return new OperationResponse(b.d, "Parameter [coaPassword] should not be null.", null);
        }
        return new OperationResponse(b.a);
    }

    public RadiusProfileVO toRadiusProfileVO() {
        RadiusProfileVO vo = new RadiusProfileVO();
        vo.setName(this.name);
        vo.setAuthServer(this.authServer.stream().filter(Objects::nonNull).map(RadiusAuthServerOpenApiVO::toRadiusAuthServerVO).collect(Collectors.toList()));
        vo.setRadiusAccountingEnable(this.radiusAccountingEnable);
        vo.setInterimUpdateEnable(this.interimUpdateEnable);
        vo.setInterimUpdateInterval(this.interimUpdateInterval);
        if (this.acctServer != null) {
            vo.setAcctServer(this.acctServer.stream().filter(Objects::nonNull).map(RadiusAcctServerOpenApiVO::toRadiusAcctServerVO).collect(Collectors.toList()));
        }
        vo.setWirelessVlanAssignment(this.wirelessVlanAssignment);
        vo.setCoaEnable(this.coaEnable);
        if (Boolean.TRUE.equals(this.coaEnable) && !T.a((String)this.coaPassword)) {
            RadiusCoaServerVO coaServerVO = new RadiusCoaServerVO();
            coaServerVO.setCoaPwd(this.coaPassword);
            ArrayList<RadiusCoaServerVO> coaServerVOList = new ArrayList<RadiusCoaServerVO>(1);
            coaServerVOList.add(coaServerVO);
            vo.setCoaServer(coaServerVOList);
        }
        return vo;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public List<RadiusAuthServerOpenApiVO> getAuthServer() {
        return this.authServer;
    }

    @Generated
    public Boolean getRadiusAccountingEnable() {
        return this.radiusAccountingEnable;
    }

    @Generated
    public Boolean getInterimUpdateEnable() {
        return this.interimUpdateEnable;
    }

    @Generated
    public Integer getInterimUpdateInterval() {
        return this.interimUpdateInterval;
    }

    @Generated
    public List<RadiusAcctServerOpenApiVO> getAcctServer() {
        return this.acctServer;
    }

    @Generated
    public Boolean getWirelessVlanAssignment() {
        return this.wirelessVlanAssignment;
    }

    @Generated
    public Boolean getCoaEnable() {
        return this.coaEnable;
    }

    @Generated
    public String getCoaPassword() {
        return this.coaPassword;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setAuthServer(List<RadiusAuthServerOpenApiVO> authServer) {
        this.authServer = authServer;
    }

    @Generated
    public void setRadiusAccountingEnable(Boolean radiusAccountingEnable) {
        this.radiusAccountingEnable = radiusAccountingEnable;
    }

    @Generated
    public void setInterimUpdateEnable(Boolean interimUpdateEnable) {
        this.interimUpdateEnable = interimUpdateEnable;
    }

    @Generated
    public void setInterimUpdateInterval(Integer interimUpdateInterval) {
        this.interimUpdateInterval = interimUpdateInterval;
    }

    @Generated
    public void setAcctServer(List<RadiusAcctServerOpenApiVO> acctServer) {
        this.acctServer = acctServer;
    }

    @Generated
    public void setWirelessVlanAssignment(Boolean wirelessVlanAssignment) {
        this.wirelessVlanAssignment = wirelessVlanAssignment;
    }

    @Generated
    public void setCoaEnable(Boolean coaEnable) {
        this.coaEnable = coaEnable;
    }

    @Generated
    public void setCoaPassword(String coaPassword) {
        this.coaPassword = coaPassword;
    }

    @Generated
    public String toString() {
        return "CreateRadiusProfileOpenApiVO(name=" + this.getName() + ", authServer=" + this.getAuthServer() + ", radiusAccountingEnable=" + this.getRadiusAccountingEnable() + ", interimUpdateEnable=" + this.getInterimUpdateEnable() + ", interimUpdateInterval=" + this.getInterimUpdateInterval() + ", acctServer=" + this.getAcctServer() + ", wirelessVlanAssignment=" + this.getWirelessVlanAssignment() + ", coaEnable=" + this.getCoaEnable() + ", coaPassword=" + this.getCoaPassword() + ")";
    }

    @Generated
    public CreateRadiusProfileOpenApiVO(String name, List<RadiusAuthServerOpenApiVO> authServer, Boolean radiusAccountingEnable, Boolean interimUpdateEnable, Integer interimUpdateInterval, List<RadiusAcctServerOpenApiVO> acctServer, Boolean wirelessVlanAssignment, Boolean coaEnable, String coaPassword) {
        this.name = name;
        this.authServer = authServer;
        this.radiusAccountingEnable = radiusAccountingEnable;
        this.interimUpdateEnable = interimUpdateEnable;
        this.interimUpdateInterval = interimUpdateInterval;
        this.acctServer = acctServer;
        this.wirelessVlanAssignment = wirelessVlanAssignment;
        this.coaEnable = coaEnable;
        this.coaPassword = coaPassword;
    }

    @Generated
    public CreateRadiusProfileOpenApiVO() {
    }
}

