/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.ldapprofile;

import com.tplink.smb.omada.manager.configuration.api.web.site.authentication.dto.LdapProfileVO;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import lombok.Generated;

public class LdapProfileOpenApiVO {
    @Schema(name="ldapProfileId", description="LDAP profile ID")
    private String ldapProfileId;
    @Schema(name="name", description="LDAP profile name")
    private String name;
    @Schema(name="status", description="LDAP profile enable status")
    private Boolean status;
    @Schema(name="bindType", description="Type of LDAP bind, 0: Simple Mode\uff1b1: Anonymous Mode; 2: Regular Mode")
    private Integer bindType;
    @Schema(name="server", description="LDAP server address")
    private String server;
    @Schema(name="dstPort", description="LDAP server listening port. When SSL is not enabled, it is generally 389, and when SSL is enabled, it is generally 636")
    private Integer dstPort;
    @Schema(name="useSsl", description="LDAP server enable ssl status")
    private Boolean useSsl;
    @Schema(name="cn", description="LDAP server common name")
    private String cn;
    @Schema(name="baseDn", description="LDAP server base distinguish name")
    private String baseDn;
    @Schema(name="groupDn", description="LDAP server group distinguish name, optional when parameter [type] is 1 or 2")
    private String groupDn;
    @Schema(name="filter", description="Additional filter, optional when parameter [type] is 1 or 2")
    private String filter;
    @Schema(name="regularDn", description="Regular Dn, valid when parameter [type] is 2")
    private String regularDn;
    @Schema(name="regularPassword", description="Regular Password, valid when parameter [type] is 2")
    private String regularPassword;

    public static LdapProfileOpenApiVO toOpenApiVO(LdapProfileVO vo) {
        LdapProfileOpenApiVO openApiVO = new LdapProfileOpenApiVO();
        openApiVO.setLdapProfileId(vo.getLdapProfileId());
        openApiVO.setName(vo.getName());
        openApiVO.setStatus(vo.getStatus());
        openApiVO.setBindType(vo.getBindType());
        openApiVO.setServer(vo.getServer());
        openApiVO.setDstPort(vo.getDstPort());
        openApiVO.setUseSsl(vo.getUseSsl());
        openApiVO.setCn(vo.getCn());
        openApiVO.setBaseDn(vo.getBaseDn());
        if (Objects.equals(vo.getBindType(), 1) || Objects.equals(vo.getBindType(), 2)) {
            openApiVO.setGroupDn(vo.getGroupDn()).setFilter(vo.getFilter());
        }
        if (Objects.equals(vo.getBindType(), 2)) {
            openApiVO.setRegularDn(vo.getRegularDn()).setRegularPassword(vo.getRegularPassword());
        }
        return openApiVO;
    }

    @Generated
    public String getLdapProfileId() {
        return this.ldapProfileId;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Boolean getStatus() {
        return this.status;
    }

    @Generated
    public Integer getBindType() {
        return this.bindType;
    }

    @Generated
    public String getServer() {
        return this.server;
    }

    @Generated
    public Integer getDstPort() {
        return this.dstPort;
    }

    @Generated
    public Boolean getUseSsl() {
        return this.useSsl;
    }

    @Generated
    public String getCn() {
        return this.cn;
    }

    @Generated
    public String getBaseDn() {
        return this.baseDn;
    }

    @Generated
    public String getGroupDn() {
        return this.groupDn;
    }

    @Generated
    public String getFilter() {
        return this.filter;
    }

    @Generated
    public String getRegularDn() {
        return this.regularDn;
    }

    @Generated
    public String getRegularPassword() {
        return this.regularPassword;
    }

    @Generated
    public LdapProfileOpenApiVO setLdapProfileId(String ldapProfileId) {
        this.ldapProfileId = ldapProfileId;
        return this;
    }

    @Generated
    public LdapProfileOpenApiVO setName(String name) {
        this.name = name;
        return this;
    }

    @Generated
    public LdapProfileOpenApiVO setStatus(Boolean status) {
        this.status = status;
        return this;
    }

    @Generated
    public LdapProfileOpenApiVO setBindType(Integer bindType) {
        this.bindType = bindType;
        return this;
    }

    @Generated
    public LdapProfileOpenApiVO setServer(String server) {
        this.server = server;
        return this;
    }

    @Generated
    public LdapProfileOpenApiVO setDstPort(Integer dstPort) {
        this.dstPort = dstPort;
        return this;
    }

    @Generated
    public LdapProfileOpenApiVO setUseSsl(Boolean useSsl) {
        this.useSsl = useSsl;
        return this;
    }

    @Generated
    public LdapProfileOpenApiVO setCn(String cn) {
        this.cn = cn;
        return this;
    }

    @Generated
    public LdapProfileOpenApiVO setBaseDn(String baseDn) {
        this.baseDn = baseDn;
        return this;
    }

    @Generated
    public LdapProfileOpenApiVO setGroupDn(String groupDn) {
        this.groupDn = groupDn;
        return this;
    }

    @Generated
    public LdapProfileOpenApiVO setFilter(String filter) {
        this.filter = filter;
        return this;
    }

    @Generated
    public LdapProfileOpenApiVO setRegularDn(String regularDn) {
        this.regularDn = regularDn;
        return this;
    }

    @Generated
    public LdapProfileOpenApiVO setRegularPassword(String regularPassword) {
        this.regularPassword = regularPassword;
        return this;
    }

    @Generated
    public String toString() {
        return "LdapProfileOpenApiVO(ldapProfileId=" + this.getLdapProfileId() + ", name=" + this.getName() + ", status=" + this.getStatus() + ", bindType=" + this.getBindType() + ", server=" + this.getServer() + ", dstPort=" + this.getDstPort() + ", useSsl=" + this.getUseSsl() + ", cn=" + this.getCn() + ", baseDn=" + this.getBaseDn() + ", groupDn=" + this.getGroupDn() + ", filter=" + this.getFilter() + ", regularDn=" + this.getRegularDn() + ", regularPassword=" + this.getRegularPassword() + ")";
    }

    @Generated
    public LdapProfileOpenApiVO(String ldapProfileId, String name, Boolean status, Integer bindType, String server, Integer dstPort, Boolean useSsl, String cn, String baseDn, String groupDn, String filter, String regularDn, String regularPassword) {
        this.ldapProfileId = ldapProfileId;
        this.name = name;
        this.status = status;
        this.bindType = bindType;
        this.server = server;
        this.dstPort = dstPort;
        this.useSsl = useSsl;
        this.cn = cn;
        this.baseDn = baseDn;
        this.groupDn = groupDn;
        this.filter = filter;
        this.regularDn = regularDn;
        this.regularPassword = regularPassword;
    }

    @Generated
    public LdapProfileOpenApiVO() {
    }
}

