/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.ldapprofile;

import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.common.g.b;
import com.tplink.smb.omada.common.util.T;
import com.tplink.smb.omada.common.validator.anons.NumberSet;
import com.tplink.smb.omada.manager.configuration.api.web.site.authentication.dto.LdapProfileVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import lombok.Generated;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.Range;

public class CreateLdapProfileOpenApiVO {
    @NotNull(message="Parameter [name] should not be null.")
    @Pattern(regexp="^[^ ]$|^[^ ].{0,62}[^ ]$", message="Parameter [name] should be 1-64 bit arbitrary characters.")
    @Schema(name="name", description="LDAP profile name. Name should contain 1 to 64 characters")
    private @NotNull(message="Parameter [name] should not be null.") @Pattern(regexp="^[^ ]$|^[^ ].{0,62}[^ ]$", message="Parameter [name] should be 1-64 bit arbitrary characters.") String name;
    @NotNull(message="Parameter [status] should not be null.")
    @Schema(name="status", description="LDAP profile enable status")
    private @NotNull(message="Parameter [status] should not be null.") Boolean status;
    @NotNull(message="Parameter [bindType] should not be null.")
    @NumberSet(value={0, 1, 2})
    @Schema(name="bindType", description="Type of LDAP bind. BindType should be a value as follows: 0: Simple Mode; 1: Anonymous Mode; 2: Regular Mode")
    private @NotNull(message="Parameter [bindType] should not be null.") Integer bindType;
    @NotNull(message="Parameter [server] should not be null.")
    @Schema(name="server", description="LDAP server address")
    private @NotNull(message="Parameter [server] should not be null.") String server;
    @NotNull(message="Parameter [dstPort] should not be null.")
    @Range(min=0L, max=65535L, message="Parameter [dstPort] should be a integer between 0 and 65535.")
    @Schema(name="dstPort", description="LDAP server listening port. dstPort should be within the range of 0-65535. When SSL is not enabled, it is generally 389, and when SSL is enabled, it is generally 636")
    private @NotNull(message="Parameter [dstPort] should not be null.") @Range(min=0L, max=65535L, message="Parameter [dstPort] should be a integer between 0 and 65535.") Integer dstPort;
    @NotNull(message="Parameter [useSsl] should not be null.")
    @Schema(name="useSsl", description="LDAP server enable ssl status")
    private @NotNull(message="Parameter [useSsl] should not be null.") Boolean useSsl;
    @Length(min=1, max=64, message="Cn should contain 1 to 64 characters.")
    @NotNull(message="Parameter [cn] should not be null.")
    @Schema(name="cn", description="LDAP server common name, for example: cn, uid. Cn should contain 1 to 64 characters")
    private @Length(min=1, max=64, message="Cn should contain 1 to 64 characters.") @NotNull(message="Parameter [cn] should not be null.") String cn;
    @Length(min=1, max=512, message="BaseDn should contain 1 to 512 characters.")
    @NotNull(message="Parameter [baseDn] should not be null.")
    @Schema(name="baseDn", description="LDAP server base distinguish name, for example: dc=xxx,dc=com. BaseDn should contain 1 to 512 characters.")
    private @Length(min=1, max=512, message="BaseDn should contain 1 to 512 characters.") @NotNull(message="Parameter [baseDn] should not be null.") String baseDn;
    @Length(min=1, max=512, message="GroupDn should contain 1 to 512 characters.")
    @Schema(name="groupDn", description="LDAP server group distinguish name, optional when parameter [type] is 1 or 2. For example: ou=xxx,dc=xxx,dc=com. GroupDn should contain 1 to 512 characters")
    private @Length(min=1, max=512, message="GroupDn should contain 1 to 512 characters.") String groupDn;
    @Length(min=1, max=512, message="Filter should contain 1 to 512 characters.")
    @Schema(name="filter", description="Additional filter, optional when parameter [type] is 1 or 2. For example: ou=xxx. Filter should contain 1 to 512 characters")
    private @Length(min=1, max=512, message="Filter should contain 1 to 512 characters.") String filter;
    @Length(min=1, max=256, message="RegularDn should contain 1 to 256 characters.")
    @Schema(name="regularDn", description="Regular Dn, required when parameter [type] is 2. RegularDn should contain 1 to 256 characters")
    private @Length(min=1, max=256, message="RegularDn should contain 1 to 256 characters.") String regularDn;
    @Length(min=1, max=256, message="RegularPassword should contain 1 to 256 characters.")
    @Schema(name="regularPassword", description="Regular Password, required when parameter [type] is 2. RegularPassword should contain 1 to 256 characters")
    private @Length(min=1, max=256, message="RegularPassword should contain 1 to 256 characters.") String regularPassword;

    public OperationResponse check() {
        if (this.bindType == 2 && T.a((String)this.regularDn)) {
            return new OperationResponse(b.d, "Parameter [regularDn] should not be null", null);
        }
        if (this.bindType == 2 && T.a((String)this.regularPassword)) {
            return new OperationResponse(b.d, "Parameter [regularPassword] should not be null", null);
        }
        if (T.a((String)this.cn)) {
            return new OperationResponse(b.d, "Parameter [cn] should not be empty", null);
        }
        if (T.a((String)this.baseDn)) {
            return new OperationResponse(b.d, "Parameter [baseDn] should not be empty", null);
        }
        return OperationResponse.SUCCESS;
    }

    public LdapProfileVO toVO() {
        LdapProfileVO vo = new LdapProfileVO();
        vo.setName(this.name);
        vo.setStatus(this.status);
        vo.setBindType(this.bindType);
        vo.setServer(this.server);
        vo.setDstPort(this.dstPort);
        vo.setUseSsl(this.useSsl);
        vo.setCn(this.cn);
        vo.setBaseDn(this.baseDn);
        if (this.bindType == 2 || this.bindType == 1) {
            vo.setGroupDn(this.groupDn);
            vo.setFilter(this.filter);
        }
        if (this.bindType == 2) {
            vo.setRegularDn(this.regularDn);
            vo.setRegularPassword(this.regularPassword);
        }
        return vo;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Boolean getStatus() {
        return this.status;
    }

    @Generated
    public Integer getBindType() {
        return this.bindType;
    }

    @Generated
    public String getServer() {
        return this.server;
    }

    @Generated
    public Integer getDstPort() {
        return this.dstPort;
    }

    @Generated
    public Boolean getUseSsl() {
        return this.useSsl;
    }

    @Generated
    public String getCn() {
        return this.cn;
    }

    @Generated
    public String getBaseDn() {
        return this.baseDn;
    }

    @Generated
    public String getGroupDn() {
        return this.groupDn;
    }

    @Generated
    public String getFilter() {
        return this.filter;
    }

    @Generated
    public String getRegularDn() {
        return this.regularDn;
    }

    @Generated
    public String getRegularPassword() {
        return this.regularPassword;
    }

    @Generated
    public CreateLdapProfileOpenApiVO setName(String name) {
        this.name = name;
        return this;
    }

    @Generated
    public CreateLdapProfileOpenApiVO setStatus(Boolean status) {
        this.status = status;
        return this;
    }

    @Generated
    public CreateLdapProfileOpenApiVO setBindType(Integer bindType) {
        this.bindType = bindType;
        return this;
    }

    @Generated
    public CreateLdapProfileOpenApiVO setServer(String server) {
        this.server = server;
        return this;
    }

    @Generated
    public CreateLdapProfileOpenApiVO setDstPort(Integer dstPort) {
        this.dstPort = dstPort;
        return this;
    }

    @Generated
    public CreateLdapProfileOpenApiVO setUseSsl(Boolean useSsl) {
        this.useSsl = useSsl;
        return this;
    }

    @Generated
    public CreateLdapProfileOpenApiVO setCn(String cn) {
        this.cn = cn;
        return this;
    }

    @Generated
    public CreateLdapProfileOpenApiVO setBaseDn(String baseDn) {
        this.baseDn = baseDn;
        return this;
    }

    @Generated
    public CreateLdapProfileOpenApiVO setGroupDn(String groupDn) {
        this.groupDn = groupDn;
        return this;
    }

    @Generated
    public CreateLdapProfileOpenApiVO setFilter(String filter) {
        this.filter = filter;
        return this;
    }

    @Generated
    public CreateLdapProfileOpenApiVO setRegularDn(String regularDn) {
        this.regularDn = regularDn;
        return this;
    }

    @Generated
    public CreateLdapProfileOpenApiVO setRegularPassword(String regularPassword) {
        this.regularPassword = regularPassword;
        return this;
    }

    @Generated
    public String toString() {
        return "CreateLdapProfileOpenApiVO(name=" + this.getName() + ", status=" + this.getStatus() + ", bindType=" + this.getBindType() + ", server=" + this.getServer() + ", dstPort=" + this.getDstPort() + ", useSsl=" + this.getUseSsl() + ", cn=" + this.getCn() + ", baseDn=" + this.getBaseDn() + ", groupDn=" + this.getGroupDn() + ", filter=" + this.getFilter() + ", regularDn=" + this.getRegularDn() + ", regularPassword=" + this.getRegularPassword() + ")";
    }

    @Generated
    public CreateLdapProfileOpenApiVO(String name, Boolean status, Integer bindType, String server, Integer dstPort, Boolean useSsl, String cn, String baseDn, String groupDn, String filter, String regularDn, String regularPassword) {
        this.name = name;
        this.status = status;
        this.bindType = bindType;
        this.server = server;
        this.dstPort = dstPort;
        this.useSsl = useSsl;
        this.cn = cn;
        this.baseDn = baseDn;
        this.groupDn = groupDn;
        this.filter = filter;
        this.regularDn = regularDn;
        this.regularPassword = regularPassword;
    }

    @Generated
    public CreateLdapProfileOpenApiVO() {
    }
}

