/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.ldapprofile;

import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.common.g.b;
import com.tplink.smb.omada.common.util.T;
import com.tplink.smb.omada.common.validator.anons.NumberSet;
import com.tplink.smb.omada.manager.configuration.api.web.site.authentication.dto.GoogleLdapProfileVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import lombok.Generated;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.Range;

public class CreateGoogleLdapProfileOpenApiVO {
    @NotNull(message="Parameter [name] should not be null.")
    @Pattern(regexp="^[^ ]$|^[^ ].{0,62}[^ ]$", message="Parameter [name] should be 1-64 bit arbitrary characters.")
    @Schema(name="name", description="Google LDAP profile name. Name should contain 1 to 64 characters.")
    private @NotNull(message="Parameter [name] should not be null.") @Pattern(regexp="^[^ ]$|^[^ ].{0,62}[^ ]$", message="Parameter [name] should be 1-64 bit arbitrary characters.") String name;
    @NotNull(message="Parameter [status] should not be null.")
    @Schema(name="status", description="LDAP profile enable status.")
    private @NotNull(message="Parameter [status] should not be null.") Boolean status;
    @NotNull(message="Parameter [bindType] should not be null.")
    @NumberSet(value={0, 1, 2})
    @Schema(name="bindType", description="Type of LDAP bind. BindType should be a value as follows: 0: Simple Mode; 2: Regular Mode.")
    private @NotNull(message="Parameter [bindType] should not be null.") Integer bindType;
    @NotNull(message="Parameter [server] should not be null.")
    @Pattern(regexp="((\\d{1,2}|1\\d\\d|2[0-4]\\d|25[0-5])(\\.(\\d{1,2}|1\\d\\d|2[0-4]\\d|25[0-5])){3}|([a-zA-Z0-9]([a-zA-Z0-9\\-]{0,61}[a-zA-Z0-9])?\\.)+[a-zA-Z]{2,6})", message="Parameter [server] should be a valid ip address or domain name.")
    @Schema(name="server", description="LDAP server address.")
    private @NotNull(message="Parameter [server] should not be null.") @Pattern(regexp="((\\d{1,2}|1\\d\\d|2[0-4]\\d|25[0-5])(\\.(\\d{1,2}|1\\d\\d|2[0-4]\\d|25[0-5])){3}|([a-zA-Z0-9]([a-zA-Z0-9\\-]{0,61}[a-zA-Z0-9])?\\.)+[a-zA-Z]{2,6})", message="Parameter [server] should be a valid ip address or domain name.") String server;
    @NotNull(message="Parameter [port] should not be null.")
    @Range(min=0L, max=65535L, message="Parameter [dstPort] should be a integer between 0 and 65535.")
    @Schema(name="port", description="LDAP server listening port. dstPort should be within the range of 0-65535. It is generally 636.")
    private @NotNull(message="Parameter [port] should not be null.") @Range(min=0L, max=65535L, message="Parameter [dstPort] should be a integer between 0 and 65535.") Integer port;
    @Length(min=1, max=64, message="Cn should contain 1 to 64 characters.")
    @NotNull(message="Parameter [cn] should not be null.")
    @Schema(name="cn", description="LDAP server common name, for example: cn, uid. Cn should contain 1 to 64 characters.")
    private @Length(min=1, max=64, message="Cn should contain 1 to 64 characters.") @NotNull(message="Parameter [cn] should not be null.") String cn;
    @Length(min=1, max=512, message="BaseDn should contain 1 to 512 characters.")
    @NotNull(message="Parameter [baseDn] should not be null.")
    @Schema(name="baseDn", description="LDAP server base distinguish name, for example: dc=xxx,dc=com. BaseDn should contain 1 to 512 characters.")
    private @Length(min=1, max=512, message="BaseDn should contain 1 to 512 characters.") @NotNull(message="Parameter [baseDn] should not be null.") String baseDn;
    @Length(min=1, max=512, message="Filter should contain 1 to 512 characters.")
    @Schema(name="filter", description="Additional filter, optional when parameter [type] is 1 or 2. For example: ou=xxx. Filter should contain 1 to 512 characters.")
    private @Length(min=1, max=512, message="Filter should contain 1 to 512 characters.") String filter;
    @Length(min=1, max=256, message="Account should contain 1 to 256 characters.")
    @Schema(name="account", description="Account, required when parameter [type] is 2. account should contain 1 to 256 characters.")
    private @Length(min=1, max=256, message="Account should contain 1 to 256 characters.") String account;
    @Length(min=6, max=256, message="password should contain 6 to 256 characters.")
    @Schema(name="password", description="Password, required when parameter [type] is 2. password should contain 6 to 256 characters.")
    private @Length(min=6, max=256, message="password should contain 6 to 256 characters.") String password;

    public OperationResponse check() {
        if (this.bindType == 2 && T.a((String)this.account)) {
            return new OperationResponse(b.d, "Parameter [account] should not be null", null);
        }
        if (this.bindType == 2 && T.a((String)this.password)) {
            return new OperationResponse(b.d, "Parameter [password] should not be null", null);
        }
        return OperationResponse.SUCCESS;
    }

    public GoogleLdapProfileVO toVO() {
        GoogleLdapProfileVO vo = new GoogleLdapProfileVO();
        vo.setName(this.name);
        vo.setStatus(this.status);
        vo.setBindType(this.bindType);
        vo.setServer(this.server);
        vo.setPort(this.port);
        vo.setCn(this.cn);
        vo.setBaseDn(this.baseDn);
        vo.setFilter(this.filter);
        if (this.bindType == 2) {
            vo.setAccount(this.account);
            vo.setPassword(this.password);
        }
        return vo;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Boolean getStatus() {
        return this.status;
    }

    @Generated
    public Integer getBindType() {
        return this.bindType;
    }

    @Generated
    public String getServer() {
        return this.server;
    }

    @Generated
    public Integer getPort() {
        return this.port;
    }

    @Generated
    public String getCn() {
        return this.cn;
    }

    @Generated
    public String getBaseDn() {
        return this.baseDn;
    }

    @Generated
    public String getFilter() {
        return this.filter;
    }

    @Generated
    public String getAccount() {
        return this.account;
    }

    @Generated
    public String getPassword() {
        return this.password;
    }

    @Generated
    public CreateGoogleLdapProfileOpenApiVO setName(String name) {
        this.name = name;
        return this;
    }

    @Generated
    public CreateGoogleLdapProfileOpenApiVO setStatus(Boolean status) {
        this.status = status;
        return this;
    }

    @Generated
    public CreateGoogleLdapProfileOpenApiVO setBindType(Integer bindType) {
        this.bindType = bindType;
        return this;
    }

    @Generated
    public CreateGoogleLdapProfileOpenApiVO setServer(String server) {
        this.server = server;
        return this;
    }

    @Generated
    public CreateGoogleLdapProfileOpenApiVO setPort(Integer port) {
        this.port = port;
        return this;
    }

    @Generated
    public CreateGoogleLdapProfileOpenApiVO setCn(String cn) {
        this.cn = cn;
        return this;
    }

    @Generated
    public CreateGoogleLdapProfileOpenApiVO setBaseDn(String baseDn) {
        this.baseDn = baseDn;
        return this;
    }

    @Generated
    public CreateGoogleLdapProfileOpenApiVO setFilter(String filter) {
        this.filter = filter;
        return this;
    }

    @Generated
    public CreateGoogleLdapProfileOpenApiVO setAccount(String account) {
        this.account = account;
        return this;
    }

    @Generated
    public CreateGoogleLdapProfileOpenApiVO setPassword(String password) {
        this.password = password;
        return this;
    }

    @Generated
    public String toString() {
        return "CreateGoogleLdapProfileOpenApiVO(name=" + this.getName() + ", status=" + this.getStatus() + ", bindType=" + this.getBindType() + ", server=" + this.getServer() + ", port=" + this.getPort() + ", cn=" + this.getCn() + ", baseDn=" + this.getBaseDn() + ", filter=" + this.getFilter() + ", account=" + this.getAccount() + ", password=" + this.getPassword() + ")";
    }

    @Generated
    public CreateGoogleLdapProfileOpenApiVO(String name, Boolean status, Integer bindType, String server, Integer port, String cn, String baseDn, String filter, String account, String password) {
        this.name = name;
        this.status = status;
        this.bindType = bindType;
        this.server = server;
        this.port = port;
        this.cn = cn;
        this.baseDn = baseDn;
        this.filter = filter;
        this.account = account;
        this.password = password;
    }

    @Generated
    public CreateGoogleLdapProfileOpenApiVO() {
    }
}

