/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.groupprofile;

import com.tplink.smb.omada.manager.configuration.api.web.site.profile.dto.embed.PortMaskVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.annotation.Nonnull;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;

public class PortMaskOpenApiVO {
    @NotNull
    @Range(min=0L, max=65535L, message="Parameter [port] should between 0-65535.")
    @Schema(name="port", description="Port should be within the range of 0-65535")
    private @NotNull @Range(min=0L, max=65535L, message="Parameter [port] should between 0-65535.") Integer port;
    @NotNull
    @Pattern(regexp="^[0-9a-fA-F]{4}$", message="Parameter [mask] should be 4 hex number(0-9, A-F).")
    @Schema(name="mask", description="Port mask should be 4 hex number(0-9, A-F), e.g. 0000 or FFFF")
    private @NotNull @Pattern(regexp="^[0-9a-fA-F]{4}$", message="Parameter [mask] should be 4 hex number(0-9, A-F).") String mask;

    public static PortMaskOpenApiVO toPortMaskOpenApiVO(@Nonnull PortMaskVO vo) {
        PortMaskOpenApiVO portMaskOpenApiVO = new PortMaskOpenApiVO();
        portMaskOpenApiVO.setPort(vo.getPort());
        portMaskOpenApiVO.setMask(vo.getMask());
        return portMaskOpenApiVO;
    }

    public static PortMaskVO toPortMaskVO(@Nonnull PortMaskOpenApiVO openApiVO) {
        PortMaskVO vo = new PortMaskVO();
        vo.setPort(openApiVO.getPort());
        vo.setMask(openApiVO.getMask());
        return vo;
    }

    @Generated
    public Integer getPort() {
        return this.port;
    }

    @Generated
    public String getMask() {
        return this.mask;
    }

    @Generated
    public void setPort(Integer port) {
        this.port = port;
    }

    @Generated
    public void setMask(String mask) {
        this.mask = mask;
    }

    @Generated
    public String toString() {
        return "PortMaskOpenApiVO(port=" + this.getPort() + ", mask=" + this.getMask() + ")";
    }

    @Generated
    public PortMaskOpenApiVO(Integer port, String mask) {
        this.port = port;
        this.mask = mask;
    }

    @Generated
    public PortMaskOpenApiVO() {
    }
}

