/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.groupprofile;

import com.tplink.smb.omada.manager.configuration.api.web.site.profile.dto.embed.IPSubnetsVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.annotation.Nonnull;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;

public class IPSubnetsOpenApiVO {
    @NotNull
    @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Invalid parameter format [ip] in ipList.")
    @Schema(name="ip", description="IP address, should be a valid IP format")
    private @NotNull @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Invalid parameter format [ip] in ipList.") String ip;
    @NotNull
    @Range(min=1L, max=32L, message="Parameter [mask] should be a integer between 1 and 32.")
    @Schema(name="mask", description="IP mask, mask should be within the range of 1-32")
    private @NotNull @Range(min=1L, max=32L, message="Parameter [mask] should be a integer between 1 and 32.") Integer mask;
    @Pattern(regexp="^$|^[^ ]$|^[^ ].{0,510}[^ ]$", message="Parameter [description] should be 1 - 512 characters")
    @Schema(name="description", description="IP description, description should contain 1 to 512 characters.")
    private @Pattern(regexp="^$|^[^ ]$|^[^ ].{0,510}[^ ]$", message="Parameter [description] should be 1 - 512 characters") String description;

    public static IPSubnetsOpenApiVO toIPSubnetsOpenApiVO(@Nonnull IPSubnetsVO vo) {
        IPSubnetsOpenApiVO ipSubnetsOpenApiVO = new IPSubnetsOpenApiVO();
        ipSubnetsOpenApiVO.setIp(vo.getIp());
        ipSubnetsOpenApiVO.setMask(vo.getMask());
        ipSubnetsOpenApiVO.setDescription(vo.getDescription());
        return ipSubnetsOpenApiVO;
    }

    public static IPSubnetsVO toIPSubnetsVO(@Nonnull IPSubnetsOpenApiVO openApiVO) {
        IPSubnetsVO vo = new IPSubnetsVO();
        vo.setIp(openApiVO.getIp());
        vo.setMask(openApiVO.getMask());
        vo.setDescription(openApiVO.getDescription());
        return vo;
    }

    @Generated
    public String getIp() {
        return this.ip;
    }

    @Generated
    public Integer getMask() {
        return this.mask;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public void setIp(String ip) {
        this.ip = ip;
    }

    @Generated
    public void setMask(Integer mask) {
        this.mask = mask;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public String toString() {
        return "IPSubnetsOpenApiVO(ip=" + this.getIp() + ", mask=" + this.getMask() + ", description=" + this.getDescription() + ")";
    }

    @Generated
    public IPSubnetsOpenApiVO(String ip, Integer mask, String description) {
        this.ip = ip;
        this.mask = mask;
        this.description = description;
    }

    @Generated
    public IPSubnetsOpenApiVO() {
    }
}

