/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.groupprofile;

import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.groupprofile.DomainOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.groupprofile.IPSubnetsOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.groupprofile.IPv6SubnetsOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.groupprofile.MacAddressOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.groupprofile.PortMaskOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.profile.dto.GroupVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.util.CollectionUtils;

public class GroupOpenApiVO {
    @Schema(name="groupId", description="Group profile ID")
    private String groupId;
    @Schema(name="name", description="Group profile name")
    private String name;
    @Schema(name="type", description="Type of group profile. 0: IP Group; 1: IP Port Group; 2: MAC Group; 3: IPv6 Group; 4: IPv6 Port Group; 5: Country Group; 7: Domain Group")
    private Integer type;
    @Schema(name="count", description="Count of list entries")
    private Integer count;
    @Schema(name="buildIn", description="Is this profile a built-in profile")
    private Boolean buildIn;
    @Valid
    @Schema(name="ipList", description="IP subnet info list. [type] value of 0 or 1 is required")
    private List<IPSubnetsOpenApiVO> ipList;
    @Valid
    @Schema(name="ipv6List", description="IPv6 subnet info list. [type] value of 3 or 4 is required")
    private List<IPv6SubnetsOpenApiVO> ipv6List;
    @Schema(name="portType", description="Port type. 0: port range 1: port mask. Valid when [type] is 1 or 4")
    private Integer portType;
    @Schema(name="portList", description="Port list. Valid when [portType] is 0")
    private List<String> portList;
    @Valid
    @Schema(name="portMaskList", description="Port mask list. [portType] value of 1 are is required")
    private List<PortMaskOpenApiVO> portMaskList;
    @Valid
    @Schema(name="macAddressList", description="MAC address list. Valid when [type] is 2")
    private List<MacAddressOpenApiVO> macAddressList;
    @Schema(name="countryList", description="Country list. Valid when [type] is 5")
    private List<String> countryList;
    @Schema(name="description", description="Description. Valid when [type] is 5")
    private String description;
    @Deprecated
    @Schema(name="domainName", description="Domain name. Valid when [type] is 7")
    private List<String> domainName;
    @Valid
    @Schema(name="domainNamePort", description="Domain info. Handle situations where there are ports,  [type] values of 7 is required")
    private List<DomainOpenApiVO> domainNamePort;

    public static GroupOpenApiVO toGroupOpenApiVO(GroupVO vo) {
        GroupOpenApiVO groupOpenApiVO = new GroupOpenApiVO();
        groupOpenApiVO.setGroupId(vo.getGroupId());
        groupOpenApiVO.setName(vo.getName());
        groupOpenApiVO.setType(vo.getType());
        groupOpenApiVO.setCount(vo.getCount());
        groupOpenApiVO.setBuildIn(vo.getBuildIn());
        groupOpenApiVO.setIpList(CollectionUtils.isEmpty((Collection)vo.getIpList()) ? null : vo.getIpList().stream().filter(Objects::nonNull).map(IPSubnetsOpenApiVO::toIPSubnetsOpenApiVO).collect(Collectors.toList()));
        groupOpenApiVO.setIpv6List(CollectionUtils.isEmpty((Collection)vo.getIpv6List()) ? null : vo.getIpv6List().stream().filter(Objects::nonNull).map(IPv6SubnetsOpenApiVO::toIPv6SubnetsOpenApiVO).collect(Collectors.toList()));
        groupOpenApiVO.setPortType(vo.getPortType());
        groupOpenApiVO.setPortList(vo.getPortList());
        groupOpenApiVO.setPortMaskList(CollectionUtils.isEmpty((Collection)vo.getPortMaskList()) ? null : vo.getPortMaskList().stream().filter(Objects::nonNull).map(PortMaskOpenApiVO::toPortMaskOpenApiVO).collect(Collectors.toList()));
        groupOpenApiVO.setMacAddressList(CollectionUtils.isEmpty((Collection)vo.getMacAddressList()) ? null : vo.getMacAddressList().stream().filter(Objects::nonNull).map(MacAddressOpenApiVO::toMacAddressOpenApiVO).collect(Collectors.toList()));
        groupOpenApiVO.setCountryList(vo.getCountryList());
        groupOpenApiVO.setDescription(vo.getDescription());
        groupOpenApiVO.setDomainName(vo.getDomainName());
        groupOpenApiVO.setDomainNamePort(CollectionUtils.isEmpty((Collection)vo.getDomainNamePort()) ? null : vo.getDomainNamePort().stream().filter(Objects::nonNull).map(DomainOpenApiVO::toDomainOpenApiVO).collect(Collectors.toList()));
        return groupOpenApiVO;
    }

    @Generated
    public String getGroupId() {
        return this.groupId;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Integer getType() {
        return this.type;
    }

    @Generated
    public Integer getCount() {
        return this.count;
    }

    @Generated
    public Boolean getBuildIn() {
        return this.buildIn;
    }

    @Generated
    public List<IPSubnetsOpenApiVO> getIpList() {
        return this.ipList;
    }

    @Generated
    public List<IPv6SubnetsOpenApiVO> getIpv6List() {
        return this.ipv6List;
    }

    @Generated
    public Integer getPortType() {
        return this.portType;
    }

    @Generated
    public List<String> getPortList() {
        return this.portList;
    }

    @Generated
    public List<PortMaskOpenApiVO> getPortMaskList() {
        return this.portMaskList;
    }

    @Generated
    public List<MacAddressOpenApiVO> getMacAddressList() {
        return this.macAddressList;
    }

    @Generated
    public List<String> getCountryList() {
        return this.countryList;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Deprecated
    @Generated
    public List<String> getDomainName() {
        return this.domainName;
    }

    @Generated
    public List<DomainOpenApiVO> getDomainNamePort() {
        return this.domainNamePort;
    }

    @Generated
    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setType(Integer type) {
        this.type = type;
    }

    @Generated
    public void setCount(Integer count) {
        this.count = count;
    }

    @Generated
    public void setBuildIn(Boolean buildIn) {
        this.buildIn = buildIn;
    }

    @Generated
    public void setIpList(List<IPSubnetsOpenApiVO> ipList) {
        this.ipList = ipList;
    }

    @Generated
    public void setIpv6List(List<IPv6SubnetsOpenApiVO> ipv6List) {
        this.ipv6List = ipv6List;
    }

    @Generated
    public void setPortType(Integer portType) {
        this.portType = portType;
    }

    @Generated
    public void setPortList(List<String> portList) {
        this.portList = portList;
    }

    @Generated
    public void setPortMaskList(List<PortMaskOpenApiVO> portMaskList) {
        this.portMaskList = portMaskList;
    }

    @Generated
    public void setMacAddressList(List<MacAddressOpenApiVO> macAddressList) {
        this.macAddressList = macAddressList;
    }

    @Generated
    public void setCountryList(List<String> countryList) {
        this.countryList = countryList;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Deprecated
    @Generated
    public void setDomainName(List<String> domainName) {
        this.domainName = domainName;
    }

    @Generated
    public void setDomainNamePort(List<DomainOpenApiVO> domainNamePort) {
        this.domainNamePort = domainNamePort;
    }

    @Generated
    public String toString() {
        return "GroupOpenApiVO(groupId=" + this.getGroupId() + ", name=" + this.getName() + ", type=" + this.getType() + ", count=" + this.getCount() + ", buildIn=" + this.getBuildIn() + ", ipList=" + this.getIpList() + ", ipv6List=" + this.getIpv6List() + ", portType=" + this.getPortType() + ", portList=" + this.getPortList() + ", portMaskList=" + this.getPortMaskList() + ", macAddressList=" + this.getMacAddressList() + ", countryList=" + this.getCountryList() + ", description=" + this.getDescription() + ", domainName=" + this.getDomainName() + ", domainNamePort=" + this.getDomainNamePort() + ")";
    }

    @Generated
    public GroupOpenApiVO(String groupId, String name, Integer type, Integer count, Boolean buildIn, List<IPSubnetsOpenApiVO> ipList, List<IPv6SubnetsOpenApiVO> ipv6List, Integer portType, List<String> portList, List<PortMaskOpenApiVO> portMaskList, List<MacAddressOpenApiVO> macAddressList, List<String> countryList, String description, List<String> domainName, List<DomainOpenApiVO> domainNamePort) {
        this.groupId = groupId;
        this.name = name;
        this.type = type;
        this.count = count;
        this.buildIn = buildIn;
        this.ipList = ipList;
        this.ipv6List = ipv6List;
        this.portType = portType;
        this.portList = portList;
        this.portMaskList = portMaskList;
        this.macAddressList = macAddressList;
        this.countryList = countryList;
        this.description = description;
        this.domainName = domainName;
        this.domainNamePort = domainNamePort;
    }

    @Generated
    public GroupOpenApiVO() {
    }
}

