/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.groupprofile;

import com.tplink.smb.omada.manager.configuration.api.web.site.profile.dto.DomainVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.annotation.Nonnull;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import lombok.Generated;

public class DomainOpenApiVO {
    @NotNull
    @Schema(name="address", description="Domain address, should be a valid domain address")
    private String address;
    @Schema(name="port", description="Domain port, port should be within the range of 0-65535 or empty, e.g. 80,80-100")
    private String port;
    @Pattern(regexp="^$|^[^ ]$|^[^ ].{0,510}[^ ]$", message="Parameter [description] should be 1 - 512 characters")
    @Schema(name="description", description="Domain description, description should contain 1 to 512 characters.")
    private @Pattern(regexp="^$|^[^ ]$|^[^ ].{0,510}[^ ]$", message="Parameter [description] should be 1 - 512 characters") String description;

    public static DomainOpenApiVO toDomainOpenApiVO(@Nonnull DomainVO vo) {
        DomainOpenApiVO domainOpenApiVO = new DomainOpenApiVO();
        domainOpenApiVO.setAddress(vo.getAddress());
        domainOpenApiVO.setPort(vo.getPort());
        domainOpenApiVO.setDescription(vo.getDescription());
        return domainOpenApiVO;
    }

    public static DomainVO toDomainVO(@Nonnull DomainOpenApiVO openApiVO) {
        DomainVO vo = new DomainVO();
        vo.setAddress(openApiVO.getAddress());
        vo.setPort(openApiVO.getPort());
        vo.setDescription(openApiVO.getDescription());
        return vo;
    }

    @Generated
    public String getAddress() {
        return this.address;
    }

    @Generated
    public String getPort() {
        return this.port;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public void setAddress(String address) {
        this.address = address;
    }

    @Generated
    public void setPort(String port) {
        this.port = port;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public String toString() {
        return "DomainOpenApiVO(address=" + this.getAddress() + ", port=" + this.getPort() + ", description=" + this.getDescription() + ")";
    }

    @Generated
    public DomainOpenApiVO(String address, String port, String description) {
        this.address = address;
        this.port = port;
        this.description = description;
    }

    @Generated
    public DomainOpenApiVO() {
    }
}

