/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.groupprofile;

import com.tplink.smb.omada.a.a;
import com.tplink.smb.omada.manager.configuration.api.web.site.profile.dto.embed.MacAddressVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.annotation.Nonnull;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import lombok.Generated;
import org.hibernate.validator.constraints.Length;

public class CreateMacAddressOpenApiVO {
    @Length(max=128, message="Name should contain 1 to 128 characters.")
    @Schema(name="name", description="MAC address name, name should contain 1 to 128 characters")
    private @Length(max=128, message="Name should contain 1 to 128 characters.") String name;
    @NotNull
    @Pattern(regexp="[A-Fa-f0-9]{1}[02468aceACE]{1}([-:][A-Fa-f0-9]{2}){5}", message="Parameter [macAddress] is invalid.")
    @Schema(name="macAddress", description="MAC address, should be a valid MAC address format, e.g. AA-BB-CC-DD-11-22")
    @a
    private @NotNull @Pattern(regexp="[A-Fa-f0-9]{1}[02468aceACE]{1}([-:][A-Fa-f0-9]{2}){5}", message="Parameter [macAddress] is invalid.") String macAddress;

    public static MacAddressVO toMacAddressVO(@Nonnull CreateMacAddressOpenApiVO openApiVO) {
        MacAddressVO vo = new MacAddressVO();
        vo.setName(openApiVO.getName());
        vo.setMacAddress(openApiVO.getMacAddress());
        return vo;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getMacAddress() {
        return this.macAddress;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setMacAddress(String macAddress) {
        this.macAddress = macAddress;
    }

    @Generated
    public String toString() {
        return "CreateMacAddressOpenApiVO(name=" + this.getName() + ", macAddress=" + this.getMacAddress() + ")";
    }

    @Generated
    public CreateMacAddressOpenApiVO(String name, String macAddress) {
        this.name = name;
        this.macAddress = macAddress;
    }

    @Generated
    public CreateMacAddressOpenApiVO() {
    }
}

