/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.groupprofile;

import com.tplink.smb.omada.common.validator.anons.NumberSet;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.groupprofile.CreateMacAddressOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.groupprofile.DomainOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.groupprofile.IPSubnetsOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.groupprofile.IPv6SubnetsOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.groupprofile.PortMaskOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.profile.dto.GroupVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.util.CollectionUtils;

public class CreateGroupOpenApiVO {
    @NotNull(message="Parameter [name] should not be null. Name should contain 1 to 64 characters")
    @Pattern(regexp="^[^ ]$|^[^ ].{0,62}[^ ]$", message="Parameter [name] should be 1 - 64 characters.")
    @Schema(name="name", description="Group profile name. Name should contain 1 to 64 characters")
    private @NotNull(message="Parameter [name] should not be null. Name should contain 1 to 64 characters") @Pattern(regexp="^[^ ]$|^[^ ].{0,62}[^ ]$", message="Parameter [name] should be 1 - 64 characters.") String name;
    @NotNull
    @NumberSet(value={0, 1, 2, 3, 4, 5, 7}, message="Type of group profile, type should be a value as follows: 0: IP Group; 1: IP Port Group; 2: MAC Group; 3: IPv6 Group; 4: IPv6 Port Group; 5: Country Group; 7: Domain Group")
    @Schema(name="type", description="Type of group profile, type should be a value as follows: 0: IP Group; 1: IP Port Group; 2: MAC Group; 3: IPv6 Group; 4: IPv6 Port Group; 5: Country Group; 7: Domain Group")
    private Integer type;
    @Valid
    @Schema(name="ipList", description="IP subnet info list. [type] value of 0 or 1 is required")
    private List<IPSubnetsOpenApiVO> ipList;
    @Valid
    @Schema(name="ipv6List", description="IPv6 subnet info list. [type] value of 3 or 4 is required")
    private List<IPv6SubnetsOpenApiVO> ipv6List;
    @NumberSet(value={0, 1}, message="PortType should be a value as follows: 0, 1.")
    @Schema(name="portType", description="Port type, portType should be a value as follows: 0: port range 1: port mask. [type] value of 1 or 4 is required")
    private Integer portType;
    @Schema(name="portList", description="Port list. [portType] value of 0 is required. PortList should be within the range of 0-65535, e.g. 80 or 80-100")
    private List<String> portList;
    @Valid
    @Schema(name="portMaskList", description="Port mask list. [portType] value of 1 is required")
    private List<PortMaskOpenApiVO> portMaskList;
    @Valid
    @Schema(name="macAddressList", description="MAC address list. [type] value of 2 is required")
    private List<CreateMacAddressOpenApiVO> macAddressList;
    @Schema(name="countryList", description="Country list. [type] value of 5 is required. For the values of countryList, refer to 'Country Name' section 5.4.1 of the Open API Access Guide")
    private List<String> countryList;
    @Pattern(regexp="^$|^[^ ]$|^[^ ].{0,510}[^ ]$", message="Parameter [description] should be 1 - 256 characters")
    @Schema(name="description", description="Description should contain 1 to 256 characters. [type] value of 5 is required")
    private @Pattern(regexp="^$|^[^ ]$|^[^ ].{0,510}[^ ]$", message="Parameter [description] should be 1 - 256 characters") String description;
    @Valid
    @Schema(name="domainNamePort", description="Domain info. Handle situations where there are ports, [type] value of 7 is required")
    private List<DomainOpenApiVO> domainNamePort;

    public GroupVO toGroupVo() {
        GroupVO groupVO = new GroupVO();
        groupVO.setName(this.name);
        groupVO.setType(this.type);
        groupVO.setIpList(CollectionUtils.isEmpty(this.ipList) ? Collections.emptyList() : this.ipList.stream().filter(Objects::nonNull).map(IPSubnetsOpenApiVO::toIPSubnetsVO).collect(Collectors.toList()));
        groupVO.setIpv6List(CollectionUtils.isEmpty(this.ipv6List) ? Collections.emptyList() : this.ipv6List.stream().filter(Objects::nonNull).map(IPv6SubnetsOpenApiVO::toIPv6SubnetsVO).collect(Collectors.toList()));
        groupVO.setPortType(this.portType);
        groupVO.setPortList(this.portList);
        groupVO.setPortMaskList(CollectionUtils.isEmpty(this.portMaskList) ? null : this.portMaskList.stream().filter(Objects::nonNull).map(PortMaskOpenApiVO::toPortMaskVO).collect(Collectors.toList()));
        groupVO.setMacAddressList(CollectionUtils.isEmpty(this.macAddressList) ? null : this.macAddressList.stream().filter(Objects::nonNull).map(CreateMacAddressOpenApiVO::toMacAddressVO).collect(Collectors.toList()));
        groupVO.setCountryList(this.countryList);
        groupVO.setDescription(this.description);
        groupVO.setDomainNamePort(CollectionUtils.isEmpty(this.domainNamePort) ? null : this.domainNamePort.stream().filter(Objects::nonNull).map(DomainOpenApiVO::toDomainVO).collect(Collectors.toList()));
        return groupVO;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Integer getType() {
        return this.type;
    }

    @Generated
    public List<IPSubnetsOpenApiVO> getIpList() {
        return this.ipList;
    }

    @Generated
    public List<IPv6SubnetsOpenApiVO> getIpv6List() {
        return this.ipv6List;
    }

    @Generated
    public Integer getPortType() {
        return this.portType;
    }

    @Generated
    public List<String> getPortList() {
        return this.portList;
    }

    @Generated
    public List<PortMaskOpenApiVO> getPortMaskList() {
        return this.portMaskList;
    }

    @Generated
    public List<CreateMacAddressOpenApiVO> getMacAddressList() {
        return this.macAddressList;
    }

    @Generated
    public List<String> getCountryList() {
        return this.countryList;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public List<DomainOpenApiVO> getDomainNamePort() {
        return this.domainNamePort;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setType(Integer type) {
        this.type = type;
    }

    @Generated
    public void setIpList(List<IPSubnetsOpenApiVO> ipList) {
        this.ipList = ipList;
    }

    @Generated
    public void setIpv6List(List<IPv6SubnetsOpenApiVO> ipv6List) {
        this.ipv6List = ipv6List;
    }

    @Generated
    public void setPortType(Integer portType) {
        this.portType = portType;
    }

    @Generated
    public void setPortList(List<String> portList) {
        this.portList = portList;
    }

    @Generated
    public void setPortMaskList(List<PortMaskOpenApiVO> portMaskList) {
        this.portMaskList = portMaskList;
    }

    @Generated
    public void setMacAddressList(List<CreateMacAddressOpenApiVO> macAddressList) {
        this.macAddressList = macAddressList;
    }

    @Generated
    public void setCountryList(List<String> countryList) {
        this.countryList = countryList;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setDomainNamePort(List<DomainOpenApiVO> domainNamePort) {
        this.domainNamePort = domainNamePort;
    }

    @Generated
    public String toString() {
        return "CreateGroupOpenApiVO(name=" + this.getName() + ", type=" + this.getType() + ", ipList=" + this.getIpList() + ", ipv6List=" + this.getIpv6List() + ", portType=" + this.getPortType() + ", portList=" + this.getPortList() + ", portMaskList=" + this.getPortMaskList() + ", macAddressList=" + this.getMacAddressList() + ", countryList=" + this.getCountryList() + ", description=" + this.getDescription() + ", domainNamePort=" + this.getDomainNamePort() + ")";
    }

    @Generated
    public CreateGroupOpenApiVO(String name, Integer type, List<IPSubnetsOpenApiVO> ipList, List<IPv6SubnetsOpenApiVO> ipv6List, Integer portType, List<String> portList, List<PortMaskOpenApiVO> portMaskList, List<CreateMacAddressOpenApiVO> macAddressList, List<String> countryList, String description, List<DomainOpenApiVO> domainNamePort) {
        this.name = name;
        this.type = type;
        this.ipList = ipList;
        this.ipv6List = ipv6List;
        this.portType = portType;
        this.portList = portList;
        this.portMaskList = portMaskList;
        this.macAddressList = macAddressList;
        this.countryList = countryList;
        this.description = description;
        this.domainNamePort = domainNamePort;
    }

    @Generated
    public CreateGroupOpenApiVO() {
    }
}

