/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.cli;

import com.tplink.smb.omada.manager.configuration.api.web.site.cliconfig.dto.DeviceCliVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.cliconfig.dto.ModifyCliVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.cliconfig.dto.StackCliVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import java.util.List;
import lombok.Generated;
import org.hibernate.validator.constraints.Length;

@Schema(description="Modify the CLI configuration entry")
public class ModifyCliOpenApiVO {
    @NotNull(message="CLI configuration name must not be null")
    @Length(max=64, message="Parameter [name] should be 1 ~ 64 characters.")
    @Schema(name="name", description="CLI configuration name, it should be within the range of 1 - 64 characters")
    private @NotNull(message="CLI configuration name must not be null") @Length(max=64, message="Parameter [name] should be 1 ~ 64 characters.") String name;
    @NotNull(message="deviceType must not be null")
    @Schema(name="deviceType", description="Device type for CLI configuration application, it should be a value as follows: switch.")
    private @NotNull(message="deviceType must not be null") String deviceType;
    @Length(max=256, message="Parameter [description] should be 0 ~ 256 characters.")
    @Schema(name="description", description="CLI configuration description, it should be within the range of 0 - 256 characters.")
    private @Length(max=256, message="Parameter [description] should be 0 ~ 256 characters.") String description;
    @NotNull(message="cliConfig must not be null")
    @Schema(name="cliConfig", description="CLI configuration content")
    private @NotNull(message="cliConfig must not be null") String cliConfig;
    @Schema(name="devices", description="List of devices bound to the CLI configuration.")
    private List<DeviceCliVO> devices;
    @Schema(name="stacks", description="List of stacks bound to the CLI configuration, only device CLI has this field.")
    private List<StackCliVO> stacks;
    @Schema(description="Device model of model cli")
    private String model;
    @Schema(description="Device model version of model cli")
    private String modelVersion;

    public static ModifyCliVO toWebVo(ModifyCliOpenApiVO vo) {
        ModifyCliVO modifyCliVO = new ModifyCliVO();
        modifyCliVO.setName(vo.getName());
        modifyCliVO.setDeviceType(vo.getDeviceType());
        modifyCliVO.setDescription(vo.getDescription());
        modifyCliVO.setCliConfig(vo.getCliConfig());
        modifyCliVO.setDevices(vo.getDevices());
        modifyCliVO.setStacks(vo.getStacks());
        modifyCliVO.setModel(vo.getModel());
        modifyCliVO.setModelVersion(vo.getModelVersion());
        return modifyCliVO;
    }

    @Generated
    protected ModifyCliOpenApiVO(ModifyCliOpenApiVOBuilder<?, ?> b2) {
        this.name = b2.name;
        this.deviceType = b2.deviceType;
        this.description = b2.description;
        this.cliConfig = b2.cliConfig;
        this.devices = b2.devices;
        this.stacks = b2.stacks;
        this.model = b2.model;
        this.modelVersion = b2.modelVersion;
    }

    @Generated
    public static ModifyCliOpenApiVOBuilder<?, ?> builder() {
        return new ModifyCliOpenApiVOBuilderImpl();
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getDeviceType() {
        return this.deviceType;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public String getCliConfig() {
        return this.cliConfig;
    }

    @Generated
    public List<DeviceCliVO> getDevices() {
        return this.devices;
    }

    @Generated
    public List<StackCliVO> getStacks() {
        return this.stacks;
    }

    @Generated
    public String getModel() {
        return this.model;
    }

    @Generated
    public String getModelVersion() {
        return this.modelVersion;
    }

    @Generated
    public ModifyCliOpenApiVO setName(String name) {
        this.name = name;
        return this;
    }

    @Generated
    public ModifyCliOpenApiVO setDeviceType(String deviceType) {
        this.deviceType = deviceType;
        return this;
    }

    @Generated
    public ModifyCliOpenApiVO setDescription(String description) {
        this.description = description;
        return this;
    }

    @Generated
    public ModifyCliOpenApiVO setCliConfig(String cliConfig) {
        this.cliConfig = cliConfig;
        return this;
    }

    @Generated
    public ModifyCliOpenApiVO setDevices(List<DeviceCliVO> devices) {
        this.devices = devices;
        return this;
    }

    @Generated
    public ModifyCliOpenApiVO setStacks(List<StackCliVO> stacks) {
        this.stacks = stacks;
        return this;
    }

    @Generated
    public ModifyCliOpenApiVO setModel(String model) {
        this.model = model;
        return this;
    }

    @Generated
    public ModifyCliOpenApiVO setModelVersion(String modelVersion) {
        this.modelVersion = modelVersion;
        return this;
    }

    @Generated
    public String toString() {
        return "ModifyCliOpenApiVO(name=" + this.getName() + ", deviceType=" + this.getDeviceType() + ", description=" + this.getDescription() + ", cliConfig=" + this.getCliConfig() + ", devices=" + this.getDevices() + ", stacks=" + this.getStacks() + ", model=" + this.getModel() + ", modelVersion=" + this.getModelVersion() + ")";
    }

    @Generated
    public ModifyCliOpenApiVO() {
    }

    @Generated
    public ModifyCliOpenApiVO(String name, String deviceType, String description, String cliConfig, List<DeviceCliVO> devices, List<StackCliVO> stacks, String model, String modelVersion) {
        this.name = name;
        this.deviceType = deviceType;
        this.description = description;
        this.cliConfig = cliConfig;
        this.devices = devices;
        this.stacks = stacks;
        this.model = model;
        this.modelVersion = modelVersion;
    }

    @Generated
    public static abstract class ModifyCliOpenApiVOBuilder<C extends ModifyCliOpenApiVO, B extends ModifyCliOpenApiVOBuilder<C, B>> {
        @Generated
        private String name;
        @Generated
        private String deviceType;
        @Generated
        private String description;
        @Generated
        private String cliConfig;
        @Generated
        private List<DeviceCliVO> devices;
        @Generated
        private List<StackCliVO> stacks;
        @Generated
        private String model;
        @Generated
        private String modelVersion;

        @Generated
        public B name(String name) {
            this.name = name;
            return this.self();
        }

        @Generated
        public B deviceType(String deviceType) {
            this.deviceType = deviceType;
            return this.self();
        }

        @Generated
        public B description(String description) {
            this.description = description;
            return this.self();
        }

        @Generated
        public B cliConfig(String cliConfig) {
            this.cliConfig = cliConfig;
            return this.self();
        }

        @Generated
        public B devices(List<DeviceCliVO> devices) {
            this.devices = devices;
            return this.self();
        }

        @Generated
        public B stacks(List<StackCliVO> stacks) {
            this.stacks = stacks;
            return this.self();
        }

        @Generated
        public B model(String model) {
            this.model = model;
            return this.self();
        }

        @Generated
        public B modelVersion(String modelVersion) {
            this.modelVersion = modelVersion;
            return this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "ModifyCliOpenApiVO.ModifyCliOpenApiVOBuilder(name=" + this.name + ", deviceType=" + this.deviceType + ", description=" + this.description + ", cliConfig=" + this.cliConfig + ", devices=" + this.devices + ", stacks=" + this.stacks + ", model=" + this.model + ", modelVersion=" + this.modelVersion + ")";
        }
    }

    @Generated
    private static final class ModifyCliOpenApiVOBuilderImpl
    extends ModifyCliOpenApiVOBuilder<ModifyCliOpenApiVO, ModifyCliOpenApiVOBuilderImpl> {
        @Generated
        private ModifyCliOpenApiVOBuilderImpl() {
        }

        @Override
        @Generated
        protected ModifyCliOpenApiVOBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public ModifyCliOpenApiVO build() {
            return new ModifyCliOpenApiVO(this);
        }
    }
}

