/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.cli;

import com.tplink.smb.omada.manager.configuration.api.web.site.cliconfig.dto.CliConfigVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.cliconfig.dto.DeviceCliVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.cliconfig.dto.StackCliVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.annotation.Nonnull;
import jakarta.validation.constraints.NotNull;
import java.util.List;
import lombok.Generated;
import org.hibernate.validator.constraints.Length;

@Schema(description="Get the CLI configuration entry")
public class CliConfigOpenApiVO {
    @Schema(name="omadacId", description="Omada ID")
    private String omadacId;
    @Schema(name="siteId", description="Site ID")
    private String siteId;
    @Schema(name="cliType", description="CLI configuration type, it should be a value as follows: 0\uff1asite CLI\uff1b 1\uff1adevice CLI.")
    private Integer cliType;
    @Schema(name="id", description="CLI configuration ID")
    private String id;
    @Schema(name="name", description="CLI configuration name")
    private String name;
    @Schema(name="deviceType", description="Device type for CLI configuration application, it should be a value as follows: switch.")
    private String deviceType;
    @Length(max=256, message="Parameter [description] should be 0 ~ 256 characters.")
    @Schema(name="description", description="CLI configuration description, it should be within the range of 0 - 256 characters.")
    private @Length(max=256, message="Parameter [description] should be 0 ~ 256 characters.") String description;
    @Schema(name="status", description="CLI configuration status, it should be a value as follows: 0: active, 1: inactive")
    private Integer status;
    @Schema(name="cliConfig", description="CLI configuration content")
    @NotNull(message="cliConfig must not be null")
    private @NotNull(message="cliConfig must not be null") String cliConfig;
    @Schema(name="devices", description="List of devices bound to the CLI configuration. Only device CLI has this field.")
    private List<DeviceCliVO> devices;
    @Schema(name="stacks", description="List of stacks bound to the CLI configuration, only device CLI has this field.")
    private List<StackCliVO> stacks;
    @Schema(description="Device model of model cli")
    private String model;
    @Schema(description="Device model version of model cli")
    private String modelVersion;

    public static CliConfigOpenApiVO toOpenApiVO(@Nonnull CliConfigVO vo) {
        return ((CliConfigOpenApiVOBuilder)((CliConfigOpenApiVOBuilder)((CliConfigOpenApiVOBuilder)((CliConfigOpenApiVOBuilder)((CliConfigOpenApiVOBuilder)((CliConfigOpenApiVOBuilder)((CliConfigOpenApiVOBuilder)((CliConfigOpenApiVOBuilder)((CliConfigOpenApiVOBuilder)((CliConfigOpenApiVOBuilder)((CliConfigOpenApiVOBuilder)((CliConfigOpenApiVOBuilder)CliConfigOpenApiVO.builder().omadacId(vo.getOmadacId())).cliType(vo.getCliType())).id(vo.getId())).name(vo.getName())).deviceType(vo.getDeviceType())).description(vo.getDescription())).status(vo.getStatus())).cliConfig(vo.getCliConfig())).devices(vo.getDevices())).stacks(vo.getStacks())).model(vo.getModel())).modelVersion(vo.getModelVersion())).build();
    }

    @Generated
    protected CliConfigOpenApiVO(CliConfigOpenApiVOBuilder<?, ?> b2) {
        this.omadacId = b2.omadacId;
        this.siteId = b2.siteId;
        this.cliType = b2.cliType;
        this.id = b2.id;
        this.name = b2.name;
        this.deviceType = b2.deviceType;
        this.description = b2.description;
        this.status = b2.status;
        this.cliConfig = b2.cliConfig;
        this.devices = b2.devices;
        this.stacks = b2.stacks;
        this.model = b2.model;
        this.modelVersion = b2.modelVersion;
    }

    @Generated
    public static CliConfigOpenApiVOBuilder<?, ?> builder() {
        return new CliConfigOpenApiVOBuilderImpl();
    }

    @Generated
    public String getOmadacId() {
        return this.omadacId;
    }

    @Generated
    public String getSiteId() {
        return this.siteId;
    }

    @Generated
    public Integer getCliType() {
        return this.cliType;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getDeviceType() {
        return this.deviceType;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public Integer getStatus() {
        return this.status;
    }

    @Generated
    public String getCliConfig() {
        return this.cliConfig;
    }

    @Generated
    public List<DeviceCliVO> getDevices() {
        return this.devices;
    }

    @Generated
    public List<StackCliVO> getStacks() {
        return this.stacks;
    }

    @Generated
    public String getModel() {
        return this.model;
    }

    @Generated
    public String getModelVersion() {
        return this.modelVersion;
    }

    @Generated
    public CliConfigOpenApiVO setOmadacId(String omadacId) {
        this.omadacId = omadacId;
        return this;
    }

    @Generated
    public CliConfigOpenApiVO setSiteId(String siteId) {
        this.siteId = siteId;
        return this;
    }

    @Generated
    public CliConfigOpenApiVO setCliType(Integer cliType) {
        this.cliType = cliType;
        return this;
    }

    @Generated
    public CliConfigOpenApiVO setId(String id) {
        this.id = id;
        return this;
    }

    @Generated
    public CliConfigOpenApiVO setName(String name) {
        this.name = name;
        return this;
    }

    @Generated
    public CliConfigOpenApiVO setDeviceType(String deviceType) {
        this.deviceType = deviceType;
        return this;
    }

    @Generated
    public CliConfigOpenApiVO setDescription(String description) {
        this.description = description;
        return this;
    }

    @Generated
    public CliConfigOpenApiVO setStatus(Integer status) {
        this.status = status;
        return this;
    }

    @Generated
    public CliConfigOpenApiVO setCliConfig(String cliConfig) {
        this.cliConfig = cliConfig;
        return this;
    }

    @Generated
    public CliConfigOpenApiVO setDevices(List<DeviceCliVO> devices) {
        this.devices = devices;
        return this;
    }

    @Generated
    public CliConfigOpenApiVO setStacks(List<StackCliVO> stacks) {
        this.stacks = stacks;
        return this;
    }

    @Generated
    public CliConfigOpenApiVO setModel(String model) {
        this.model = model;
        return this;
    }

    @Generated
    public CliConfigOpenApiVO setModelVersion(String modelVersion) {
        this.modelVersion = modelVersion;
        return this;
    }

    @Generated
    public String toString() {
        return "CliConfigOpenApiVO(omadacId=" + this.getOmadacId() + ", siteId=" + this.getSiteId() + ", cliType=" + this.getCliType() + ", id=" + this.getId() + ", name=" + this.getName() + ", deviceType=" + this.getDeviceType() + ", description=" + this.getDescription() + ", status=" + this.getStatus() + ", cliConfig=" + this.getCliConfig() + ", devices=" + this.getDevices() + ", stacks=" + this.getStacks() + ", model=" + this.getModel() + ", modelVersion=" + this.getModelVersion() + ")";
    }

    @Generated
    public CliConfigOpenApiVO() {
    }

    @Generated
    public CliConfigOpenApiVO(String omadacId, String siteId, Integer cliType, String id, String name, String deviceType, String description, Integer status, String cliConfig, List<DeviceCliVO> devices, List<StackCliVO> stacks, String model, String modelVersion) {
        this.omadacId = omadacId;
        this.siteId = siteId;
        this.cliType = cliType;
        this.id = id;
        this.name = name;
        this.deviceType = deviceType;
        this.description = description;
        this.status = status;
        this.cliConfig = cliConfig;
        this.devices = devices;
        this.stacks = stacks;
        this.model = model;
        this.modelVersion = modelVersion;
    }

    @Generated
    public static abstract class CliConfigOpenApiVOBuilder<C extends CliConfigOpenApiVO, B extends CliConfigOpenApiVOBuilder<C, B>> {
        @Generated
        private String omadacId;
        @Generated
        private String siteId;
        @Generated
        private Integer cliType;
        @Generated
        private String id;
        @Generated
        private String name;
        @Generated
        private String deviceType;
        @Generated
        private String description;
        @Generated
        private Integer status;
        @Generated
        private String cliConfig;
        @Generated
        private List<DeviceCliVO> devices;
        @Generated
        private List<StackCliVO> stacks;
        @Generated
        private String model;
        @Generated
        private String modelVersion;

        @Generated
        public B omadacId(String omadacId) {
            this.omadacId = omadacId;
            return this.self();
        }

        @Generated
        public B siteId(String siteId) {
            this.siteId = siteId;
            return this.self();
        }

        @Generated
        public B cliType(Integer cliType) {
            this.cliType = cliType;
            return this.self();
        }

        @Generated
        public B id(String id) {
            this.id = id;
            return this.self();
        }

        @Generated
        public B name(String name) {
            this.name = name;
            return this.self();
        }

        @Generated
        public B deviceType(String deviceType) {
            this.deviceType = deviceType;
            return this.self();
        }

        @Generated
        public B description(String description) {
            this.description = description;
            return this.self();
        }

        @Generated
        public B status(Integer status) {
            this.status = status;
            return this.self();
        }

        @Generated
        public B cliConfig(String cliConfig) {
            this.cliConfig = cliConfig;
            return this.self();
        }

        @Generated
        public B devices(List<DeviceCliVO> devices) {
            this.devices = devices;
            return this.self();
        }

        @Generated
        public B stacks(List<StackCliVO> stacks) {
            this.stacks = stacks;
            return this.self();
        }

        @Generated
        public B model(String model) {
            this.model = model;
            return this.self();
        }

        @Generated
        public B modelVersion(String modelVersion) {
            this.modelVersion = modelVersion;
            return this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "CliConfigOpenApiVO.CliConfigOpenApiVOBuilder(omadacId=" + this.omadacId + ", siteId=" + this.siteId + ", cliType=" + this.cliType + ", id=" + this.id + ", name=" + this.name + ", deviceType=" + this.deviceType + ", description=" + this.description + ", status=" + this.status + ", cliConfig=" + this.cliConfig + ", devices=" + this.devices + ", stacks=" + this.stacks + ", model=" + this.model + ", modelVersion=" + this.modelVersion + ")";
        }
    }

    @Generated
    private static final class CliConfigOpenApiVOBuilderImpl
    extends CliConfigOpenApiVOBuilder<CliConfigOpenApiVO, CliConfigOpenApiVOBuilderImpl> {
        @Generated
        private CliConfigOpenApiVOBuilderImpl() {
        }

        @Override
        @Generated
        protected CliConfigOpenApiVOBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public CliConfigOpenApiVO build() {
            return new CliConfigOpenApiVO(this);
        }
    }
}

