/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.cert.vo;

import com.tplink.nbu.common.pii.annotation.PII;
import com.tplink.nbu.common.pii.constant.PIIMaskStrategy;
import com.tplink.smb.omada.manager.configuration.api.web.site.cert.CertProfileVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;

@Schema(description="CertProfileRequestOpenApiVO")
public class CertProfileRequestOpenApiVO {
    @NotNull(message="Parameter [name] should not be null.")
    @Pattern(regexp="^[^ ]$|^[^ ].{0,62}[^ ]$", message="Parameter [name] should be 1 - 64 characters")
    @Schema(name="name", description="Cert profile name, name should contain 1 to 64 characters.")
    private @NotNull(message="Parameter [name] should not be null.") @Pattern(regexp="^[^ ]$|^[^ ].{0,62}[^ ]$", message="Parameter [name] should be 1 - 64 characters") String name;
    @Range(max=1L, message="Parameter [type] should be 0 or 1.")
    @NotNull(message="Parameter [type] should not be null.")
    @Schema(name="type", description="Cert profile type, type should be a value as follows: 0: CA Cert; 1: Client Cert..")
    private @Range(max=1L, message="Parameter [type] should be 0 or 1.") @NotNull(message="Parameter [type] should not be null.") Integer type;
    @Range(max=1L, message="Parameter [format] should be 0 or 1.")
    @NotNull(message="Parameter [format] should not be null.")
    @Schema(name="format", description="Cert profile format, format should be a value as follows: 0: X509; 1: DER.")
    private @Range(max=1L, message="Parameter [format] should be 0 or 1.") @NotNull(message="Parameter [format] should not be null.") Integer format;
    @Schema(name="caCertFileId", description="CA Certificate file id, it's obtained from the interface 'uploadCaCertFile'; When type = 0, Parameter [caCertFileId] should not be null.")
    private String caCertFileId;
    @Schema(name="clientCertFileId", description="Client certificate file id, it's obtained from the interface 'uploadClientCertFile'; When type = 1, Parameter [clientCertFileId] should not be null.")
    private String clientCertFileId;
    @Schema(name="privateKeyFileId", description="Client private key file id, it's obtained from the interface 'UploadClientPrivateKeyFile'; When type = 1, Parameter [privateKeyFileId] should not be null.")
    private String privateKeyFileId;
    @Schema(name="privateKeyPassword", description="Client private key password; When type = 1, Parameter [privateKeyPassword] is an optional input.")
    @PII(strategy=PIIMaskStrategy.ENCRYPT)
    private String privateKeyPassword;

    public CertProfileVO toVO() {
        CertProfileVO vo = new CertProfileVO();
        vo.setName(this.getName());
        vo.setFormat(this.getFormat());
        vo.setType(this.getType());
        vo.setCaCertFileId(this.getCaCertFileId());
        vo.setClientCertFileId(this.getClientCertFileId());
        vo.setPrivateKeyFileId(this.getPrivateKeyFileId());
        vo.setPrivateKeyPassword(this.getPrivateKeyPassword());
        return vo;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Integer getType() {
        return this.type;
    }

    @Generated
    public Integer getFormat() {
        return this.format;
    }

    @Generated
    public String getCaCertFileId() {
        return this.caCertFileId;
    }

    @Generated
    public String getClientCertFileId() {
        return this.clientCertFileId;
    }

    @Generated
    public String getPrivateKeyFileId() {
        return this.privateKeyFileId;
    }

    @Generated
    public String getPrivateKeyPassword() {
        return this.privateKeyPassword;
    }

    @Generated
    public CertProfileRequestOpenApiVO setName(String name) {
        this.name = name;
        return this;
    }

    @Generated
    public CertProfileRequestOpenApiVO setType(Integer type) {
        this.type = type;
        return this;
    }

    @Generated
    public CertProfileRequestOpenApiVO setFormat(Integer format) {
        this.format = format;
        return this;
    }

    @Generated
    public CertProfileRequestOpenApiVO setCaCertFileId(String caCertFileId) {
        this.caCertFileId = caCertFileId;
        return this;
    }

    @Generated
    public CertProfileRequestOpenApiVO setClientCertFileId(String clientCertFileId) {
        this.clientCertFileId = clientCertFileId;
        return this;
    }

    @Generated
    public CertProfileRequestOpenApiVO setPrivateKeyFileId(String privateKeyFileId) {
        this.privateKeyFileId = privateKeyFileId;
        return this;
    }

    @Generated
    public CertProfileRequestOpenApiVO setPrivateKeyPassword(String privateKeyPassword) {
        this.privateKeyPassword = privateKeyPassword;
        return this;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CertProfileRequestOpenApiVO)) {
            return false;
        }
        CertProfileRequestOpenApiVO other = (CertProfileRequestOpenApiVO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$type = this.getType();
        Integer other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)this$type).equals(other$type)) {
            return false;
        }
        Integer this$format = this.getFormat();
        Integer other$format = other.getFormat();
        if (this$format == null ? other$format != null : !((Object)this$format).equals(other$format)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$caCertFileId = this.getCaCertFileId();
        String other$caCertFileId = other.getCaCertFileId();
        if (this$caCertFileId == null ? other$caCertFileId != null : !this$caCertFileId.equals(other$caCertFileId)) {
            return false;
        }
        String this$clientCertFileId = this.getClientCertFileId();
        String other$clientCertFileId = other.getClientCertFileId();
        if (this$clientCertFileId == null ? other$clientCertFileId != null : !this$clientCertFileId.equals(other$clientCertFileId)) {
            return false;
        }
        String this$privateKeyFileId = this.getPrivateKeyFileId();
        String other$privateKeyFileId = other.getPrivateKeyFileId();
        if (this$privateKeyFileId == null ? other$privateKeyFileId != null : !this$privateKeyFileId.equals(other$privateKeyFileId)) {
            return false;
        }
        String this$privateKeyPassword = this.getPrivateKeyPassword();
        String other$privateKeyPassword = other.getPrivateKeyPassword();
        return !(this$privateKeyPassword == null ? other$privateKeyPassword != null : !this$privateKeyPassword.equals(other$privateKeyPassword));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CertProfileRequestOpenApiVO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)$type).hashCode());
        Integer $format = this.getFormat();
        result = result * 59 + ($format == null ? 43 : ((Object)$format).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $caCertFileId = this.getCaCertFileId();
        result = result * 59 + ($caCertFileId == null ? 43 : $caCertFileId.hashCode());
        String $clientCertFileId = this.getClientCertFileId();
        result = result * 59 + ($clientCertFileId == null ? 43 : $clientCertFileId.hashCode());
        String $privateKeyFileId = this.getPrivateKeyFileId();
        result = result * 59 + ($privateKeyFileId == null ? 43 : $privateKeyFileId.hashCode());
        String $privateKeyPassword = this.getPrivateKeyPassword();
        result = result * 59 + ($privateKeyPassword == null ? 43 : $privateKeyPassword.hashCode());
        return result;
    }

    @Generated
    public CertProfileRequestOpenApiVO() {
    }

    @Generated
    public CertProfileRequestOpenApiVO(String name, Integer type, Integer format, String caCertFileId, String clientCertFileId, String privateKeyFileId, String privateKeyPassword) {
        this.name = name;
        this.type = type;
        this.format = format;
        this.caCertFileId = caCertFileId;
        this.clientCertFileId = clientCertFileId;
        this.privateKeyFileId = privateKeyFileId;
        this.privateKeyPassword = privateKeyPassword;
    }

    @Generated
    public String toString() {
        return "CertProfileRequestOpenApiVO(name=" + this.getName() + ", type=" + this.getType() + ", format=" + this.getFormat() + ", caCertFileId=" + this.getCaCertFileId() + ", clientCertFileId=" + this.getClientCertFileId() + ", privateKeyFileId=" + this.getPrivateKeyFileId() + ", privateKeyPassword=" + this.getPrivateKeyPassword() + ")";
    }
}

