/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.bluetooth.vo;

import com.tplink.smb.omada.a.a;
import com.tplink.smb.omada.common.validator.anons.NumberSet;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.bluetooth.vo.ApBtDetailOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.wireless.iot.IotBtIbeaconVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.annotation.Nullable;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;

public class IotBtIbeaconOpenApiVO {
    @Schema(name="id", description="The Bluetooth Advertising entry ID.")
    private String id;
    @NotNull
    @Pattern(regexp="^[^ ]$|^[^ ].{0,62}[^ ]$", message="Parameter [name] should be 1 ~ 64 characters and do not add Spaces at the beginning and end.")
    @Schema(name="name", description="The Bluetooth Advertising seting name.")
    private @NotNull @Pattern(regexp="^[^ ]$|^[^ ].{0,62}[^ ]$", message="Parameter [name] should be 1 ~ 64 characters and do not add Spaces at the beginning and end.") String name;
    @Schema(name="boundDeviceNum", description="The quantity of devices bound to this configuration.")
    private Integer boundDeviceNum;
    @Schema(name="macList", description="List of device MAC addresses bound to this configuration.")
    @a
    private List<String> macList;
    @Schema(name="enable", description="Whether to enable the Bluetooth Advertising setting.")
    private Boolean enable;
    @Deprecated
    @NumberSet(value={-20, -18, -15, -12, -10, -9, -6, -5, -3, 0, 1, 2, 3, 4, 5, 14, 15, 16, 17, 18, 19, 20})
    @Schema(name="transmitPower", description="Broadcast transmission power.<br />The parameter [transmitPower] should be a value as follows:[-20, -18, -15, -12, -10, -9, -6, -5, -3, 0, 1, 2, 3, 4, 5, 14, 15, 16, 17, 18, 19, 20]")
    private Integer transmitPower;
    @Range(min=-97L, max=20L)
    @Schema(name="measurePower", description="RSSI Calibration Value. The parameter [measurePower] is used to input the RSSI measured at a 1-meter distance from the device, enabling positioning functionality.")
    private @Range(min=-97L, max=20L) Integer measurePower;
    @Range(min=100L, max=10240L)
    @Schema(name="advInterval", description="Advertising interval.")
    private @Range(min=100L, max=10240L) Integer advInterval;
    @Schema(name="uuid", description="The UUID (Universally Unique Identifier) of the advertising ibeacon packet.")
    private String uuid;
    @Schema(name="major", description="The major value of adverting ibeacon packet, indicating a larger group.")
    private String major;
    @Schema(name="minor", description="The minor value of adverting ibeacon packet, indicating a smaller group.")
    private String minor;
    @Schema(name="selectMacInfo", description="Detailed information about the devices bound to this configuration.")
    @a(a=false)
    private List<ApBtDetailOpenApiVO> selectMacInfo;
    @Schema(name="buildIn", description="Whether it is a built-in configuration: [0:true; 1:false].")
    private Integer buildIn;

    @Nullable
    public static IotBtIbeaconOpenApiVO fromWebVO(IotBtIbeaconVO webVO) {
        if (Objects.isNull(webVO)) {
            return null;
        }
        IotBtIbeaconOpenApiVO openApiVO = new IotBtIbeaconOpenApiVO();
        openApiVO.setId(webVO.getId());
        openApiVO.setName(webVO.getName());
        openApiVO.setBoundDeviceNum(webVO.getBoundDeviceNum());
        openApiVO.setMacList(webVO.getMacList());
        openApiVO.setEnable(webVO.getEnable());
        openApiVO.setTransmitPower(webVO.getTransmitPower());
        openApiVO.setMeasurePower(webVO.getMeasurePower());
        openApiVO.setAdvInterval(webVO.getAdvInterval());
        openApiVO.setUuid(webVO.getUuid());
        openApiVO.setMajor(webVO.getMajor());
        openApiVO.setMinor(webVO.getMinor());
        openApiVO.setSelectMacInfo(Optional.ofNullable(webVO.getSelectMacInfo()).map(selectMacInfoList -> selectMacInfoList.stream().map(ApBtDetailOpenApiVO::fromWebVO).toList()).orElse(null));
        openApiVO.setBuildIn(webVO.getBuildIn());
        return openApiVO;
    }

    @Generated
    protected IotBtIbeaconOpenApiVO(IotBtIbeaconOpenApiVOBuilder<?, ?> b2) {
        this.id = b2.id;
        this.name = b2.name;
        this.boundDeviceNum = b2.boundDeviceNum;
        this.macList = b2.macList;
        this.enable = b2.enable;
        this.transmitPower = b2.transmitPower;
        this.measurePower = b2.measurePower;
        this.advInterval = b2.advInterval;
        this.uuid = b2.uuid;
        this.major = b2.major;
        this.minor = b2.minor;
        this.selectMacInfo = b2.selectMacInfo;
        this.buildIn = b2.buildIn;
    }

    @Generated
    public static IotBtIbeaconOpenApiVOBuilder<?, ?> builder() {
        return new IotBtIbeaconOpenApiVOBuilderImpl();
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Integer getBoundDeviceNum() {
        return this.boundDeviceNum;
    }

    @Generated
    public List<String> getMacList() {
        return this.macList;
    }

    @Generated
    public Boolean getEnable() {
        return this.enable;
    }

    @Deprecated
    @Generated
    public Integer getTransmitPower() {
        return this.transmitPower;
    }

    @Generated
    public Integer getMeasurePower() {
        return this.measurePower;
    }

    @Generated
    public Integer getAdvInterval() {
        return this.advInterval;
    }

    @Generated
    public String getUuid() {
        return this.uuid;
    }

    @Generated
    public String getMajor() {
        return this.major;
    }

    @Generated
    public String getMinor() {
        return this.minor;
    }

    @Generated
    public List<ApBtDetailOpenApiVO> getSelectMacInfo() {
        return this.selectMacInfo;
    }

    @Generated
    public Integer getBuildIn() {
        return this.buildIn;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setBoundDeviceNum(Integer boundDeviceNum) {
        this.boundDeviceNum = boundDeviceNum;
    }

    @Generated
    public void setMacList(List<String> macList) {
        this.macList = macList;
    }

    @Generated
    public void setEnable(Boolean enable) {
        this.enable = enable;
    }

    @Deprecated
    @Generated
    public void setTransmitPower(Integer transmitPower) {
        this.transmitPower = transmitPower;
    }

    @Generated
    public void setMeasurePower(Integer measurePower) {
        this.measurePower = measurePower;
    }

    @Generated
    public void setAdvInterval(Integer advInterval) {
        this.advInterval = advInterval;
    }

    @Generated
    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    @Generated
    public void setMajor(String major) {
        this.major = major;
    }

    @Generated
    public void setMinor(String minor) {
        this.minor = minor;
    }

    @Generated
    public void setSelectMacInfo(List<ApBtDetailOpenApiVO> selectMacInfo) {
        this.selectMacInfo = selectMacInfo;
    }

    @Generated
    public void setBuildIn(Integer buildIn) {
        this.buildIn = buildIn;
    }

    @Generated
    public IotBtIbeaconOpenApiVO(String id, String name, Integer boundDeviceNum, List<String> macList, Boolean enable, Integer transmitPower, Integer measurePower, Integer advInterval, String uuid, String major, String minor, List<ApBtDetailOpenApiVO> selectMacInfo, Integer buildIn) {
        this.id = id;
        this.name = name;
        this.boundDeviceNum = boundDeviceNum;
        this.macList = macList;
        this.enable = enable;
        this.transmitPower = transmitPower;
        this.measurePower = measurePower;
        this.advInterval = advInterval;
        this.uuid = uuid;
        this.major = major;
        this.minor = minor;
        this.selectMacInfo = selectMacInfo;
        this.buildIn = buildIn;
    }

    @Generated
    public IotBtIbeaconOpenApiVO() {
    }

    @Generated
    public String toString() {
        return "IotBtIbeaconOpenApiVO(id=" + this.getId() + ", name=" + this.getName() + ", boundDeviceNum=" + this.getBoundDeviceNum() + ", macList=" + this.getMacList() + ", enable=" + this.getEnable() + ", transmitPower=" + this.getTransmitPower() + ", measurePower=" + this.getMeasurePower() + ", advInterval=" + this.getAdvInterval() + ", uuid=" + this.getUuid() + ", major=" + this.getMajor() + ", minor=" + this.getMinor() + ", selectMacInfo=" + this.getSelectMacInfo() + ", buildIn=" + this.getBuildIn() + ")";
    }

    @Generated
    public static abstract class IotBtIbeaconOpenApiVOBuilder<C extends IotBtIbeaconOpenApiVO, B extends IotBtIbeaconOpenApiVOBuilder<C, B>> {
        @Generated
        private String id;
        @Generated
        private String name;
        @Generated
        private Integer boundDeviceNum;
        @Generated
        private List<String> macList;
        @Generated
        private Boolean enable;
        @Generated
        private Integer transmitPower;
        @Generated
        private Integer measurePower;
        @Generated
        private Integer advInterval;
        @Generated
        private String uuid;
        @Generated
        private String major;
        @Generated
        private String minor;
        @Generated
        private List<ApBtDetailOpenApiVO> selectMacInfo;
        @Generated
        private Integer buildIn;

        @Generated
        public B id(String id) {
            this.id = id;
            return this.self();
        }

        @Generated
        public B name(String name) {
            this.name = name;
            return this.self();
        }

        @Generated
        public B boundDeviceNum(Integer boundDeviceNum) {
            this.boundDeviceNum = boundDeviceNum;
            return this.self();
        }

        @Generated
        public B macList(List<String> macList) {
            this.macList = macList;
            return this.self();
        }

        @Generated
        public B enable(Boolean enable) {
            this.enable = enable;
            return this.self();
        }

        @Deprecated
        @Generated
        public B transmitPower(Integer transmitPower) {
            this.transmitPower = transmitPower;
            return this.self();
        }

        @Generated
        public B measurePower(Integer measurePower) {
            this.measurePower = measurePower;
            return this.self();
        }

        @Generated
        public B advInterval(Integer advInterval) {
            this.advInterval = advInterval;
            return this.self();
        }

        @Generated
        public B uuid(String uuid) {
            this.uuid = uuid;
            return this.self();
        }

        @Generated
        public B major(String major) {
            this.major = major;
            return this.self();
        }

        @Generated
        public B minor(String minor) {
            this.minor = minor;
            return this.self();
        }

        @Generated
        public B selectMacInfo(List<ApBtDetailOpenApiVO> selectMacInfo) {
            this.selectMacInfo = selectMacInfo;
            return this.self();
        }

        @Generated
        public B buildIn(Integer buildIn) {
            this.buildIn = buildIn;
            return this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "IotBtIbeaconOpenApiVO.IotBtIbeaconOpenApiVOBuilder(id=" + this.id + ", name=" + this.name + ", boundDeviceNum=" + this.boundDeviceNum + ", macList=" + this.macList + ", enable=" + this.enable + ", transmitPower=" + this.transmitPower + ", measurePower=" + this.measurePower + ", advInterval=" + this.advInterval + ", uuid=" + this.uuid + ", major=" + this.major + ", minor=" + this.minor + ", selectMacInfo=" + this.selectMacInfo + ", buildIn=" + this.buildIn + ")";
        }
    }

    @Generated
    private static final class IotBtIbeaconOpenApiVOBuilderImpl
    extends IotBtIbeaconOpenApiVOBuilder<IotBtIbeaconOpenApiVO, IotBtIbeaconOpenApiVOBuilderImpl> {
        @Generated
        private IotBtIbeaconOpenApiVOBuilderImpl() {
        }

        @Override
        @Generated
        protected IotBtIbeaconOpenApiVOBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public IotBtIbeaconOpenApiVO build() {
            return new IotBtIbeaconOpenApiVO(this);
        }
    }
}

