/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.bluetooth.vo;

import com.tplink.smb.omada.common.validator.anons.NumberSet;
import com.tplink.smb.omada.manager.configuration.api.web.site.wireless.iot.IotAgingTimeVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.annotation.Nullable;
import jakarta.validation.constraints.NotNull;
import java.util.Objects;
import lombok.Generated;

public class IotAgingTimeOpenApiVO {
    @NotNull
    @Schema(name="agingTime", description="The system automatically removes a device's registry entry if no data reports are received within a predefined aging period.<br/>When format = 0, The parameter aging time should be within the range of 30-86400.<br/>When format = 1, The parameter aging time should be within the range of 1-1440.<br/>When format = 2, The parameter aging time should be within the range of 1-24.<br/>")
    private Integer agingTime;
    @NotNull
    @NumberSet(value={0, 1, 2}, message="The parameter [format] should be a value as follows: [0, 1, 2]")
    @Schema(name="format", description="The parameter [format] should be a value as follows: [0:second 1:minute; 2:hour]")
    private Integer format;

    @Nullable
    public static IotAgingTimeVO toWeb(IotAgingTimeOpenApiVO openApiVO) {
        if (Objects.isNull(openApiVO)) {
            return null;
        }
        return IotAgingTimeVO.builder().agingTime(openApiVO.getAgingTime()).format(openApiVO.getFormat()).build();
    }

    @Nullable
    public static IotAgingTimeOpenApiVO fromWeb(IotAgingTimeVO webVO) {
        if (Objects.isNull(webVO)) {
            return null;
        }
        IotAgingTimeOpenApiVO iotAgingTimeOpenApiVO = new IotAgingTimeOpenApiVO();
        iotAgingTimeOpenApiVO.setAgingTime(webVO.getAgingTime());
        iotAgingTimeOpenApiVO.setFormat(webVO.getFormat());
        return iotAgingTimeOpenApiVO;
    }

    @Generated
    public Integer getAgingTime() {
        return this.agingTime;
    }

    @Generated
    public Integer getFormat() {
        return this.format;
    }

    @Generated
    public void setAgingTime(Integer agingTime) {
        this.agingTime = agingTime;
    }

    @Generated
    public void setFormat(Integer format) {
        this.format = format;
    }

    @Generated
    public IotAgingTimeOpenApiVO(Integer agingTime, Integer format) {
        this.agingTime = agingTime;
        this.format = format;
    }

    @Generated
    public IotAgingTimeOpenApiVO() {
    }

    @Generated
    public String toString() {
        return "IotAgingTimeOpenApiVO(agingTime=" + this.getAgingTime() + ", format=" + this.getFormat() + ")";
    }
}

