/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.bluetooth.vo;

import com.tplink.smb.omada.common.validator.anons.NumberSet;
import com.tplink.smb.omada.manager.configuration.api.web.site.wireless.iot.IotServerVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.annotation.Nullable;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import jakarta.validation.constraints.Size;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;

public class ConfigIotServerOpenApiVO {
    @NotNull(message="The parameter [name] should not be null.")
    @Pattern(regexp="^[^ ]$|^[^ ].{0,62}[^ ]$", message="The parameter [name] should be 1 ~ 64 characters and do not add Spaces at the beginning and end.")
    @Schema(name="name", description="IoT Transport Stream setting name.")
    private @NotNull(message="The parameter [name] should not be null.") @Pattern(regexp="^[^ ]$|^[^ ].{0,62}[^ ]$", message="The parameter [name] should be 1 ~ 64 characters and do not add Spaces at the beginning and end.") String name;
    @NotNull(message="The parameter [enable] should not be null.")
    @Schema(name="enable", description="Whether to enable the IoT Transport Stream setting.")
    private @NotNull(message="The parameter [enable] should not be null.") Boolean enable;
    @NotNull(message="The parameter [serverUrl] should not be null.")
    @Schema(name="serverUrl", description="If the service type is http, the server URL must start with http://.")
    private @NotNull(message="The parameter [serverUrl] should not be null.") String serverUrl;
    @NotNull(message="The parameter [serverType] should not be null.")
    @NumberSet(value={0}, message="The server type should be a value as follows: [0: http].")
    @Schema(name="serverType", description="The server type should be a value as follows: [0: http].")
    private @NotNull(message="The parameter [serverType] should not be null.") Integer serverType;
    @NotNull(message="The parameter [deviceClasses] should not be null.")
    @Schema(name="deviceClasses", description="Supports protocol-based filtering during IoT data reporting processes.<br />The device class list should contain the value as follows: [0:minew; 1:iBeacon; 2:Eddystone].")
    @Size(min=1, message="The device class list can not be empty.")
    private @NotNull(message="The parameter [deviceClasses] should not be null.") @Size(min=1, message="The device class list can not be empty.") List<Integer> deviceClasses;
    @Range(min=1L, max=3600L, message="The parameter [reportInterval] should be within the range of 1\u20133600.")
    @Schema(name="reportInterval", description="Data reporting interval configuration for AP devices in IoT systems.The parameter [reportInterval] should be within the range of 1\u20133600 in seconds, and it cannot be null when blePeriodicTelemetry is enabled.")
    private @Range(min=1L, max=3600L, message="The parameter [reportInterval] should be within the range of 1\u20133600.") Integer reportInterval;
    @NotNull(message="The parameter [authentication] should not be null.")
    @NumberSet(value={0}, message="The parameter [authentication] should be a value as follows:[0]")
    @Schema(name="authentication", description="The parameter [authentication] should be a value as follows:[0:Use Token].")
    private @NotNull(message="The parameter [authentication] should not be null.") Integer authentication;
    @NotNull
    @Pattern(regexp="^[^ ]$|^[^ ].{0,126}[^ ]$", message="The parameter [accessToken] should be 1 ~ 128 characters and do not add Spaces at the beginning and end.")
    @Schema(name="accessToken", description="This parameter becomes mandatory when the authentication method is set to \"Use Token\".<br/>Note:The parameter [clientId] should be 1 ~ 128 characters.")
    private @NotNull @Pattern(regexp="^[^ ]$|^[^ ].{0,126}[^ ]$", message="The parameter [accessToken] should be 1 ~ 128 characters and do not add Spaces at the beginning and end.") String accessToken;
    @NotNull
    @Pattern(regexp="^[^ ]$|^[^ ].{0,126}[^ ]$", message="The parameter [clientId] should be 1 ~ 128 characters and do not add Spaces at the beginning and end.")
    @Schema(name="clientId", description="This parameter becomes mandatory when the authentication method is set to \"Use Token\".<br />Note:The parameter [clientId] should be 1 ~ 128 characters.")
    private @NotNull @Pattern(regexp="^[^ ]$|^[^ ].{0,126}[^ ]$", message="The parameter [clientId] should be 1 ~ 128 characters and do not add Spaces at the beginning and end.") String clientId;
    @NotNull(message="The parameter [rssiFormat] should not be null.")
    @NumberSet(value={0, 1, 2, 3, 4}, message="The parameter [rssiFormat] should be a value as follows: [0, 1, 2, 3, 4].")
    @Schema(name="rssiFormat", description="The signal strength reporting format currently supports five types: [0:Average; 1:Max; 2:Last; 3:Smooth; 4:Bulk].")
    private @NotNull(message="The parameter [rssiFormat] should not be null.") Integer rssiFormat;
    @Schema(name="filtersType", description="User-defined settings to manage AP device filtering rules for IoT devices.<br />The parameter [filtersType] should contain the value as follows:[0:Company Identifier; 1:Vendor; 2:Local Name; 3:Service UUID; 4:Mac Oui; 5:iBeacon UUID; 6:UID; 7:URL].")
    private List<Integer> filtersType;
    @Schema(name="filters", description="The keys in the [filters] map represent the filter types, while the values correspond to the specific filtering criteria or values associated with each filter type.<br />Note:<br />Filter type = 0, The Company Identifier must conform to a 4-digit or 6-digit hexadecimal encoding. It is only applicable to ibeacon devices<br />Filter type = 1, The Vendor should not exceed 255 bytes in length.<br />Filter type = 2, The Local Name should not exceed 120 bytes in length. It is only applicable to minew devices.<br />Filter type = 3, The Service UUID must conform to a 4-digit hexadecimal encoding. It is only applicable to minew and eddystone devices.<br />Filter type = 4, The Mac Oui must conform to a 6-digit hexadecimal encoding.<br />Filter type = 5, The iBeacon UUID must conform to a 32-digit hexadecimal encoding. It is only applicable to iBeacon devices.<br />Filter type = 6, The UID must conform to a 20-digit or 32-digit hexadecimal encoding. It is only applicable to eddystone devices.<br />Filter type = 7, The URL should not include a scheme. It is only applicable to eddystone devices.<br />")
    private Map<Integer, List<String>> filters;
    @Schema(name="countOnly", description="A switch that controls whether the AP device exclusively reports the count of IoT devices, and it cannot be null when blePeriodicTelemetry is enabled.")
    private Boolean countOnly;
    @NotNull(message="The parameter [blePeriodicTelemetry] should not be null.")
    @Schema(name="blePeriodicTelemetry", description="Whether to enable the BLE Periodic Telemetry. When disabled no periodic packets will be uploaded.")
    private @NotNull(message="The parameter [blePeriodicTelemetry] should not be null.") Boolean blePeriodicTelemetry;
    @NotNull
    @Schema(name="rawData", description="Whether to enable the BLE Data Forwarding. When enabled, the AP directly reports the Bluetooth packet rawData to the server.")
    private Boolean rawData;

    @Nullable
    public static IotServerVO toWebVO(ConfigIotServerOpenApiVO openApiVO) {
        if (Objects.isNull(openApiVO)) {
            return null;
        }
        IotServerVO webVO = new IotServerVO();
        webVO.setName(openApiVO.getName());
        webVO.setEnable(openApiVO.getEnable());
        webVO.setServerUrl(openApiVO.getServerUrl());
        webVO.setServerType(openApiVO.getServerType());
        webVO.setDeviceClasses(openApiVO.getDeviceClasses());
        webVO.setReportInterval(openApiVO.getReportInterval());
        webVO.setAuthentication(openApiVO.getAuthentication());
        webVO.setAccessToken(openApiVO.getAccessToken());
        webVO.setClientId(openApiVO.getClientId());
        webVO.setRssiFormat(openApiVO.getRssiFormat());
        webVO.setFiltersType(openApiVO.getFiltersType());
        webVO.setFilters(openApiVO.getFilters());
        webVO.setCountOnly(openApiVO.getCountOnly());
        webVO.setBlePeriodicTelemetry(openApiVO.getBlePeriodicTelemetry());
        webVO.setRawData(openApiVO.getRawData());
        return webVO;
    }

    @Generated
    protected ConfigIotServerOpenApiVO(ConfigIotServerOpenApiVOBuilder<?, ?> b2) {
        this.name = b2.name;
        this.enable = b2.enable;
        this.serverUrl = b2.serverUrl;
        this.serverType = b2.serverType;
        this.deviceClasses = b2.deviceClasses;
        this.reportInterval = b2.reportInterval;
        this.authentication = b2.authentication;
        this.accessToken = b2.accessToken;
        this.clientId = b2.clientId;
        this.rssiFormat = b2.rssiFormat;
        this.filtersType = b2.filtersType;
        this.filters = b2.filters;
        this.countOnly = b2.countOnly;
        this.blePeriodicTelemetry = b2.blePeriodicTelemetry;
        this.rawData = b2.rawData;
    }

    @Generated
    public static ConfigIotServerOpenApiVOBuilder<?, ?> builder() {
        return new ConfigIotServerOpenApiVOBuilderImpl();
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Boolean getEnable() {
        return this.enable;
    }

    @Generated
    public String getServerUrl() {
        return this.serverUrl;
    }

    @Generated
    public Integer getServerType() {
        return this.serverType;
    }

    @Generated
    public List<Integer> getDeviceClasses() {
        return this.deviceClasses;
    }

    @Generated
    public Integer getReportInterval() {
        return this.reportInterval;
    }

    @Generated
    public Integer getAuthentication() {
        return this.authentication;
    }

    @Generated
    public String getAccessToken() {
        return this.accessToken;
    }

    @Generated
    public String getClientId() {
        return this.clientId;
    }

    @Generated
    public Integer getRssiFormat() {
        return this.rssiFormat;
    }

    @Generated
    public List<Integer> getFiltersType() {
        return this.filtersType;
    }

    @Generated
    public Map<Integer, List<String>> getFilters() {
        return this.filters;
    }

    @Generated
    public Boolean getCountOnly() {
        return this.countOnly;
    }

    @Generated
    public Boolean getBlePeriodicTelemetry() {
        return this.blePeriodicTelemetry;
    }

    @Generated
    public Boolean getRawData() {
        return this.rawData;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setEnable(Boolean enable) {
        this.enable = enable;
    }

    @Generated
    public void setServerUrl(String serverUrl) {
        this.serverUrl = serverUrl;
    }

    @Generated
    public void setServerType(Integer serverType) {
        this.serverType = serverType;
    }

    @Generated
    public void setDeviceClasses(List<Integer> deviceClasses) {
        this.deviceClasses = deviceClasses;
    }

    @Generated
    public void setReportInterval(Integer reportInterval) {
        this.reportInterval = reportInterval;
    }

    @Generated
    public void setAuthentication(Integer authentication) {
        this.authentication = authentication;
    }

    @Generated
    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    @Generated
    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    @Generated
    public void setRssiFormat(Integer rssiFormat) {
        this.rssiFormat = rssiFormat;
    }

    @Generated
    public void setFiltersType(List<Integer> filtersType) {
        this.filtersType = filtersType;
    }

    @Generated
    public void setFilters(Map<Integer, List<String>> filters) {
        this.filters = filters;
    }

    @Generated
    public void setCountOnly(Boolean countOnly) {
        this.countOnly = countOnly;
    }

    @Generated
    public void setBlePeriodicTelemetry(Boolean blePeriodicTelemetry) {
        this.blePeriodicTelemetry = blePeriodicTelemetry;
    }

    @Generated
    public void setRawData(Boolean rawData) {
        this.rawData = rawData;
    }

    @Generated
    public ConfigIotServerOpenApiVO(String name, Boolean enable, String serverUrl, Integer serverType, List<Integer> deviceClasses, Integer reportInterval, Integer authentication, String accessToken, String clientId, Integer rssiFormat, List<Integer> filtersType, Map<Integer, List<String>> filters, Boolean countOnly, Boolean blePeriodicTelemetry, Boolean rawData) {
        this.name = name;
        this.enable = enable;
        this.serverUrl = serverUrl;
        this.serverType = serverType;
        this.deviceClasses = deviceClasses;
        this.reportInterval = reportInterval;
        this.authentication = authentication;
        this.accessToken = accessToken;
        this.clientId = clientId;
        this.rssiFormat = rssiFormat;
        this.filtersType = filtersType;
        this.filters = filters;
        this.countOnly = countOnly;
        this.blePeriodicTelemetry = blePeriodicTelemetry;
        this.rawData = rawData;
    }

    @Generated
    public ConfigIotServerOpenApiVO() {
    }

    @Generated
    public String toString() {
        return "ConfigIotServerOpenApiVO(name=" + this.getName() + ", enable=" + this.getEnable() + ", serverUrl=" + this.getServerUrl() + ", serverType=" + this.getServerType() + ", deviceClasses=" + this.getDeviceClasses() + ", reportInterval=" + this.getReportInterval() + ", authentication=" + this.getAuthentication() + ", accessToken=" + this.getAccessToken() + ", clientId=" + this.getClientId() + ", rssiFormat=" + this.getRssiFormat() + ", filtersType=" + this.getFiltersType() + ", filters=" + this.getFilters() + ", countOnly=" + this.getCountOnly() + ", blePeriodicTelemetry=" + this.getBlePeriodicTelemetry() + ", rawData=" + this.getRawData() + ")";
    }

    @Generated
    public static abstract class ConfigIotServerOpenApiVOBuilder<C extends ConfigIotServerOpenApiVO, B extends ConfigIotServerOpenApiVOBuilder<C, B>> {
        @Generated
        private String name;
        @Generated
        private Boolean enable;
        @Generated
        private String serverUrl;
        @Generated
        private Integer serverType;
        @Generated
        private List<Integer> deviceClasses;
        @Generated
        private Integer reportInterval;
        @Generated
        private Integer authentication;
        @Generated
        private String accessToken;
        @Generated
        private String clientId;
        @Generated
        private Integer rssiFormat;
        @Generated
        private List<Integer> filtersType;
        @Generated
        private Map<Integer, List<String>> filters;
        @Generated
        private Boolean countOnly;
        @Generated
        private Boolean blePeriodicTelemetry;
        @Generated
        private Boolean rawData;

        @Generated
        public B name(String name) {
            this.name = name;
            return this.self();
        }

        @Generated
        public B enable(Boolean enable) {
            this.enable = enable;
            return this.self();
        }

        @Generated
        public B serverUrl(String serverUrl) {
            this.serverUrl = serverUrl;
            return this.self();
        }

        @Generated
        public B serverType(Integer serverType) {
            this.serverType = serverType;
            return this.self();
        }

        @Generated
        public B deviceClasses(List<Integer> deviceClasses) {
            this.deviceClasses = deviceClasses;
            return this.self();
        }

        @Generated
        public B reportInterval(Integer reportInterval) {
            this.reportInterval = reportInterval;
            return this.self();
        }

        @Generated
        public B authentication(Integer authentication) {
            this.authentication = authentication;
            return this.self();
        }

        @Generated
        public B accessToken(String accessToken) {
            this.accessToken = accessToken;
            return this.self();
        }

        @Generated
        public B clientId(String clientId) {
            this.clientId = clientId;
            return this.self();
        }

        @Generated
        public B rssiFormat(Integer rssiFormat) {
            this.rssiFormat = rssiFormat;
            return this.self();
        }

        @Generated
        public B filtersType(List<Integer> filtersType) {
            this.filtersType = filtersType;
            return this.self();
        }

        @Generated
        public B filters(Map<Integer, List<String>> filters) {
            this.filters = filters;
            return this.self();
        }

        @Generated
        public B countOnly(Boolean countOnly) {
            this.countOnly = countOnly;
            return this.self();
        }

        @Generated
        public B blePeriodicTelemetry(Boolean blePeriodicTelemetry) {
            this.blePeriodicTelemetry = blePeriodicTelemetry;
            return this.self();
        }

        @Generated
        public B rawData(Boolean rawData) {
            this.rawData = rawData;
            return this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "ConfigIotServerOpenApiVO.ConfigIotServerOpenApiVOBuilder(name=" + this.name + ", enable=" + this.enable + ", serverUrl=" + this.serverUrl + ", serverType=" + this.serverType + ", deviceClasses=" + this.deviceClasses + ", reportInterval=" + this.reportInterval + ", authentication=" + this.authentication + ", accessToken=" + this.accessToken + ", clientId=" + this.clientId + ", rssiFormat=" + this.rssiFormat + ", filtersType=" + this.filtersType + ", filters=" + this.filters + ", countOnly=" + this.countOnly + ", blePeriodicTelemetry=" + this.blePeriodicTelemetry + ", rawData=" + this.rawData + ")";
        }
    }

    @Generated
    private static final class ConfigIotServerOpenApiVOBuilderImpl
    extends ConfigIotServerOpenApiVOBuilder<ConfigIotServerOpenApiVO, ConfigIotServerOpenApiVOBuilderImpl> {
        @Generated
        private ConfigIotServerOpenApiVOBuilderImpl() {
        }

        @Override
        @Generated
        protected ConfigIotServerOpenApiVOBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public ConfigIotServerOpenApiVO build() {
            return new ConfigIotServerOpenApiVO(this);
        }
    }
}

