/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.bluetooth.vo;

import com.tplink.smb.omada.a.a;
import com.tplink.smb.omada.manager.configuration.api.web.site.wireless.iot.IotBtIbeaconVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.annotation.Nullable;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import jakarta.validation.constraints.Size;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;

public class ConfigIotBtIbeaconV2OpenApiVO {
    @NotNull(message="The parameter [name] should not be null.")
    @Pattern(regexp="^[^ ]$|^[^ ].{0,62}[^ ]$", message="The parameter [name] should be 1 ~ 64 characters and do not add Spaces at the beginning and end.")
    @Schema(name="name", description="The Bluetooth Advertising seting name. The name of built-in entry are not allowed to be modified.")
    private @NotNull(message="The parameter [name] should not be null.") @Pattern(regexp="^[^ ]$|^[^ ].{0,62}[^ ]$", message="The parameter [name] should be 1 ~ 64 characters and do not add Spaces at the beginning and end.") String name;
    @NotNull(message="The parameter [macList] should not be null.")
    @Size(min=1, message="The parameter [macList] is empty.The configuration needs to be bound to at least one device.")
    @Schema(name="macList", description="List of device MAC addresses bound to this configuration.")
    @a
    private @NotNull(message="The parameter [macList] should not be null.") @Size(min=1, message="The parameter [macList] is empty.The configuration needs to be bound to at least one device.") List<String> macList;
    @Schema(name="enable", description="Whether to enable the Bluetooth Advertising setting.(Disable by default)")
    private Boolean enable;
    @Range(min=-97L, max=0L, message="The parameter [measurePower] should be within the range of -97\u20130")
    @Schema(name="measurePower", description="RSSI Calibration Value. The parameter [measurePower] is used to input the RSSI measured at a 1-meter distance from the device, enabling positioning functionality.(-65 by default)")
    private @Range(min=-97L, max=0L, message="The parameter [measurePower] should be within the range of -97\u20130") Integer measurePower;
    @Range(min=100L, max=10240L, message="The parameter [measurePower] should be within the range of 100\u201310240.")
    @Schema(name="advInterval", description="Advertising interval in milliseconds.(500 by default)")
    private @Range(min=100L, max=10240L, message="The parameter [measurePower] should be within the range of 100\u201310240.") Integer advInterval;
    @NotNull
    @Schema(name="uuid", description="The UUID (Universally Unique Identifier) of the advertising ibeacon packet.")
    private String uuid;
    @NotNull
    @Schema(name="major", description="The major value of adverting ibeacon packet, indicating a larger group.")
    private String major;
    @NotNull
    @Schema(name="minor", description="The minor value of adverting ibeacon packet, indicating a smaller group.")
    private String minor;

    @Nullable
    public static IotBtIbeaconVO toWeb(ConfigIotBtIbeaconV2OpenApiVO openApiVO) {
        if (Objects.isNull(openApiVO)) {
            return null;
        }
        IotBtIbeaconVO webVO = new IotBtIbeaconVO();
        webVO.setName(openApiVO.getName());
        webVO.setMacList(openApiVO.getMacList());
        webVO.setEnable(openApiVO.getEnable());
        webVO.setMeasurePower(openApiVO.getMeasurePower());
        webVO.setAdvInterval(openApiVO.getAdvInterval());
        webVO.setUuid(openApiVO.getUuid());
        webVO.setMajor(openApiVO.getMajor());
        webVO.setMinor(openApiVO.getMinor());
        return webVO;
    }

    @Generated
    protected ConfigIotBtIbeaconV2OpenApiVO(ConfigIotBtIbeaconV2OpenApiVOBuilder<?, ?> b2) {
        this.name = b2.name;
        this.macList = b2.macList;
        this.enable = b2.enable;
        this.measurePower = b2.measurePower;
        this.advInterval = b2.advInterval;
        this.uuid = b2.uuid;
        this.major = b2.major;
        this.minor = b2.minor;
    }

    @Generated
    public static ConfigIotBtIbeaconV2OpenApiVOBuilder<?, ?> builder() {
        return new ConfigIotBtIbeaconV2OpenApiVOBuilderImpl();
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public List<String> getMacList() {
        return this.macList;
    }

    @Generated
    public Boolean getEnable() {
        return this.enable;
    }

    @Generated
    public Integer getMeasurePower() {
        return this.measurePower;
    }

    @Generated
    public Integer getAdvInterval() {
        return this.advInterval;
    }

    @Generated
    public String getUuid() {
        return this.uuid;
    }

    @Generated
    public String getMajor() {
        return this.major;
    }

    @Generated
    public String getMinor() {
        return this.minor;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setMacList(List<String> macList) {
        this.macList = macList;
    }

    @Generated
    public void setEnable(Boolean enable) {
        this.enable = enable;
    }

    @Generated
    public void setMeasurePower(Integer measurePower) {
        this.measurePower = measurePower;
    }

    @Generated
    public void setAdvInterval(Integer advInterval) {
        this.advInterval = advInterval;
    }

    @Generated
    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    @Generated
    public void setMajor(String major) {
        this.major = major;
    }

    @Generated
    public void setMinor(String minor) {
        this.minor = minor;
    }

    @Generated
    public ConfigIotBtIbeaconV2OpenApiVO(String name, List<String> macList, Boolean enable, Integer measurePower, Integer advInterval, String uuid, String major, String minor) {
        this.name = name;
        this.macList = macList;
        this.enable = enable;
        this.measurePower = measurePower;
        this.advInterval = advInterval;
        this.uuid = uuid;
        this.major = major;
        this.minor = minor;
    }

    @Generated
    public ConfigIotBtIbeaconV2OpenApiVO() {
    }

    @Generated
    public String toString() {
        return "ConfigIotBtIbeaconV2OpenApiVO(name=" + this.getName() + ", macList=" + this.getMacList() + ", enable=" + this.getEnable() + ", measurePower=" + this.getMeasurePower() + ", advInterval=" + this.getAdvInterval() + ", uuid=" + this.getUuid() + ", major=" + this.getMajor() + ", minor=" + this.getMinor() + ")";
    }

    @Generated
    public static abstract class ConfigIotBtIbeaconV2OpenApiVOBuilder<C extends ConfigIotBtIbeaconV2OpenApiVO, B extends ConfigIotBtIbeaconV2OpenApiVOBuilder<C, B>> {
        @Generated
        private String name;
        @Generated
        private List<String> macList;
        @Generated
        private Boolean enable;
        @Generated
        private Integer measurePower;
        @Generated
        private Integer advInterval;
        @Generated
        private String uuid;
        @Generated
        private String major;
        @Generated
        private String minor;

        @Generated
        public B name(String name) {
            this.name = name;
            return this.self();
        }

        @Generated
        public B macList(List<String> macList) {
            this.macList = macList;
            return this.self();
        }

        @Generated
        public B enable(Boolean enable) {
            this.enable = enable;
            return this.self();
        }

        @Generated
        public B measurePower(Integer measurePower) {
            this.measurePower = measurePower;
            return this.self();
        }

        @Generated
        public B advInterval(Integer advInterval) {
            this.advInterval = advInterval;
            return this.self();
        }

        @Generated
        public B uuid(String uuid) {
            this.uuid = uuid;
            return this.self();
        }

        @Generated
        public B major(String major) {
            this.major = major;
            return this.self();
        }

        @Generated
        public B minor(String minor) {
            this.minor = minor;
            return this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "ConfigIotBtIbeaconV2OpenApiVO.ConfigIotBtIbeaconV2OpenApiVOBuilder(name=" + this.name + ", macList=" + this.macList + ", enable=" + this.enable + ", measurePower=" + this.measurePower + ", advInterval=" + this.advInterval + ", uuid=" + this.uuid + ", major=" + this.major + ", minor=" + this.minor + ")";
        }
    }

    @Generated
    private static final class ConfigIotBtIbeaconV2OpenApiVOBuilderImpl
    extends ConfigIotBtIbeaconV2OpenApiVOBuilder<ConfigIotBtIbeaconV2OpenApiVO, ConfigIotBtIbeaconV2OpenApiVOBuilderImpl> {
        @Generated
        private ConfigIotBtIbeaconV2OpenApiVOBuilderImpl() {
        }

        @Override
        @Generated
        protected ConfigIotBtIbeaconV2OpenApiVOBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public ConfigIotBtIbeaconV2OpenApiVO build() {
            return new ConfigIotBtIbeaconV2OpenApiVO(this);
        }
    }
}

