/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.bluetooth.vo;

import com.tplink.smb.omada.common.validator.anons.NumberSet;
import com.tplink.smb.omada.manager.configuration.api.web.site.wireless.iot.IotBtIbeaconVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.annotation.Nullable;
import java.util.Objects;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;

public class BatchConfigIotBtIbeaconOpenApiVO {
    @Schema(name="enable", description="Whether to enable the Bluetooth Advertising setting.(Disable by default)")
    private Boolean enable;
    @Deprecated
    @NumberSet(value={-20, -18, -15, -12, -10, -9, -6, -5, -3, 0, 1, 2, 3, 4, 5, 14, 15, 16, 17, 18, 19, 20}, message="The parameter [transmitPower] should be a value as follows:[-20, -18, -15, -12, -10, -9, -6, -5, -3, 0, 1, 2, 3, 4, 5, 14, 15, 16, 17, 18, 19, 20].")
    @Schema(name="transmitPower", description="Broadcast transmission power.<br />The parameter [transmitPower] should be a value as follows:[-20, -18, -15, -12, -10, -9, -6, -5, -3, 0, 1, 2, 3, 4, 5, 14, 15, 16, 17, 18, 19, 20].(0 by default)")
    private Integer transmitPower;
    @Range(min=-97L, max=0L, message="The parameter [measurePower] should be within the range of -97\u20130.")
    @Schema(name="measurePower", description="RSSI Calibration Value. The parameter [measurePower] is used to input the RSSI measured at a 1-meter distance from the device, enabling positioning functionality.(-65 by default)")
    private @Range(min=-97L, max=0L, message="The parameter [measurePower] should be within the range of -97\u20130.") Integer measurePower;
    @Range(min=100L, max=10240L, message="The parameter [measurePower] should be within the range of 100\u201310240.")
    @Schema(name="advInterval", description="Advertising interval in milliseconds.(500 by default)")
    private @Range(min=100L, max=10240L, message="The parameter [measurePower] should be within the range of 100\u201310240.") Integer advInterval;
    @Schema(name="uuid", description="The UUID (Universally Unique Identifier) of the advertising ibeacon packet.")
    private String uuid;
    @Schema(name="major", description="The major value of adverting ibeacon packet, indicating a larger group.")
    private String major;
    @Schema(name="minor", description="The minor value of adverting ibeacon packet, indicating a smaller group.")
    private String minor;

    @Nullable
    public static IotBtIbeaconVO toWeb(BatchConfigIotBtIbeaconOpenApiVO openApiVO) {
        if (Objects.isNull(openApiVO)) {
            return null;
        }
        IotBtIbeaconVO webVO = new IotBtIbeaconVO();
        webVO.setEnable(openApiVO.getEnable());
        webVO.setTransmitPower(openApiVO.getTransmitPower());
        webVO.setMeasurePower(openApiVO.getMeasurePower());
        webVO.setAdvInterval(openApiVO.getAdvInterval());
        webVO.setUuid(openApiVO.getUuid());
        webVO.setMajor(openApiVO.getMajor());
        webVO.setMinor(openApiVO.getMinor());
        return webVO;
    }

    @Generated
    protected BatchConfigIotBtIbeaconOpenApiVO(BatchConfigIotBtIbeaconOpenApiVOBuilder<?, ?> b2) {
        this.enable = b2.enable;
        this.transmitPower = b2.transmitPower;
        this.measurePower = b2.measurePower;
        this.advInterval = b2.advInterval;
        this.uuid = b2.uuid;
        this.major = b2.major;
        this.minor = b2.minor;
    }

    @Generated
    public static BatchConfigIotBtIbeaconOpenApiVOBuilder<?, ?> builder() {
        return new BatchConfigIotBtIbeaconOpenApiVOBuilderImpl();
    }

    @Generated
    public Boolean getEnable() {
        return this.enable;
    }

    @Deprecated
    @Generated
    public Integer getTransmitPower() {
        return this.transmitPower;
    }

    @Generated
    public Integer getMeasurePower() {
        return this.measurePower;
    }

    @Generated
    public Integer getAdvInterval() {
        return this.advInterval;
    }

    @Generated
    public String getUuid() {
        return this.uuid;
    }

    @Generated
    public String getMajor() {
        return this.major;
    }

    @Generated
    public String getMinor() {
        return this.minor;
    }

    @Generated
    public void setEnable(Boolean enable) {
        this.enable = enable;
    }

    @Deprecated
    @Generated
    public void setTransmitPower(Integer transmitPower) {
        this.transmitPower = transmitPower;
    }

    @Generated
    public void setMeasurePower(Integer measurePower) {
        this.measurePower = measurePower;
    }

    @Generated
    public void setAdvInterval(Integer advInterval) {
        this.advInterval = advInterval;
    }

    @Generated
    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    @Generated
    public void setMajor(String major) {
        this.major = major;
    }

    @Generated
    public void setMinor(String minor) {
        this.minor = minor;
    }

    @Generated
    public BatchConfigIotBtIbeaconOpenApiVO(Boolean enable, Integer transmitPower, Integer measurePower, Integer advInterval, String uuid, String major, String minor) {
        this.enable = enable;
        this.transmitPower = transmitPower;
        this.measurePower = measurePower;
        this.advInterval = advInterval;
        this.uuid = uuid;
        this.major = major;
        this.minor = minor;
    }

    @Generated
    public BatchConfigIotBtIbeaconOpenApiVO() {
    }

    @Generated
    public String toString() {
        return "BatchConfigIotBtIbeaconOpenApiVO(enable=" + this.getEnable() + ", transmitPower=" + this.getTransmitPower() + ", measurePower=" + this.getMeasurePower() + ", advInterval=" + this.getAdvInterval() + ", uuid=" + this.getUuid() + ", major=" + this.getMajor() + ", minor=" + this.getMinor() + ")";
    }

    @Generated
    public static abstract class BatchConfigIotBtIbeaconOpenApiVOBuilder<C extends BatchConfigIotBtIbeaconOpenApiVO, B extends BatchConfigIotBtIbeaconOpenApiVOBuilder<C, B>> {
        @Generated
        private Boolean enable;
        @Generated
        private Integer transmitPower;
        @Generated
        private Integer measurePower;
        @Generated
        private Integer advInterval;
        @Generated
        private String uuid;
        @Generated
        private String major;
        @Generated
        private String minor;

        @Generated
        public B enable(Boolean enable) {
            this.enable = enable;
            return this.self();
        }

        @Deprecated
        @Generated
        public B transmitPower(Integer transmitPower) {
            this.transmitPower = transmitPower;
            return this.self();
        }

        @Generated
        public B measurePower(Integer measurePower) {
            this.measurePower = measurePower;
            return this.self();
        }

        @Generated
        public B advInterval(Integer advInterval) {
            this.advInterval = advInterval;
            return this.self();
        }

        @Generated
        public B uuid(String uuid) {
            this.uuid = uuid;
            return this.self();
        }

        @Generated
        public B major(String major) {
            this.major = major;
            return this.self();
        }

        @Generated
        public B minor(String minor) {
            this.minor = minor;
            return this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "BatchConfigIotBtIbeaconOpenApiVO.BatchConfigIotBtIbeaconOpenApiVOBuilder(enable=" + this.enable + ", transmitPower=" + this.transmitPower + ", measurePower=" + this.measurePower + ", advInterval=" + this.advInterval + ", uuid=" + this.uuid + ", major=" + this.major + ", minor=" + this.minor + ")";
        }
    }

    @Generated
    private static final class BatchConfigIotBtIbeaconOpenApiVOBuilderImpl
    extends BatchConfigIotBtIbeaconOpenApiVOBuilder<BatchConfigIotBtIbeaconOpenApiVO, BatchConfigIotBtIbeaconOpenApiVOBuilderImpl> {
        @Generated
        private BatchConfigIotBtIbeaconOpenApiVOBuilderImpl() {
        }

        @Override
        @Generated
        protected BatchConfigIotBtIbeaconOpenApiVOBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public BatchConfigIotBtIbeaconOpenApiVO build() {
            return new BatchConfigIotBtIbeaconOpenApiVO(this);
        }
    }
}

