/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.apnprofile;

import com.tplink.smb.omada.manager.configuration.api.web.site.profile.dto.ApnProfileVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.annotation.Nullable;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;

@Schema(name="ApnProfile")
public class ApnProfileOpenApiVO {
    @Schema(name="id", description="APN profile ID")
    private String id;
    @NotNull
    @Pattern(regexp="^[^ ]$|^[^ ].{0,62}[^ ]$", message="Parameter [name] should be 1 - 64 characters")
    @Schema(name="name", description="APN profile name, name should contain 1 to 64 characters.")
    private @NotNull @Pattern(regexp="^[^ ]$|^[^ ].{0,62}[^ ]$", message="Parameter [name] should be 1 - 64 characters") String name;
    @Range(max=2L, message="Parameter [pdpType] should be 0 or 1 or 2")
    @NotNull
    @Schema(name="pdpType", description="PdpType should be a value as follows: 0: IPv4; 1: IPv6; 2: IPv4 & IPv6.")
    private @Range(max=2L, message="Parameter [pdpType] should be 0 or 1 or 2") @NotNull Integer pdpType;
    @Range(max=1L, message="Parameter [apnType] should be 0 or 1")
    @NotNull
    @Schema(name="apnType", description="ApnType should be a value as follows: 0: static; 1: dynamic.")
    private @Range(max=1L, message="Parameter [apnType] should be 0 or 1") @NotNull Integer apnType;
    @Nullable
    @Pattern(regexp="^[^ ]$|^[^ ].{0,62}[^ ]$", message="Parameter [apn] should be 1 - 64 characters")
    @Schema(name="apn", description="Access point name, only for apnType static, should contain 1 to 64 characters and should meet the following requirements:\n    1. Should not start with \"rac\", \"lac\", \"sgsn\" or \"rnc\" and end with \".gprs\", ignoring case.\n    2. Should not contain \".*.\", \".-\", \"-.\" and spaces.\n    3. Should not contain any of the characters #!$%^&*(),:;\"'|\\@. ")
    private @Pattern(regexp="^[^ ]$|^[^ ].{0,62}[^ ]$", message="Parameter [apn] should be 1 - 64 characters") String apn;
    @Nullable
    @Pattern(regexp="^([\\041-\\053]|[\\055-\\0176]){1,64}$", message="Parameter [username] should be 1 - 64 characters, spaces, comma, single quotation marks and double quotation marks are not allowed.")
    @Schema(name="username", description="Username should contain 1 to 64 characters, spaces, comma, single quotation marks and double quotation marks are not allowed.")
    private @Pattern(regexp="^([\\041-\\053]|[\\055-\\0176]){1,64}$", message="Parameter [username] should be 1 - 64 characters, spaces, comma, single quotation marks and double quotation marks are not allowed.") String username;
    @Nullable
    @Pattern(regexp="^([\\041-\\053]|[\\055-\\0176]){1,64}$", message="Parameter [password] should be 1 - 64 characters, spaces, comma, single quotation marks and double quotation marks are not allowed.")
    @Schema(name="password", description="Password should contain 1 to 64 characters, spaces, comma, single quotation marks and double quotation marks are not allowed.")
    private @Pattern(regexp="^([\\041-\\053]|[\\055-\\0176]){1,64}$", message="Parameter [password] should be 1 - 64 characters, spaces, comma, single quotation marks and double quotation marks are not allowed.") String password;
    @Range(max=2L, message="Parameter [authentication] should be 0 or 1 or 2")
    @Schema(name="authentication", description="Authentication should be a value as follows: 0: None; 1: PAP; 2: CHAP")
    @NotNull
    private @Range(max=2L, message="Parameter [authentication] should be 0 or 1 or 2") @NotNull Integer authentication;
    @Schema(name="buildIn", description="Indicates whether this APN profile is a built-in APN profile for SIM card.")
    private Boolean buildIn;
    @Schema(name="applyToSIM", description="1: apply to SIM1; 2: apply to SIM2; 3: apply to SIM1 and SIM2.")
    private Integer applyToSIM;

    public static ApnProfileOpenApiVO toOpenApiVO(ApnProfileVO apnProfileVO) {
        ApnProfileOpenApiVO apnProfileOpenApiVO = new ApnProfileOpenApiVO();
        apnProfileOpenApiVO.setId(apnProfileVO.getId());
        apnProfileOpenApiVO.setName(apnProfileVO.getName());
        apnProfileOpenApiVO.setPdpType(apnProfileVO.getPdpType());
        apnProfileOpenApiVO.setApnType(apnProfileVO.getApnType());
        apnProfileOpenApiVO.setApn(apnProfileVO.getApn());
        apnProfileOpenApiVO.setUsername(apnProfileVO.getUsername());
        apnProfileOpenApiVO.setPassword(apnProfileVO.getPassword());
        apnProfileOpenApiVO.setAuthentication(apnProfileVO.getAuthentication());
        apnProfileOpenApiVO.setBuildIn(apnProfileVO.getBuildIn());
        apnProfileOpenApiVO.setApplyToSIM(apnProfileVO.getApplyToSIM());
        return apnProfileOpenApiVO;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Integer getPdpType() {
        return this.pdpType;
    }

    @Generated
    public Integer getApnType() {
        return this.apnType;
    }

    @Nullable
    @Generated
    public String getApn() {
        return this.apn;
    }

    @Nullable
    @Generated
    public String getUsername() {
        return this.username;
    }

    @Nullable
    @Generated
    public String getPassword() {
        return this.password;
    }

    @Generated
    public Integer getAuthentication() {
        return this.authentication;
    }

    @Generated
    public Boolean getBuildIn() {
        return this.buildIn;
    }

    @Generated
    public Integer getApplyToSIM() {
        return this.applyToSIM;
    }

    @Generated
    public ApnProfileOpenApiVO setId(String id) {
        this.id = id;
        return this;
    }

    @Generated
    public ApnProfileOpenApiVO setName(String name) {
        this.name = name;
        return this;
    }

    @Generated
    public ApnProfileOpenApiVO setPdpType(Integer pdpType) {
        this.pdpType = pdpType;
        return this;
    }

    @Generated
    public ApnProfileOpenApiVO setApnType(Integer apnType) {
        this.apnType = apnType;
        return this;
    }

    @Generated
    public ApnProfileOpenApiVO setApn(@Nullable String apn) {
        this.apn = apn;
        return this;
    }

    @Generated
    public ApnProfileOpenApiVO setUsername(@Nullable String username) {
        this.username = username;
        return this;
    }

    @Generated
    public ApnProfileOpenApiVO setPassword(@Nullable String password) {
        this.password = password;
        return this;
    }

    @Generated
    public ApnProfileOpenApiVO setAuthentication(Integer authentication) {
        this.authentication = authentication;
        return this;
    }

    @Generated
    public ApnProfileOpenApiVO setBuildIn(Boolean buildIn) {
        this.buildIn = buildIn;
        return this;
    }

    @Generated
    public ApnProfileOpenApiVO setApplyToSIM(Integer applyToSIM) {
        this.applyToSIM = applyToSIM;
        return this;
    }

    @Generated
    public String toString() {
        return "ApnProfileOpenApiVO(id=" + this.getId() + ", name=" + this.getName() + ", pdpType=" + this.getPdpType() + ", apnType=" + this.getApnType() + ", apn=" + this.getApn() + ", username=" + this.getUsername() + ", password=" + this.getPassword() + ", authentication=" + this.getAuthentication() + ", buildIn=" + this.getBuildIn() + ", applyToSIM=" + this.getApplyToSIM() + ")";
    }

    @Generated
    public ApnProfileOpenApiVO(String id, String name, Integer pdpType, Integer apnType, @Nullable String apn, @Nullable String username, @Nullable String password, Integer authentication, Boolean buildIn, Integer applyToSIM) {
        this.id = id;
        this.name = name;
        this.pdpType = pdpType;
        this.apnType = apnType;
        this.apn = apn;
        this.username = username;
        this.password = password;
        this.authentication = authentication;
        this.buildIn = buildIn;
        this.applyToSIM = applyToSIM;
    }

    @Generated
    public ApnProfileOpenApiVO() {
    }
}

