/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.apnprofile;

import com.tplink.smb.omada.common.util.T;
import com.tplink.smb.omada.manager.configuration.api.web.site.profile.dto.ApnProfileVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.annotation.Nullable;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import java.util.Arrays;
import java.util.Locale;
import java.util.Objects;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;

@Schema(name="ApnProfileConfig")
public class ApnProfileConfigOpenApiVO {
    @NotNull(message="Parameter [name] should not be null.")
    @Pattern(regexp="^[^ ]$|^[^ ].{0,62}[^ ]$", message="Parameter [name] should be 1 - 64 characters")
    @Schema(name="name", description="APN profile name, name should contain 1 to 64 characters.")
    private @NotNull(message="Parameter [name] should not be null.") @Pattern(regexp="^[^ ]$|^[^ ].{0,62}[^ ]$", message="Parameter [name] should be 1 - 64 characters") String name;
    @Range(max=2L, message="Parameter [pdpType] should be 0 or 1 or 2")
    @NotNull(message="Parameter [pdpType] should not be null.")
    @Schema(name="pdpType", description="PdpType should be a value as follows: 0: IPv4; 1: IPv6; 2: IPv4 & IPv6.")
    private @Range(max=2L, message="Parameter [pdpType] should be 0 or 1 or 2") @NotNull(message="Parameter [pdpType] should not be null.") Integer pdpType;
    @Range(max=1L, message="Parameter [apnType] should be 0 or 1")
    @NotNull(message="Parameter [apnType] should not be null.")
    @Schema(name="apnType", description="ApnType should be a value as follows: 0: static; 1: dynamic.")
    private @Range(max=1L, message="Parameter [apnType] should be 0 or 1") @NotNull(message="Parameter [apnType] should not be null.") Integer apnType;
    @Nullable
    @Pattern(regexp="^([A-Za-z0-9\\-\\.]){1,62}$", message="Parameter [apn] should be 1 - 62 characters and only allow letters, numbers, hyphens and dots.")
    @Schema(name="apn", description="Access point name, only for apnType static, should contain 1 to 62 characters and should meet the following requirements:\n    1. Only allow letters, numbers, hyphens and dots.\n    2. Should not start with \"rac\", \"lac\", \"sgsn\" or \"rnc\" and end with \".gprs\", ignoring case.\n    3. Should not contain \".-\", \"-.\" and spaces.\n")
    private @Pattern(regexp="^([A-Za-z0-9\\-\\.]){1,62}$", message="Parameter [apn] should be 1 - 62 characters and only allow letters, numbers, hyphens and dots.") String apn;
    @Nullable
    @Pattern(regexp="^[\\x21\\x23-\\x26\\x28-\\x2B\\x2D-\\x7E]{1,64}$", message="Parameter [username] should be 1 - 64 characters, spaces, comma, single quotation marks and double quotation marks are not allowed.")
    @Schema(name="username", description="Username should contain 1 to 64 characters, spaces, comma, single quotation marks and double quotation marks are not allowed.")
    private @Pattern(regexp="^[\\x21\\x23-\\x26\\x28-\\x2B\\x2D-\\x7E]{1,64}$", message="Parameter [username] should be 1 - 64 characters, spaces, comma, single quotation marks and double quotation marks are not allowed.") String username;
    @Nullable
    @Pattern(regexp="^[\\x21\\x23-\\x26\\x28-\\x2B\\x2D-\\x7E]{1,64}$", message="Parameter [password] should be 1 - 64 characters, spaces, comma, single quotation marks and double quotation marks are not allowed.")
    @Schema(name="password", description="Password should contain 1 to 64 characters, spaces, comma, single quotation marks and double quotation marks are not allowed.")
    private @Pattern(regexp="^[\\x21\\x23-\\x26\\x28-\\x2B\\x2D-\\x7E]{1,64}$", message="Parameter [password] should be 1 - 64 characters, spaces, comma, single quotation marks and double quotation marks are not allowed.") String password;
    @Range(min=0L, max=2L, message="Parameter [authentication] should be 0 or 1 or 2")
    @Schema(name="authentication", description="Authentication should be a value as follows: 0: None; 1: PAP; 2: CHAP")
    @NotNull(message="Parameter [authentication] should not be null.")
    private @Range(min=0L, max=2L, message="Parameter [authentication] should be 0 or 1 or 2") @NotNull(message="Parameter [authentication] should not be null.") Integer authentication;
    @Range(min=1L, max=3L, message="Parameter [applyToSIM] should be 1 or 2 or 3")
    @Schema(name="applyToSIM", description="When the device supports Dual-SIM card, parameter [applyToSim] should be a value as follows: 1: apply to SIM1; 2: apply to SIM2; 3: apply to SIM1 and SIM2.")
    private @Range(min=1L, max=3L, message="Parameter [applyToSIM] should be 1 or 2 or 3") Integer applyToSIM;
    private static final String[] INVALID_START_APN_STRS = new String[]{"rac", "lac", "sgsn", "rnc"};
    private static final String INVALID_END_APN_STRS = ".gprs";
    private static final String[] INVALID_CONTAINS_APN_STRS = new String[]{".*.", ".-", "-.", " ", "#", "!", "$", "%", "^", "&", "*", "(", ")", ",", ":", "\"", "'", "|", "\\", "@"};
    private static final int APN_TYPE_STATIC = 0;

    public ApnProfileVO toVO() {
        return ApnProfileVO.builder().name(this.getName()).pdpType(this.getPdpType()).apnType(this.getApnType()).apn(Objects.equals(this.getApnType(), 0) ? this.getApn() : null).username(this.getUsername()).password(this.getPassword()).authentication(this.getAuthentication()).buildIn(Boolean.valueOf(false)).applyToSIM(this.getApplyToSIM()).build();
    }

    public boolean validate() {
        if (Objects.equals(0, this.getApnType()) && T.b((String)this.getApn())) {
            String apnStr = this.getApn().toLowerCase(Locale.ROOT);
            if (apnStr.endsWith(INVALID_END_APN_STRS)) {
                return false;
            }
            if (Arrays.stream(INVALID_START_APN_STRS).anyMatch(apnStr::startsWith)) {
                return false;
            }
            if (Arrays.stream(INVALID_CONTAINS_APN_STRS).anyMatch(apnStr::contains)) {
                return false;
            }
        }
        return true;
    }

    @Generated
    public static ApnProfileConfigOpenApiVOBuilder builder() {
        return new ApnProfileConfigOpenApiVOBuilder();
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Integer getPdpType() {
        return this.pdpType;
    }

    @Generated
    public Integer getApnType() {
        return this.apnType;
    }

    @Nullable
    @Generated
    public String getApn() {
        return this.apn;
    }

    @Nullable
    @Generated
    public String getUsername() {
        return this.username;
    }

    @Nullable
    @Generated
    public String getPassword() {
        return this.password;
    }

    @Generated
    public Integer getAuthentication() {
        return this.authentication;
    }

    @Generated
    public Integer getApplyToSIM() {
        return this.applyToSIM;
    }

    @Generated
    public ApnProfileConfigOpenApiVO setName(String name) {
        this.name = name;
        return this;
    }

    @Generated
    public ApnProfileConfigOpenApiVO setPdpType(Integer pdpType) {
        this.pdpType = pdpType;
        return this;
    }

    @Generated
    public ApnProfileConfigOpenApiVO setApnType(Integer apnType) {
        this.apnType = apnType;
        return this;
    }

    @Generated
    public ApnProfileConfigOpenApiVO setApn(@Nullable String apn) {
        this.apn = apn;
        return this;
    }

    @Generated
    public ApnProfileConfigOpenApiVO setUsername(@Nullable String username) {
        this.username = username;
        return this;
    }

    @Generated
    public ApnProfileConfigOpenApiVO setPassword(@Nullable String password) {
        this.password = password;
        return this;
    }

    @Generated
    public ApnProfileConfigOpenApiVO setAuthentication(Integer authentication) {
        this.authentication = authentication;
        return this;
    }

    @Generated
    public ApnProfileConfigOpenApiVO setApplyToSIM(Integer applyToSIM) {
        this.applyToSIM = applyToSIM;
        return this;
    }

    @Generated
    public String toString() {
        return "ApnProfileConfigOpenApiVO(name=" + this.getName() + ", pdpType=" + this.getPdpType() + ", apnType=" + this.getApnType() + ", apn=" + this.getApn() + ", username=" + this.getUsername() + ", password=" + this.getPassword() + ", authentication=" + this.getAuthentication() + ", applyToSIM=" + this.getApplyToSIM() + ")";
    }

    @Generated
    public ApnProfileConfigOpenApiVO(String name, Integer pdpType, Integer apnType, @Nullable String apn, @Nullable String username, @Nullable String password, Integer authentication, Integer applyToSIM) {
        this.name = name;
        this.pdpType = pdpType;
        this.apnType = apnType;
        this.apn = apn;
        this.username = username;
        this.password = password;
        this.authentication = authentication;
        this.applyToSIM = applyToSIM;
    }

    @Generated
    public ApnProfileConfigOpenApiVO() {
    }

    @Generated
    public static class ApnProfileConfigOpenApiVOBuilder {
        @Generated
        private String name;
        @Generated
        private Integer pdpType;
        @Generated
        private Integer apnType;
        @Generated
        private String apn;
        @Generated
        private String username;
        @Generated
        private String password;
        @Generated
        private Integer authentication;
        @Generated
        private Integer applyToSIM;

        @Generated
        ApnProfileConfigOpenApiVOBuilder() {
        }

        @Generated
        public ApnProfileConfigOpenApiVOBuilder name(String name) {
            this.name = name;
            return this;
        }

        @Generated
        public ApnProfileConfigOpenApiVOBuilder pdpType(Integer pdpType) {
            this.pdpType = pdpType;
            return this;
        }

        @Generated
        public ApnProfileConfigOpenApiVOBuilder apnType(Integer apnType) {
            this.apnType = apnType;
            return this;
        }

        @Generated
        public ApnProfileConfigOpenApiVOBuilder apn(@Nullable String apn) {
            this.apn = apn;
            return this;
        }

        @Generated
        public ApnProfileConfigOpenApiVOBuilder username(@Nullable String username) {
            this.username = username;
            return this;
        }

        @Generated
        public ApnProfileConfigOpenApiVOBuilder password(@Nullable String password) {
            this.password = password;
            return this;
        }

        @Generated
        public ApnProfileConfigOpenApiVOBuilder authentication(Integer authentication) {
            this.authentication = authentication;
            return this;
        }

        @Generated
        public ApnProfileConfigOpenApiVOBuilder applyToSIM(Integer applyToSIM) {
            this.applyToSIM = applyToSIM;
            return this;
        }

        @Generated
        public ApnProfileConfigOpenApiVO build() {
            return new ApnProfileConfigOpenApiVO(this.name, this.pdpType, this.apnType, this.apn, this.username, this.password, this.authentication, this.applyToSIM);
        }

        @Generated
        public String toString() {
            return "ApnProfileConfigOpenApiVO.ApnProfileConfigOpenApiVOBuilder(name=" + this.name + ", pdpType=" + this.pdpType + ", apnType=" + this.apnType + ", apn=" + this.apn + ", username=" + this.username + ", password=" + this.password + ", authentication=" + this.authentication + ", applyToSIM=" + this.applyToSIM + ")";
        }
    }
}

