/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting;

import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.DhcpGuardOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.Dhcpv6GuardOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.wired.lannetwork.DhcpGuardVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.wired.lannetwork.Dhcpv6GuardVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.wired.lannetwork.VlanLanNetworkVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import java.util.Objects;
import lombok.Generated;

@Schema(name="Create VLANs")
public class VlanOpenApiVO {
    @NotNull
    @Pattern(regexp="^[^ \\+\\-\\@\\=]$|^[^ \\+\\-\\@\\=].{0,126}[^ ]$", message="Parameter [name] should be between 1 and 128 characters.")
    @Schema(name="name", description="LAN network name should contain 1 to 128 characters.")
    private @NotNull @Pattern(regexp="^[^ \\+\\-\\@\\=]$|^[^ \\+\\-\\@\\=].{0,126}[^ ]$", message="Parameter [name] should be between 1 and 128 characters.") String name;
    @NotNull(message="Parameter [vlans] should not be null.")
    @Pattern(regexp="^[\\d|\\d-\\d]+(,[\\d|\\d-\\d]+)*$", message="Parameter [vlans] should be like '2-100,200'.")
    @Schema(name="vlans", description="Support batch VLAN creation. VLAN format: 200, 1-100.")
    private @NotNull(message="Parameter [vlans] should not be null.") @Pattern(regexp="^[\\d|\\d-\\d]+(,[\\d|\\d-\\d]+)*$", message="Parameter [vlans] should be like '2-100,200'.") String vlans;
    @NotNull(message="Parameter [igmpSnoopEnable] should not be null.")
    @Schema(name="igmpSnoopEnable", description="Enable IGMP snooping")
    private @NotNull(message="Parameter [igmpSnoopEnable] should not be null.") Boolean igmpSnoopEnable;
    @Schema(name="dhcpL2RelayEnable", description="The switch of DHCP L2 relay")
    private Boolean dhcpL2RelayEnable;
    @Valid
    @Schema(name="dhcpGuard", description="Legal DHCP Server")
    private DhcpGuardOpenApiVO dhcpGuard;
    @Schema(name="mldSnoopEnable", description="Enable MLD snooping")
    private Boolean mldSnoopEnable;
    @Schema(name="dhcpv6Guard", description="Legal DHCPv6 Server")
    private Dhcpv6GuardOpenApiVO dhcpv6Guard;
    @Schema(name="application", description="Effective device type should be a value as follows: 0: Gateway and Switch; 1: Switch")
    private Integer application;

    public static VlanLanNetworkVO toVlanLanNetworkVO(VlanOpenApiVO vlanOpenApiVO) {
        if (Objects.isNull(vlanOpenApiVO)) {
            return null;
        }
        VlanLanNetworkVO vlanLanNetworkVO = new VlanLanNetworkVO();
        vlanLanNetworkVO.setName(vlanOpenApiVO.getName());
        vlanLanNetworkVO.setVlans(vlanOpenApiVO.getVlans());
        vlanLanNetworkVO.setIgmpSnoopEnable(Boolean.valueOf(Boolean.TRUE.equals(vlanOpenApiVO.getIgmpSnoopEnable())));
        vlanLanNetworkVO.setDhcpL2RelayEnable(Boolean.valueOf(Boolean.TRUE.equals(vlanOpenApiVO.getDhcpL2RelayEnable())));
        vlanLanNetworkVO.setDhcpGuard(VlanOpenApiVO.toDhcpGuard(vlanOpenApiVO.getDhcpGuard()));
        vlanLanNetworkVO.setMldSnoopEnable(Boolean.valueOf(Boolean.TRUE.equals(vlanOpenApiVO.getMldSnoopEnable())));
        vlanLanNetworkVO.setDhcpv6Guard(VlanOpenApiVO.toDhcpv6Guard(vlanOpenApiVO.getDhcpv6Guard()));
        vlanLanNetworkVO.setApplication(vlanOpenApiVO.getApplication());
        return vlanLanNetworkVO;
    }

    private static Dhcpv6GuardVO toDhcpv6Guard(Dhcpv6GuardOpenApiVO dhcpv6Guard) {
        if (Objects.isNull(dhcpv6Guard)) {
            Dhcpv6GuardVO dhcpv6GuardVO = new Dhcpv6GuardVO();
            dhcpv6GuardVO.setEnable(Boolean.valueOf(false));
            return dhcpv6GuardVO;
        }
        Dhcpv6GuardVO dhcpv6GuardVO = new Dhcpv6GuardVO();
        dhcpv6GuardVO.setEnable(Boolean.valueOf(Boolean.TRUE.equals(dhcpv6Guard.getEnable())));
        dhcpv6GuardVO.setDhcpv6Svr1(dhcpv6Guard.getDhcpv6Svr1());
        dhcpv6GuardVO.setDhcpv6Svr2(dhcpv6Guard.getDhcpv6Svr2());
        return dhcpv6GuardVO;
    }

    private static DhcpGuardVO toDhcpGuard(DhcpGuardOpenApiVO dhcpGuard) {
        if (Objects.isNull(dhcpGuard)) {
            DhcpGuardVO dhcpGuardVO = new DhcpGuardVO();
            dhcpGuardVO.setEnable(Boolean.valueOf(false));
            return dhcpGuardVO;
        }
        DhcpGuardVO dhcpGuardVO = new DhcpGuardVO();
        dhcpGuardVO.setEnable(Boolean.valueOf(Boolean.TRUE.equals(dhcpGuard.getEnable())));
        dhcpGuardVO.setDhcpSvr1(dhcpGuard.getDhcpSvr1());
        dhcpGuardVO.setDhcpSvr2(dhcpGuard.getDhcpSvr2());
        return dhcpGuardVO;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getVlans() {
        return this.vlans;
    }

    @Generated
    public Boolean getIgmpSnoopEnable() {
        return this.igmpSnoopEnable;
    }

    @Generated
    public Boolean getDhcpL2RelayEnable() {
        return this.dhcpL2RelayEnable;
    }

    @Generated
    public DhcpGuardOpenApiVO getDhcpGuard() {
        return this.dhcpGuard;
    }

    @Generated
    public Boolean getMldSnoopEnable() {
        return this.mldSnoopEnable;
    }

    @Generated
    public Dhcpv6GuardOpenApiVO getDhcpv6Guard() {
        return this.dhcpv6Guard;
    }

    @Generated
    public Integer getApplication() {
        return this.application;
    }

    @Generated
    public VlanOpenApiVO setName(String name) {
        this.name = name;
        return this;
    }

    @Generated
    public VlanOpenApiVO setVlans(String vlans) {
        this.vlans = vlans;
        return this;
    }

    @Generated
    public VlanOpenApiVO setIgmpSnoopEnable(Boolean igmpSnoopEnable) {
        this.igmpSnoopEnable = igmpSnoopEnable;
        return this;
    }

    @Generated
    public VlanOpenApiVO setDhcpL2RelayEnable(Boolean dhcpL2RelayEnable) {
        this.dhcpL2RelayEnable = dhcpL2RelayEnable;
        return this;
    }

    @Generated
    public VlanOpenApiVO setDhcpGuard(DhcpGuardOpenApiVO dhcpGuard) {
        this.dhcpGuard = dhcpGuard;
        return this;
    }

    @Generated
    public VlanOpenApiVO setMldSnoopEnable(Boolean mldSnoopEnable) {
        this.mldSnoopEnable = mldSnoopEnable;
        return this;
    }

    @Generated
    public VlanOpenApiVO setDhcpv6Guard(Dhcpv6GuardOpenApiVO dhcpv6Guard) {
        this.dhcpv6Guard = dhcpv6Guard;
        return this;
    }

    @Generated
    public VlanOpenApiVO setApplication(Integer application) {
        this.application = application;
        return this;
    }

    @Generated
    public String toString() {
        return "VlanOpenApiVO(name=" + this.getName() + ", vlans=" + this.getVlans() + ", igmpSnoopEnable=" + this.getIgmpSnoopEnable() + ", dhcpL2RelayEnable=" + this.getDhcpL2RelayEnable() + ", dhcpGuard=" + this.getDhcpGuard() + ", mldSnoopEnable=" + this.getMldSnoopEnable() + ", dhcpv6Guard=" + this.getDhcpv6Guard() + ", application=" + this.getApplication() + ")";
    }
}

