/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting;

import com.tplink.smb.omada.common.validator.anons.NumberSet;
import com.tplink.smb.omada.manager.configuration.api.web.site.wired.lanprofile.StormCtrlVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;

@Schema(name="Storm Ctrl entity")
public class StormCtrlOpenApiVO {
    @NumberSet(value={0, 1}, message="StormCtrl parameter [rateMode] should be 0 or 1")
    private Integer rateMode;
    @NotNull(message="StormCtrl parameter [unknownUnicastEnable] should not be null")
    @Schema(name="unknownUnicastEnable", description="Unknown-Unicast enable status")
    private @NotNull(message="StormCtrl parameter [unknownUnicastEnable] should not be null") Boolean unknownUnicastEnable;
    @Schema(name="unknownUnicast", description="Unknown-Unicast")
    private Integer unknownUnicast;
    @NotNull(message="StormCtrl parameter [multicastEnable] should not be null")
    @Schema(name="multicastEnable", description="Multicast enable status")
    private @NotNull(message="StormCtrl parameter [multicastEnable] should not be null") Boolean multicastEnable;
    @Schema(name="multicast", description="Multicast")
    private Integer multicast;
    @NotNull(message="StormCtrl parameter [broadcastEnable] should not be null")
    @Schema(name="broadcastEnable", description="Broadcast enable status")
    private @NotNull(message="StormCtrl parameter [broadcastEnable] should not be null") Boolean broadcastEnable;
    @Schema(name="broadcast", description="Broadcast")
    private Integer broadcast;
    @NotNull(message="StormCtrl parameter [action] should not be null")
    @NumberSet(value={0, 1}, message="StormCtrl parameter [action] should be 0 or 1")
    @Schema(name="action", description="Action should be a value as follows: 0: drop(default), 1: shutdown")
    private @NotNull(message="StormCtrl parameter [action] should not be null") Integer action;
    @Range(min=1L, max=3600L, message="StormCtrl parameter [recoverTime] should between 1 and 3600s")
    @Schema(name="recoverTime", description="Recover Time should be within the range of 1-3600, default 3600")
    private @Range(min=1L, max=3600L, message="StormCtrl parameter [recoverTime] should between 1 and 3600s") Integer recoverTime;

    public static StormCtrlOpenApiVO fromStormCtrlVO(StormCtrlVO stormCtrl) {
        if (stormCtrl == null) {
            return null;
        }
        StormCtrlOpenApiVO StormCtrlOpenApiVO2 = new StormCtrlOpenApiVO();
        StormCtrlOpenApiVO2.setRateMode(stormCtrl.getRateMode());
        StormCtrlOpenApiVO2.setUnknownUnicastEnable(stormCtrl.getUnknownUnicastEnable());
        StormCtrlOpenApiVO2.setUnknownUnicast(stormCtrl.getUnknownUnicast());
        StormCtrlOpenApiVO2.setMulticastEnable(stormCtrl.getMulticastEnable());
        StormCtrlOpenApiVO2.setMulticast(stormCtrl.getMulticast());
        StormCtrlOpenApiVO2.setBroadcastEnable(stormCtrl.getBroadcastEnable());
        StormCtrlOpenApiVO2.setBroadcast(stormCtrl.getBroadcast());
        StormCtrlOpenApiVO2.setAction(stormCtrl.getAction());
        StormCtrlOpenApiVO2.setRecoverTime(stormCtrl.getRecoverTime());
        return StormCtrlOpenApiVO2;
    }

    public static StormCtrlVO toStormCtrlVO(StormCtrlOpenApiVO stormCtrl) {
        if (stormCtrl == null) {
            return null;
        }
        StormCtrlVO stormCtrlVO = new StormCtrlVO();
        stormCtrlVO.setRateMode(stormCtrl.rateMode);
        stormCtrlVO.setUnknownUnicastEnable(stormCtrl.unknownUnicastEnable);
        stormCtrlVO.setUnknownUnicast(stormCtrl.unknownUnicast);
        stormCtrlVO.setMulticastEnable(stormCtrl.multicastEnable);
        stormCtrlVO.setMulticast(stormCtrl.multicast);
        stormCtrlVO.setBroadcastEnable(stormCtrl.broadcastEnable);
        stormCtrlVO.setBroadcast(stormCtrl.broadcast);
        stormCtrlVO.setAction(stormCtrl.action);
        stormCtrlVO.setRecoverTime(stormCtrl.recoverTime);
        return stormCtrlVO;
    }

    @Generated
    public Integer getRateMode() {
        return this.rateMode;
    }

    @Generated
    public Boolean getUnknownUnicastEnable() {
        return this.unknownUnicastEnable;
    }

    @Generated
    public Integer getUnknownUnicast() {
        return this.unknownUnicast;
    }

    @Generated
    public Boolean getMulticastEnable() {
        return this.multicastEnable;
    }

    @Generated
    public Integer getMulticast() {
        return this.multicast;
    }

    @Generated
    public Boolean getBroadcastEnable() {
        return this.broadcastEnable;
    }

    @Generated
    public Integer getBroadcast() {
        return this.broadcast;
    }

    @Generated
    public Integer getAction() {
        return this.action;
    }

    @Generated
    public Integer getRecoverTime() {
        return this.recoverTime;
    }

    @Generated
    public void setRateMode(Integer rateMode) {
        this.rateMode = rateMode;
    }

    @Generated
    public void setUnknownUnicastEnable(Boolean unknownUnicastEnable) {
        this.unknownUnicastEnable = unknownUnicastEnable;
    }

    @Generated
    public void setUnknownUnicast(Integer unknownUnicast) {
        this.unknownUnicast = unknownUnicast;
    }

    @Generated
    public void setMulticastEnable(Boolean multicastEnable) {
        this.multicastEnable = multicastEnable;
    }

    @Generated
    public void setMulticast(Integer multicast) {
        this.multicast = multicast;
    }

    @Generated
    public void setBroadcastEnable(Boolean broadcastEnable) {
        this.broadcastEnable = broadcastEnable;
    }

    @Generated
    public void setBroadcast(Integer broadcast) {
        this.broadcast = broadcast;
    }

    @Generated
    public void setAction(Integer action) {
        this.action = action;
    }

    @Generated
    public void setRecoverTime(Integer recoverTime) {
        this.recoverTime = recoverTime;
    }

    @Generated
    public String toString() {
        return "StormCtrlOpenApiVO(rateMode=" + this.getRateMode() + ", unknownUnicastEnable=" + this.getUnknownUnicastEnable() + ", unknownUnicast=" + this.getUnknownUnicast() + ", multicastEnable=" + this.getMulticastEnable() + ", multicast=" + this.getMulticast() + ", broadcastEnable=" + this.getBroadcastEnable() + ", broadcast=" + this.getBroadcast() + ", action=" + this.getAction() + ", recoverTime=" + this.getRecoverTime() + ")";
    }

    @Generated
    public StormCtrlOpenApiVO(Integer rateMode, Boolean unknownUnicastEnable, Integer unknownUnicast, Boolean multicastEnable, Integer multicast, Boolean broadcastEnable, Integer broadcast, Integer action, Integer recoverTime) {
        this.rateMode = rateMode;
        this.unknownUnicastEnable = unknownUnicastEnable;
        this.unknownUnicast = unknownUnicast;
        this.multicastEnable = multicastEnable;
        this.multicast = multicast;
        this.broadcastEnable = broadcastEnable;
        this.broadcast = broadcast;
        this.action = action;
        this.recoverTime = recoverTime;
    }

    @Generated
    public StormCtrlOpenApiVO() {
    }
}

