/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting;

import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.DstOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.NtpServerOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.sitesetting.dto.DstDTO;
import com.tplink.smb.omada.manager.configuration.api.web.sitetemplate.vo.SiteTemplateVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Size;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.util.CollectionUtils;

public class SiteTemplateOpenApiVO {
    @Schema(name="timeZone", description="For the values of the timezone of the site, refer to section 5.1 of the Open API Access Guide.")
    private String timeZone;
    @Schema(name="dst", description="Daylight Saving Time.")
    private DstOpenApiVO dst;
    @Schema(name="ntpEnable", description="NTP server status of the site.")
    private Boolean ntpEnable;
    @Valid
    @Size(max=5, message="Up to 5 entries are allowed for the NTP server address list.")
    @Schema(name="ntpServers", description="NTP server address; Up to 5 entries are allowed for the NTP server address list.")
    private @Valid @Size(max=5, message="Up to 5 entries are allowed for the NTP server address list.") List<NtpServerOpenApiVO> ntpServers;

    public static SiteTemplateVO toWebVO(SiteTemplateOpenApiVO openApiVO) {
        if (openApiVO == null) {
            return null;
        }
        SiteTemplateVO vo = new SiteTemplateVO();
        vo.setTimeZone(openApiVO.getTimeZone());
        vo.setDst(SiteTemplateOpenApiVO.toDstDTO(openApiVO.getDst()));
        vo.setNtpEnable(openApiVO.getNtpEnable());
        vo.setNtpServers(CollectionUtils.isEmpty(openApiVO.getNtpServers()) ? new ArrayList() : openApiVO.getNtpServers().stream().map(NtpServerOpenApiVO::toWebVO).collect(Collectors.toList()));
        return vo;
    }

    public static DstDTO toDstDTO(DstOpenApiVO openApiVO) {
        if (openApiVO == null) {
            return null;
        }
        return DstDTO.builder().enable(openApiVO.getEnable()).mode(openApiVO.getMode()).offset(openApiVO.getOffset()).start(openApiVO.getStart()).end(openApiVO.getEnd()).build();
    }

    @Generated
    public String getTimeZone() {
        return this.timeZone;
    }

    @Generated
    public DstOpenApiVO getDst() {
        return this.dst;
    }

    @Generated
    public Boolean getNtpEnable() {
        return this.ntpEnable;
    }

    @Generated
    public List<NtpServerOpenApiVO> getNtpServers() {
        return this.ntpServers;
    }

    @Generated
    public SiteTemplateOpenApiVO setTimeZone(String timeZone) {
        this.timeZone = timeZone;
        return this;
    }

    @Generated
    public SiteTemplateOpenApiVO setDst(DstOpenApiVO dst) {
        this.dst = dst;
        return this;
    }

    @Generated
    public SiteTemplateOpenApiVO setNtpEnable(Boolean ntpEnable) {
        this.ntpEnable = ntpEnable;
        return this;
    }

    @Generated
    public SiteTemplateOpenApiVO setNtpServers(List<NtpServerOpenApiVO> ntpServers) {
        this.ntpServers = ntpServers;
        return this;
    }

    @Generated
    public String toString() {
        return "SiteTemplateOpenApiVO(timeZone=" + this.getTimeZone() + ", dst=" + this.getDst() + ", ntpEnable=" + this.getNtpEnable() + ", ntpServers=" + this.getNtpServers() + ")";
    }
}

