/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting;

import com.tplink.nbu.common.pii.annotation.PII;
import com.tplink.nbu.common.pii.constant.PIIMaskStrategy;
import com.tplink.smb.omada.manager.configuration.api.web.site.sitesetting.dto.RemoteLogSettingVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;

public class RemoteLogSettingOpenApiVO {
    @Schema(name="enable", description="Whether to enable the feature")
    @NotNull(message="Remote log parameter [enable] should not be null.")
    private @NotNull(message="Remote log parameter [enable] should not be null.") Boolean enable;
    @Schema(name="host", description="The IP address of the remote log server")
    @Pattern(regexp="((\\d{1,2}|1\\d\\d|2[0-4]\\d|25[0-5])(\\.(\\d{1,2}|1\\d\\d|2[0-4]\\d|25[0-5])){3}|([a-zA-Z0-9]([a-zA-Z0-9\\-]{0,61}[a-zA-Z0-9])?\\.)+[a-zA-Z]{2,6})", message="Remote log parameter [host] should be IP address.")
    @PII(strategy=PIIMaskStrategy.HASH)
    private @Pattern(regexp="((\\d{1,2}|1\\d\\d|2[0-4]\\d|25[0-5])(\\.(\\d{1,2}|1\\d\\d|2[0-4]\\d|25[0-5])){3}|([a-zA-Z0-9]([a-zA-Z0-9\\-]{0,61}[a-zA-Z0-9])?\\.)+[a-zA-Z]{2,6})", message="Remote log parameter [host] should be IP address.") String host;
    @Schema(name="port", description="Port of the remote log server, port should be within the range of 1-65535")
    @Range(min=1L, max=65535L, message="Remote log parameter [port] should between 1 and 65535.")
    @PII(strategy=PIIMaskStrategy.HASH)
    private @Range(min=1L, max=65535L, message="Remote log parameter [port] should between 1 and 65535.") Integer port;
    @Schema(name="moreClientLog", description="Whether it contains client log")
    private Boolean moreClientLog;

    public static RemoteLogSettingVO toWebVO(RemoteLogSettingOpenApiVO openApiVO) {
        if (openApiVO == null) {
            return null;
        }
        RemoteLogSettingVO webVO = new RemoteLogSettingVO();
        webVO.setEnable(openApiVO.getEnable());
        webVO.setHost(openApiVO.getHost());
        webVO.setPort(openApiVO.getPort());
        webVO.setMoreClientLog(openApiVO.getMoreClientLog());
        return webVO;
    }

    public static RemoteLogSettingOpenApiVO fromWebVO(RemoteLogSettingVO webVO) {
        if (webVO == null) {
            return null;
        }
        RemoteLogSettingOpenApiVO openApiVO = new RemoteLogSettingOpenApiVO();
        openApiVO.setEnable(webVO.getEnable());
        openApiVO.setHost(webVO.getHost());
        openApiVO.setPort(webVO.getPort());
        openApiVO.setMoreClientLog(webVO.getMoreClientLog());
        return openApiVO;
    }

    @Generated
    public Boolean getEnable() {
        return this.enable;
    }

    @Generated
    public String getHost() {
        return this.host;
    }

    @Generated
    public Integer getPort() {
        return this.port;
    }

    @Generated
    public Boolean getMoreClientLog() {
        return this.moreClientLog;
    }

    @Generated
    public void setEnable(Boolean enable) {
        this.enable = enable;
    }

    @Generated
    public void setHost(String host) {
        this.host = host;
    }

    @Generated
    public void setPort(Integer port) {
        this.port = port;
    }

    @Generated
    public void setMoreClientLog(Boolean moreClientLog) {
        this.moreClientLog = moreClientLog;
    }

    @Generated
    public String toString() {
        return "RemoteLogSettingOpenApiVO(enable=" + this.getEnable() + ", host=" + this.getHost() + ", port=" + this.getPort() + ", moreClientLog=" + this.getMoreClientLog() + ")";
    }
}

