/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting;

import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.PSKV2OpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.profile.dto.ppsk.PPSKExpirationVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.profile.dto.ppsk.PPSKRateLimitSettingVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.annotation.Nullable;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import java.util.List;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;

@Schema(name="PpskProfile V2", description="PPSK Profile Setting.")
public class PpskProfileV2OpenApiVO {
    @Schema(name="profileName", description="PPSK Profile Name, should contain 1 to 64 characters.")
    @NotNull(message="PPSK Profile name should not be null.")
    @Pattern(regexp="^[^ \\+\\-\\@\\=]$|^[^ \\+\\-\\@\\=].{0,62}[^ ]$", message="PPSK profile name should be 1~64.")
    private @NotNull(message="PPSK Profile name should not be null.") @Pattern(regexp="^[^ \\+\\-\\@\\=]$|^[^ \\+\\-\\@\\=].{0,62}[^ ]$", message="PPSK profile name should be 1~64.") String profileName;
    @Schema(name="autoCreatePsks", description="Whether to enable auto create psks")
    @NotNull(message="Parameter [autoCreatePsks] should not be null.")
    private @NotNull(message="Parameter [autoCreatePsks] should not be null.") Boolean autoCreatePsks;
    @Schema(name="ppsk", description="This field is required when Parameter [autoCreatePsks] is false; PPSK List In the PPSK Profile")
    @Valid
    private List<PSKV2OpenApiVO> ppsk;
    @Schema(name="number", description="This field is required when Parameter [autoCreatePsks] is true; Generate Number, should be within the range of 1-1024.")
    @Range(min=1L, max=1024L, message="Generate Number should be from 1 to 1024.")
    private @Range(min=1L, max=1024L, message="Generate Number should be from 1 to 1024.") Integer number;
    @Schema(name="prefix", description="This field is required when Parameter [autoCreatePsks] is true; PSK Name Prefix, should contain 1 to 60 visible ASCII characters.")
    @Pattern(regexp="^[a-zA-z0-9'!\"#$%&()*,./:;?^_`\\[\\]{|}~<>\\ ][\\041-\\0176]{0,59}$", message="PSK should be 1~60 visible ASCII characters.")
    private @Pattern(regexp="^[a-zA-z0-9'!\"#$%&()*,./:;?^_`\\[\\]{|}~<>\\ ][\\041-\\0176]{0,59}$", message="PSK should be 1~60 visible ASCII characters.") String prefix;
    @Schema(name="length", description="This field is required when Parameter [autoCreatePsks] is true; PSK Password Length, should be within the range of 8-63.")
    @Range(min=8L, max=63L, message="PSK Length should be from 8 to 63.")
    private @Range(min=8L, max=63L, message="PSK Length should be from 8 to 63.") Integer length;
    @Schema(name="vlan", description="This field is required when Parameter [autoCreatePsks] is true; PSK Bound Vlan, should be within the range of 1-4094.")
    @Range(min=1L, max=4094L, message="Vlan should be from 1 to 4094.")
    @Nullable
    private @Range(min=1L, max=4094L, message="Vlan should be from 1 to 4094.") Integer vlan;
    @Schema(name="vlanPool", description="This field is required when Parameter [autoCreatePsks] is true; PSK Bound Vlan range, should be like: 10-1000.")
    @Nullable
    private String vlanPool;
    @Max(value=4093L)
    @Min(value=0L)
    @Nullable
    @Schema(name="vlanInterval", description="This field is required when Parameter [autoCreatePsks] is true; The interval of vlan when auto creating psk")
    private @Max(value=4093L) @Min(value=0L) Integer vlanInterval;
    @Schema(name="rateLimit", description="PPSK Profile Rate Limit config.")
    @Nullable
    @Valid
    private PPSKRateLimitSettingVO rateLimit;
    @Schema(name="expiration", description="PPSK Profile expiration time config.")
    @Nullable
    @Valid
    private PPSKExpirationVO expiration;

    @Generated
    public String getProfileName() {
        return this.profileName;
    }

    @Generated
    public Boolean getAutoCreatePsks() {
        return this.autoCreatePsks;
    }

    @Generated
    public List<PSKV2OpenApiVO> getPpsk() {
        return this.ppsk;
    }

    @Generated
    public Integer getNumber() {
        return this.number;
    }

    @Generated
    public String getPrefix() {
        return this.prefix;
    }

    @Generated
    public Integer getLength() {
        return this.length;
    }

    @Nullable
    @Generated
    public Integer getVlan() {
        return this.vlan;
    }

    @Nullable
    @Generated
    public String getVlanPool() {
        return this.vlanPool;
    }

    @Nullable
    @Generated
    public Integer getVlanInterval() {
        return this.vlanInterval;
    }

    @Nullable
    @Generated
    public PPSKRateLimitSettingVO getRateLimit() {
        return this.rateLimit;
    }

    @Nullable
    @Generated
    public PPSKExpirationVO getExpiration() {
        return this.expiration;
    }

    @Generated
    public PpskProfileV2OpenApiVO setProfileName(String profileName) {
        this.profileName = profileName;
        return this;
    }

    @Generated
    public PpskProfileV2OpenApiVO setAutoCreatePsks(Boolean autoCreatePsks) {
        this.autoCreatePsks = autoCreatePsks;
        return this;
    }

    @Generated
    public PpskProfileV2OpenApiVO setPpsk(List<PSKV2OpenApiVO> ppsk) {
        this.ppsk = ppsk;
        return this;
    }

    @Generated
    public PpskProfileV2OpenApiVO setNumber(Integer number) {
        this.number = number;
        return this;
    }

    @Generated
    public PpskProfileV2OpenApiVO setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    @Generated
    public PpskProfileV2OpenApiVO setLength(Integer length) {
        this.length = length;
        return this;
    }

    @Generated
    public PpskProfileV2OpenApiVO setVlan(@Nullable Integer vlan) {
        this.vlan = vlan;
        return this;
    }

    @Generated
    public PpskProfileV2OpenApiVO setVlanPool(@Nullable String vlanPool) {
        this.vlanPool = vlanPool;
        return this;
    }

    @Generated
    public PpskProfileV2OpenApiVO setVlanInterval(@Nullable Integer vlanInterval) {
        this.vlanInterval = vlanInterval;
        return this;
    }

    @Generated
    public PpskProfileV2OpenApiVO setRateLimit(@Nullable PPSKRateLimitSettingVO rateLimit) {
        this.rateLimit = rateLimit;
        return this;
    }

    @Generated
    public PpskProfileV2OpenApiVO setExpiration(@Nullable PPSKExpirationVO expiration) {
        this.expiration = expiration;
        return this;
    }

    @Generated
    public String toString() {
        return "PpskProfileV2OpenApiVO(profileName=" + this.getProfileName() + ", autoCreatePsks=" + this.getAutoCreatePsks() + ", ppsk=" + this.getPpsk() + ", number=" + this.getNumber() + ", prefix=" + this.getPrefix() + ", length=" + this.getLength() + ", vlan=" + this.getVlan() + ", vlanPool=" + this.getVlanPool() + ", vlanInterval=" + this.getVlanInterval() + ", rateLimit=" + this.getRateLimit() + ", expiration=" + this.getExpiration() + ")";
    }

    @Generated
    public PpskProfileV2OpenApiVO() {
    }

    @Generated
    public PpskProfileV2OpenApiVO(String profileName, Boolean autoCreatePsks, List<PSKV2OpenApiVO> ppsk, Integer number, String prefix, Integer length, @Nullable Integer vlan, @Nullable String vlanPool, @Nullable Integer vlanInterval, @Nullable PPSKRateLimitSettingVO rateLimit, @Nullable PPSKExpirationVO expiration) {
        this.profileName = profileName;
        this.autoCreatePsks = autoCreatePsks;
        this.ppsk = ppsk;
        this.number = number;
        this.prefix = prefix;
        this.length = length;
        this.vlan = vlan;
        this.vlanPool = vlanPool;
        this.vlanInterval = vlanInterval;
        this.rateLimit = rateLimit;
        this.expiration = expiration;
    }
}

