/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting;

import com.tplink.smb.omada.manager.configuration.api.web.site.servicesetting.dto.PortScheduleVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;

public class PortOrPoeScheduleQueryOpenApiVO {
    @Schema(name="id", description="Port Schedule individual ID.")
    private String id;
    @Schema(name="siteId", description="Site ID")
    private String siteId;
    @NotNull
    @Pattern(regexp="^[^ ]$|^[^ ].{0,126}[^ ]$", message="Parameter [name] should be 1 ~ 128 characters.")
    @Schema(name="name", description="Port Schedule Name should contain 1 to 128 characters.")
    private @NotNull @Pattern(regexp="^[^ ]$|^[^ ].{0,126}[^ ]$", message="Parameter [name] should be 1 ~ 128 characters.") String name;
    @NotNull
    @Range(min=0L, max=1L)
    @Schema(name="scheduleType", description="Port Schedule Type should be 0 or 1.")
    private @NotNull @Range(min=0L, max=1L) Integer scheduleType;
    @NotNull
    @Schema(name="status", description="Port Schedule Status.")
    private Boolean status;
    @NotNull
    @Schema(name="turnOnTime", description="Time Range ID, cannot be empty.")
    private String turnOnTime;
    @NotNull
    @Schema(name="portsMap", description="Key:Mac(\"String\"), Value:Set of Ports(\"Integer\")")
    private Map<String, Set<Integer>> portsMap;
    @Schema(name="nextExecute", description="Show PoE Schedule next execution timestamp.")
    private Long nextExecute;
    @Schema(name="notInDst", description="When notInDst is true, not displayed in DST.")
    private Boolean notInDst;

    public static PortScheduleVO toWebPortScheduleVO(PortOrPoeScheduleQueryOpenApiVO portScheduleOpenApiVO) {
        if (Objects.isNull(portScheduleOpenApiVO)) {
            return null;
        }
        PortScheduleVO webVO = new PortScheduleVO();
        webVO.setId(portScheduleOpenApiVO.getId());
        webVO.setSiteId(portScheduleOpenApiVO.getSiteId());
        webVO.setName(portScheduleOpenApiVO.getName());
        webVO.setStatus(portScheduleOpenApiVO.getStatus());
        webVO.setTurnOnTime(portScheduleOpenApiVO.getTurnOnTime());
        webVO.setNextExecute(portScheduleOpenApiVO.getNextExecute());
        webVO.setPortsMap(portScheduleOpenApiVO.getPortsMap());
        webVO.setScheduleType(portScheduleOpenApiVO.getScheduleType());
        webVO.setNotInDst(portScheduleOpenApiVO.getNotInDst());
        return webVO;
    }

    public static PortOrPoeScheduleQueryOpenApiVO fromWebVO(PortScheduleVO portScheduleVO) {
        if (Objects.isNull(portScheduleVO)) {
            return null;
        }
        PortOrPoeScheduleQueryOpenApiVO openApiVO = new PortOrPoeScheduleQueryOpenApiVO();
        openApiVO.setId(portScheduleVO.getId());
        openApiVO.setSiteId(portScheduleVO.getSiteId());
        openApiVO.setName(portScheduleVO.getName());
        openApiVO.setStatus(portScheduleVO.getStatus());
        openApiVO.setTurnOnTime(portScheduleVO.getTurnOnTime());
        openApiVO.setScheduleType(portScheduleVO.getScheduleType());
        openApiVO.setPortsMap(portScheduleVO.getPortsMap());
        openApiVO.setNextExecute(portScheduleVO.getNextExecute());
        openApiVO.setNotInDst(portScheduleVO.getNotInDst());
        return openApiVO;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getSiteId() {
        return this.siteId;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Integer getScheduleType() {
        return this.scheduleType;
    }

    @Generated
    public Boolean getStatus() {
        return this.status;
    }

    @Generated
    public String getTurnOnTime() {
        return this.turnOnTime;
    }

    @Generated
    public Map<String, Set<Integer>> getPortsMap() {
        return this.portsMap;
    }

    @Generated
    public Long getNextExecute() {
        return this.nextExecute;
    }

    @Generated
    public Boolean getNotInDst() {
        return this.notInDst;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setSiteId(String siteId) {
        this.siteId = siteId;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setScheduleType(Integer scheduleType) {
        this.scheduleType = scheduleType;
    }

    @Generated
    public void setStatus(Boolean status) {
        this.status = status;
    }

    @Generated
    public void setTurnOnTime(String turnOnTime) {
        this.turnOnTime = turnOnTime;
    }

    @Generated
    public void setPortsMap(Map<String, Set<Integer>> portsMap) {
        this.portsMap = portsMap;
    }

    @Generated
    public void setNextExecute(Long nextExecute) {
        this.nextExecute = nextExecute;
    }

    @Generated
    public void setNotInDst(Boolean notInDst) {
        this.notInDst = notInDst;
    }

    @Generated
    public String toString() {
        return "PortOrPoeScheduleQueryOpenApiVO(id=" + this.getId() + ", siteId=" + this.getSiteId() + ", name=" + this.getName() + ", scheduleType=" + this.getScheduleType() + ", status=" + this.getStatus() + ", turnOnTime=" + this.getTurnOnTime() + ", portsMap=" + this.getPortsMap() + ", nextExecute=" + this.getNextExecute() + ", notInDst=" + this.getNotInDst() + ")";
    }

    @Generated
    public PortOrPoeScheduleQueryOpenApiVO(String id, String siteId, String name, Integer scheduleType, Boolean status, String turnOnTime, Map<String, Set<Integer>> portsMap, Long nextExecute, Boolean notInDst) {
        this.id = id;
        this.siteId = siteId;
        this.name = name;
        this.scheduleType = scheduleType;
        this.status = status;
        this.turnOnTime = turnOnTime;
        this.portsMap = portsMap;
        this.nextExecute = nextExecute;
        this.notInDst = notInDst;
    }

    @Generated
    public PortOrPoeScheduleQueryOpenApiVO() {
    }
}

