/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting;

import com.tplink.smb.omada.manager.configuration.api.web.site.servicesetting.dto.PortPoeScheduleVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import lombok.Generated;

public class PoeScheduleQueryOpenApiVO {
    @Schema(name="id", description="PoE Schedule Individual ID.")
    private String id;
    @Schema(name="siteId", description="Site ID")
    private String siteId;
    @NotNull
    @Pattern(regexp="^[^ ]$|^[^ ].{0,126}[^ ]$", message="Parameter [name] should be 1 ~ 128 characters.")
    @Schema(name="name", description="PoE Schedule Name should contain 1 to 128 characters.")
    private @NotNull @Pattern(regexp="^[^ ]$|^[^ ].{0,126}[^ ]$", message="Parameter [name] should be 1 ~ 128 characters.") String name;
    @NotNull
    @Schema(name="status", description="PoE Schedule Status.")
    private Boolean status;
    @NotNull
    @Schema(name="turnOnTime", description="Time Range ID, cannot be empty.")
    private String turnOnTime;
    @NotNull
    @Schema(name="poePortsMap", description="Key:Mac(\"String\"), Value:Set of Ports(\"Integer\")")
    private Map<String, Set<Integer>> poePortsMap;
    @Schema(name="nextExecute", description="Show PoE Schedule next execution timestamp.")
    private Long nextExecute;
    @Schema(name="notInDst", description="When notInDst is true, not displayed in DST.")
    private Boolean notInDst;

    public static PoeScheduleQueryOpenApiVO buildByWebVO(PortPoeScheduleVO poeScheduleVO) {
        if (Objects.isNull(poeScheduleVO)) {
            return null;
        }
        PoeScheduleQueryOpenApiVO poeScheduleQueryOpenApiVO = new PoeScheduleQueryOpenApiVO();
        poeScheduleQueryOpenApiVO.setId(poeScheduleVO.getId());
        poeScheduleQueryOpenApiVO.setName(poeScheduleVO.getName());
        poeScheduleQueryOpenApiVO.setNextExecute(poeScheduleVO.getNextExecute());
        poeScheduleQueryOpenApiVO.setNotInDst(poeScheduleVO.getNotInDst());
        poeScheduleQueryOpenApiVO.setPoePortsMap(poeScheduleVO.getPoePortsMap());
        poeScheduleQueryOpenApiVO.setSiteId(poeScheduleVO.getSiteId());
        poeScheduleQueryOpenApiVO.setStatus(poeScheduleVO.getStatus());
        poeScheduleQueryOpenApiVO.setTurnOnTime(poeScheduleVO.getTurnOnTime());
        return poeScheduleQueryOpenApiVO;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getSiteId() {
        return this.siteId;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Boolean getStatus() {
        return this.status;
    }

    @Generated
    public String getTurnOnTime() {
        return this.turnOnTime;
    }

    @Generated
    public Map<String, Set<Integer>> getPoePortsMap() {
        return this.poePortsMap;
    }

    @Generated
    public Long getNextExecute() {
        return this.nextExecute;
    }

    @Generated
    public Boolean getNotInDst() {
        return this.notInDst;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setSiteId(String siteId) {
        this.siteId = siteId;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setStatus(Boolean status) {
        this.status = status;
    }

    @Generated
    public void setTurnOnTime(String turnOnTime) {
        this.turnOnTime = turnOnTime;
    }

    @Generated
    public void setPoePortsMap(Map<String, Set<Integer>> poePortsMap) {
        this.poePortsMap = poePortsMap;
    }

    @Generated
    public void setNextExecute(Long nextExecute) {
        this.nextExecute = nextExecute;
    }

    @Generated
    public void setNotInDst(Boolean notInDst) {
        this.notInDst = notInDst;
    }

    @Generated
    public String toString() {
        return "PoeScheduleQueryOpenApiVO(id=" + this.getId() + ", siteId=" + this.getSiteId() + ", name=" + this.getName() + ", status=" + this.getStatus() + ", turnOnTime=" + this.getTurnOnTime() + ", poePortsMap=" + this.getPoePortsMap() + ", nextExecute=" + this.getNextExecute() + ", notInDst=" + this.getNotInDst() + ")";
    }

    @Generated
    public PoeScheduleQueryOpenApiVO(String id, String siteId, String name, Boolean status, String turnOnTime, Map<String, Set<Integer>> poePortsMap, Long nextExecute, Boolean notInDst) {
        this.id = id;
        this.siteId = siteId;
        this.name = name;
        this.status = status;
        this.turnOnTime = turnOnTime;
        this.poePortsMap = poePortsMap;
        this.nextExecute = nextExecute;
        this.notInDst = notInDst;
    }

    @Generated
    public PoeScheduleQueryOpenApiVO() {
    }
}

