/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting;

import com.tplink.smb.omada.manager.configuration.api.web.site.servicesetting.dto.PortPoeScheduleVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import lombok.Generated;

@Schema(description="Poe schedule entity")
public class PoeScheduleOpenApiVO {
    @Schema(name="siteId", description="Site ID")
    private String siteId;
    @NotNull
    @Pattern(regexp="^[^ ]$|^[^ ].{0,126}[^ ]$", message="Parameter [name] should be 1 ~ 128 characters.")
    @Schema(name="name", description="PoE Schedule Name should contain 1 to 128 characters.")
    private @NotNull @Pattern(regexp="^[^ ]$|^[^ ].{0,126}[^ ]$", message="Parameter [name] should be 1 ~ 128 characters.") String name;
    @NotNull
    @Schema(name="status", description="PoE Schedule Status.")
    private Boolean status;
    @NotNull
    @Schema(name="turnOnTime", description="Time Range ID, cannot be empty.")
    private String turnOnTime;
    @NotNull
    @Schema(name="poePortsMap", description="Key:Mac(\"String\"), Value:Set of Ports(\"Integer\")")
    private Map<String, Set<Integer>> poePortsMap;

    public static PortPoeScheduleVO toWebVO(PoeScheduleOpenApiVO poeScheduleOpenApiVO) {
        Integer POE_SCHEDULE_TYPE_PERIOD = 0;
        if (Objects.isNull(poeScheduleOpenApiVO)) {
            return null;
        }
        PortPoeScheduleVO poeScheduleVO = new PortPoeScheduleVO();
        poeScheduleVO.setSiteId(poeScheduleOpenApiVO.getSiteId());
        poeScheduleVO.setName(poeScheduleOpenApiVO.getName());
        poeScheduleVO.setStatus(poeScheduleOpenApiVO.getStatus());
        poeScheduleVO.setTurnOnTime(poeScheduleOpenApiVO.getTurnOnTime());
        poeScheduleVO.setPoePortsMap(poeScheduleOpenApiVO.getPoePortsMap());
        poeScheduleVO.setPoeScheduleType(POE_SCHEDULE_TYPE_PERIOD);
        return poeScheduleVO;
    }

    @Generated
    public String getSiteId() {
        return this.siteId;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Boolean getStatus() {
        return this.status;
    }

    @Generated
    public String getTurnOnTime() {
        return this.turnOnTime;
    }

    @Generated
    public Map<String, Set<Integer>> getPoePortsMap() {
        return this.poePortsMap;
    }

    @Generated
    public void setSiteId(String siteId) {
        this.siteId = siteId;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setStatus(Boolean status) {
        this.status = status;
    }

    @Generated
    public void setTurnOnTime(String turnOnTime) {
        this.turnOnTime = turnOnTime;
    }

    @Generated
    public void setPoePortsMap(Map<String, Set<Integer>> poePortsMap) {
        this.poePortsMap = poePortsMap;
    }

    @Generated
    public String toString() {
        return "PoeScheduleOpenApiVO(siteId=" + this.getSiteId() + ", name=" + this.getName() + ", status=" + this.getStatus() + ", turnOnTime=" + this.getTurnOnTime() + ", poePortsMap=" + this.getPoePortsMap() + ")";
    }

    @Generated
    public PoeScheduleOpenApiVO(String siteId, String name, Boolean status, String turnOnTime, Map<String, Set<Integer>> poePortsMap) {
        this.siteId = siteId;
        this.name = name;
        this.status = status;
        this.turnOnTime = turnOnTime;
        this.poePortsMap = poePortsMap;
    }

    @Generated
    public PoeScheduleOpenApiVO() {
    }
}

