/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting;

import com.tplink.nbu.common.pii.annotation.PII;
import com.tplink.nbu.common.pii.constant.PIIMaskStrategy;
import com.tplink.smb.omada.a.a;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.annotation.Nullable;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;

@Schema(name="PpskSetting V2", description="This field is required when Parameter [autoCreatePsks] is false; PPSK List In the PPSK Profile")
public class PSKV2OpenApiVO {
    @Schema(name="name", description="PPSK Name, should contain 1 to 64 characters.")
    @NotNull(message="PPSK Name should not be null")
    @Pattern(regexp="^[a-zA-z0-9'!\"#$%&()*,./:;?^_`\\[\\]{|}~<>\\ ][\\041-\\0176]{0,63}$", message="PPSK Name should be 1~64 visible ASCII characters.")
    private @NotNull(message="PPSK Name should not be null") @Pattern(regexp="^[a-zA-z0-9'!\"#$%&()*,./:;?^_`\\[\\]{|}~<>\\ ][\\041-\\0176]{0,63}$", message="PPSK Name should be 1~64 visible ASCII characters.") String name;
    @Schema(name="psk", description="Password, should contain 8 to 63 visible ASCII characters.")
    @NotNull(message="PSK should not be null")
    @Pattern(regexp="^([A-Za-z0-9\\p{Punct} ]{8,63}|[0-9a-fA-F]{8,63})$", message="PSK should be 8~63 visible ASCII characters.")
    @PII(strategy=PIIMaskStrategy.ENCRYPT)
    private @NotNull(message="PSK should not be null") @Pattern(regexp="^([A-Za-z0-9\\p{Punct} ]{8,63}|[0-9a-fA-F]{8,63})$", message="PSK should be 8~63 visible ASCII characters.") String psk;
    @Schema(name="mac", description="Mac Bound With PSK.The MAC format requires the use of numbers and uppercase letters and connectors, such as AA-BB-CC-00-11-22.")
    @Nullable
    @a
    @Pattern(regexp="^([0-9A-F][02468ACE](:[0-9A-F]{2}){5})|([0-9a-f][02468ace](:[0-9a-f]{2}){5})|([0-9A-F][02468ACE](-[0-9A-F]{2}){5})|([0-9a-f][02468ace](-[0-9a-f]{2}){5})|([0-9A-F][02468ACE]([0-9A-F]{2}){5})|([0-9a-f][02468ace]([0-9a-f]{2}){5})$", message="Parameter [mac] should be a valid MAC address.")
    private @Pattern(regexp="^([0-9A-F][02468ACE](:[0-9A-F]{2}){5})|([0-9a-f][02468ace](:[0-9a-f]{2}){5})|([0-9A-F][02468ACE](-[0-9A-F]{2}){5})|([0-9a-f][02468ace](-[0-9a-f]{2}){5})|([0-9A-F][02468ACE]([0-9A-F]{2}){5})|([0-9a-f][02468ace]([0-9a-f]{2}){5})$", message="Parameter [mac] should be a valid MAC address.") String mac;
    @Schema(name="vlan", description="Vlan Bound With PSK, should be within the range of 1-4094.")
    @Nullable
    @Range(min=1L, max=4094L, message="Vlan should be from 1 to 4094.")
    private @Range(min=1L, max=4094L, message="Vlan should be from 1 to 4094.") Integer vlan;

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getPsk() {
        return this.psk;
    }

    @Nullable
    @Generated
    public String getMac() {
        return this.mac;
    }

    @Nullable
    @Generated
    public Integer getVlan() {
        return this.vlan;
    }

    @Generated
    public PSKV2OpenApiVO setName(String name) {
        this.name = name;
        return this;
    }

    @Generated
    public PSKV2OpenApiVO setPsk(String psk) {
        this.psk = psk;
        return this;
    }

    @Generated
    public PSKV2OpenApiVO setMac(@Nullable String mac) {
        this.mac = mac;
        return this;
    }

    @Generated
    public PSKV2OpenApiVO setVlan(@Nullable Integer vlan) {
        this.vlan = vlan;
        return this;
    }

    @Generated
    public String toString() {
        return "PSKV2OpenApiVO(name=" + this.getName() + ", psk=" + this.getPsk() + ", mac=" + this.getMac() + ", vlan=" + this.getVlan() + ")";
    }

    @Generated
    public PSKV2OpenApiVO() {
    }

    @Generated
    public PSKV2OpenApiVO(String name, String psk, @Nullable String mac, @Nullable Integer vlan) {
        this.name = name;
        this.psk = psk;
        this.mac = mac;
        this.vlan = vlan;
    }
}

