/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting;

import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.PSKOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.profile.dto.ppsk.PPSKExpirationVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.profile.dto.ppsk.PPSKRateLimitSettingVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.annotation.Nullable;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import java.util.List;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;

@Schema(name="PpskProfile", description="PPSK Profile Setting.")
public class PPSKProfileOpenApiVO {
    @Schema(name="profileName", description="PPSK Profile Name, should contain 1 to 64 characters.")
    @NotNull(message="PPSK Profile name should not be null.")
    @Pattern(regexp="^[^ \\+\\-\\@\\=]$|^[^ \\+\\-\\@\\=].{0,62}[^ ]$", message="PPSK profile name should be 1~64.")
    private @NotNull(message="PPSK Profile name should not be null.") @Pattern(regexp="^[^ \\+\\-\\@\\=]$|^[^ \\+\\-\\@\\=].{0,62}[^ ]$", message="PPSK profile name should be 1~64.") String profileName;
    @Schema(name="ppsk", description="PPSK List In the PPSK Profile")
    @NotNull
    @Valid
    private List<PSKOpenApiVO> ppsk;
    @Schema(name="type", description="This field has been deprecated since version 6.1. PPSK Profile type: 0\uff1aPPSK Without RADIUS;Cloud Based Controller only support PPSK Without RADIUS.")
    @Range(min=0L, max=0L, message="PPSK Profile type should be 0.")
    private @Range(min=0L, max=0L, message="PPSK Profile type should be 0.") Integer type;
    @Schema(name="rateLimit", description="PPSK Profile Rate Limit config.")
    @Nullable
    @Valid
    private PPSKRateLimitSettingVO rateLimit;
    @Schema(name="expiration", description="PPSK Profile expiration time config.")
    @Nullable
    @Valid
    private PPSKExpirationVO expiration;

    @Generated
    public String getProfileName() {
        return this.profileName;
    }

    @Generated
    public List<PSKOpenApiVO> getPpsk() {
        return this.ppsk;
    }

    @Generated
    public Integer getType() {
        return this.type;
    }

    @Nullable
    @Generated
    public PPSKRateLimitSettingVO getRateLimit() {
        return this.rateLimit;
    }

    @Nullable
    @Generated
    public PPSKExpirationVO getExpiration() {
        return this.expiration;
    }

    @Generated
    public PPSKProfileOpenApiVO setProfileName(String profileName) {
        this.profileName = profileName;
        return this;
    }

    @Generated
    public PPSKProfileOpenApiVO setPpsk(List<PSKOpenApiVO> ppsk) {
        this.ppsk = ppsk;
        return this;
    }

    @Generated
    public PPSKProfileOpenApiVO setType(Integer type) {
        this.type = type;
        return this;
    }

    @Generated
    public PPSKProfileOpenApiVO setRateLimit(@Nullable PPSKRateLimitSettingVO rateLimit) {
        this.rateLimit = rateLimit;
        return this;
    }

    @Generated
    public PPSKProfileOpenApiVO setExpiration(@Nullable PPSKExpirationVO expiration) {
        this.expiration = expiration;
        return this;
    }

    @Generated
    public String toString() {
        return "PPSKProfileOpenApiVO(profileName=" + this.getProfileName() + ", ppsk=" + this.getPpsk() + ", type=" + this.getType() + ", rateLimit=" + this.getRateLimit() + ", expiration=" + this.getExpiration() + ")";
    }

    @Generated
    public PPSKProfileOpenApiVO() {
    }

    @Generated
    public PPSKProfileOpenApiVO(String profileName, List<PSKOpenApiVO> ppsk, Integer type, @Nullable PPSKRateLimitSettingVO rateLimit, @Nullable PPSKExpirationVO expiration) {
        this.profileName = profileName;
        this.ppsk = ppsk;
        this.type = type;
        this.rateLimit = rateLimit;
        this.expiration = expiration;
    }
}

