/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.annotation.Nullable;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;

@Schema(name="PpskAutoCreateSetting", description="Auto Create PPSK Setting.")
public class PPSKAutoTypeOpenApiVO {
    @Schema(name="number", description="Generate Number, should be within the range of 1-1024.")
    @Range(min=1L, max=1024L, message="Generate Number should be from 1 to 1024.")
    @NotNull
    private @Range(min=1L, max=1024L, message="Generate Number should be from 1 to 1024.") @NotNull Integer number;
    @Schema(name="prefix", description="PSK Name Prefix, should contain 1 to 60 visible ASCII characters.")
    @NotNull
    @Pattern(regexp="^[a-zA-z0-9'!\"#$%&()*,./:;?^_`\\[\\]{|}~<>\\ ][\\041-\\0176]{0,59}$", message="PSK should be 1~60 visible ASCII characters.")
    private @NotNull @Pattern(regexp="^[a-zA-z0-9'!\"#$%&()*,./:;?^_`\\[\\]{|}~<>\\ ][\\041-\\0176]{0,59}$", message="PSK should be 1~60 visible ASCII characters.") String prefix;
    @Schema(name="length", description="PSK Password Length, should be within the range of 8-63.")
    @Range(min=8L, max=63L, message="PSK Length should be from 8 to 63.")
    @NotNull
    private @Range(min=8L, max=63L, message="PSK Length should be from 8 to 63.") @NotNull Integer length;
    @Schema(name="vlan", description="PSK Bound Vlan, should be within the range of 1-4094.")
    @Range(min=1L, max=4094L, message="Vlan should be from 1 to 4094.")
    @Nullable
    private @Range(min=1L, max=4094L, message="Vlan should be from 1 to 4094.") Integer vlan;

    @Generated
    public Integer getNumber() {
        return this.number;
    }

    @Generated
    public String getPrefix() {
        return this.prefix;
    }

    @Generated
    public Integer getLength() {
        return this.length;
    }

    @Nullable
    @Generated
    public Integer getVlan() {
        return this.vlan;
    }

    @Generated
    public PPSKAutoTypeOpenApiVO setNumber(Integer number) {
        this.number = number;
        return this;
    }

    @Generated
    public PPSKAutoTypeOpenApiVO setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    @Generated
    public PPSKAutoTypeOpenApiVO setLength(Integer length) {
        this.length = length;
        return this;
    }

    @Generated
    public PPSKAutoTypeOpenApiVO setVlan(@Nullable Integer vlan) {
        this.vlan = vlan;
        return this;
    }

    @Generated
    public String toString() {
        return "PPSKAutoTypeOpenApiVO(number=" + this.getNumber() + ", prefix=" + this.getPrefix() + ", length=" + this.getLength() + ", vlan=" + this.getVlan() + ")";
    }

    @Generated
    public PPSKAutoTypeOpenApiVO() {
    }

    @Generated
    public PPSKAutoTypeOpenApiVO(Integer number, String prefix, Integer length, @Nullable Integer vlan) {
        this.number = number;
        this.prefix = prefix;
        this.length = length;
        this.vlan = vlan;
    }
}

