/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting;

import com.tplink.smb.omada.common.util.T;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.OuiCombineOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.profile.dto.OuiCombineVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.profile.dto.OuiProfileVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import lombok.Generated;

@Schema(description="OUIProfileQueryOpenApiVO")
public class OuiProfileQueryOpenApiVO {
    @Schema(name="id", description="OUI Profile ID")
    private String id;
    @NotNull
    @Pattern(regexp="^[^ ]$|^[^ ].{0,62}[^ ]$", message="Parameter [name] should not be between 1 and 64 characters.")
    @Schema(name="name", description="OUI Profile name should contain 1 to 64 characters.")
    private @NotNull @Pattern(regexp="^[^ ]$|^[^ ].{0,62}[^ ]$", message="Parameter [name] should not be between 1 and 64 characters.") String name;
    @Schema(name="count", description="OUI Profile count")
    private Integer count;
    @Schema(name="ouiCombine", description="OUI and description")
    private List<OuiCombineOpenApiVO> ouiCombine;

    public static OuiProfileQueryOpenApiVO buildByWebVO(OuiProfileVO ouiProfileVO) {
        if (Objects.isNull(ouiProfileVO)) {
            return null;
        }
        OuiProfileQueryOpenApiVO ouiProfileQueryOpenApiVO = new OuiProfileQueryOpenApiVO();
        ouiProfileQueryOpenApiVO.setId(ouiProfileVO.getId());
        ouiProfileQueryOpenApiVO.setName(ouiProfileVO.getName());
        ouiProfileQueryOpenApiVO.setCount(ouiProfileVO.getCount());
        ouiProfileQueryOpenApiVO.setOuiCombine(OuiProfileQueryOpenApiVO.buildOuiCombine(ouiProfileVO.getOuiCombine()));
        return ouiProfileQueryOpenApiVO;
    }

    private static List<OuiCombineOpenApiVO> buildOuiCombine(List<OuiCombineVO> ouiCombineVO) {
        if (Objects.isNull(ouiCombineVO)) {
            return null;
        }
        ArrayList<OuiCombineOpenApiVO> ouiCombineOpenApiVOList = new ArrayList<OuiCombineOpenApiVO>();
        ouiCombineVO.forEach(ouiCombine -> {
            OuiCombineOpenApiVO ouiCombineOpenApiVO = new OuiCombineOpenApiVO();
            if (T.b((String)ouiCombine.getOui())) {
                ouiCombineOpenApiVO.setOui(ouiCombine.getOui().toUpperCase());
            } else {
                ouiCombineOpenApiVO.setOui(ouiCombine.getOui());
            }
            ouiCombineOpenApiVO.setDescription(ouiCombine.getDescription());
            ouiCombineOpenApiVOList.add(ouiCombineOpenApiVO);
        });
        return ouiCombineOpenApiVOList;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Integer getCount() {
        return this.count;
    }

    @Generated
    public List<OuiCombineOpenApiVO> getOuiCombine() {
        return this.ouiCombine;
    }

    @Generated
    public OuiProfileQueryOpenApiVO setId(String id) {
        this.id = id;
        return this;
    }

    @Generated
    public OuiProfileQueryOpenApiVO setName(String name) {
        this.name = name;
        return this;
    }

    @Generated
    public OuiProfileQueryOpenApiVO setCount(Integer count) {
        this.count = count;
        return this;
    }

    @Generated
    public OuiProfileQueryOpenApiVO setOuiCombine(List<OuiCombineOpenApiVO> ouiCombine) {
        this.ouiCombine = ouiCombine;
        return this;
    }

    @Generated
    public String toString() {
        return "OuiProfileQueryOpenApiVO(id=" + this.getId() + ", name=" + this.getName() + ", count=" + this.getCount() + ", ouiCombine=" + this.getOuiCombine() + ")";
    }
}

