/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting;

import com.tplink.smb.omada.common.util.T;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.OuiCombineOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.profile.dto.OuiCombineVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.profile.dto.OuiProfileVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import lombok.Generated;

@Schema(description="OUIProfileOpenApiVO")
public class OuiProfileOpenApiVO {
    @NotNull
    @Pattern(regexp="^[^ ]$|^[^ ].{0,62}[^ ]$", message="Parameter [name] should be between 1 and 64 characters.")
    @Schema(name="name", description="OUI Profile name should contain 1 to 64 characters.")
    private @NotNull @Pattern(regexp="^[^ ]$|^[^ ].{0,62}[^ ]$", message="Parameter [name] should be between 1 and 64 characters.") String name;
    @Schema(name="ouiCombine", description="OUI and description")
    private List<OuiCombineOpenApiVO> ouiCombine;

    public static OuiProfileOpenApiVO buildByWebVO(OuiProfileVO ouiProfileVO) {
        if (Objects.isNull(ouiProfileVO)) {
            return null;
        }
        OuiProfileOpenApiVO ouiProfileOpenApiVO = new OuiProfileOpenApiVO();
        ouiProfileOpenApiVO.setName(ouiProfileVO.getName());
        ouiProfileOpenApiVO.setOuiCombine(OuiProfileOpenApiVO.buildOuiCombine(ouiProfileVO.getOuiCombine()));
        return ouiProfileOpenApiVO;
    }

    private static List<OuiCombineOpenApiVO> buildOuiCombine(List<OuiCombineVO> ouiCombineVO) {
        if (Objects.isNull(ouiCombineVO)) {
            return null;
        }
        ArrayList<OuiCombineOpenApiVO> ouiCombineOpenApiVOList = new ArrayList<OuiCombineOpenApiVO>();
        ouiCombineVO.forEach(ouiCombine -> {
            OuiCombineOpenApiVO ouiCombineOpenApiVO = new OuiCombineOpenApiVO();
            if (T.b((String)ouiCombine.getOui())) {
                ouiCombineOpenApiVO.setOui(ouiCombine.getOui().toUpperCase());
            } else {
                ouiCombineOpenApiVO.setOui(ouiCombine.getOui());
            }
            ouiCombineOpenApiVO.setDescription(ouiCombine.getDescription());
            ouiCombineOpenApiVOList.add(ouiCombineOpenApiVO);
        });
        return ouiCombineOpenApiVOList;
    }

    public static OuiProfileVO toWebVO(OuiProfileOpenApiVO ouiProfileOpenApiVO) {
        if (Objects.isNull(ouiProfileOpenApiVO)) {
            return null;
        }
        OuiProfileVO ouiProfileVO = new OuiProfileVO();
        ouiProfileVO.setName(ouiProfileOpenApiVO.getName());
        ouiProfileVO.setOuiCombine(OuiProfileOpenApiVO.toOuiCombine(ouiProfileOpenApiVO.getOuiCombine()));
        return ouiProfileVO;
    }

    private static List<OuiCombineVO> toOuiCombine(List<OuiCombineOpenApiVO> ouiCombine) {
        if (Objects.isNull(ouiCombine)) {
            return null;
        }
        ArrayList<OuiCombineVO> ouiCombineVOList = new ArrayList<OuiCombineVO>();
        ouiCombine.forEach(openApiVO -> {
            OuiCombineVO ouiCombineVO = new OuiCombineVO();
            ouiCombineVO.setOui(openApiVO.getOui().toUpperCase());
            ouiCombineVO.setDescription(openApiVO.getDescription());
            ouiCombineVOList.add(ouiCombineVO);
        });
        return ouiCombineVOList;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public List<OuiCombineOpenApiVO> getOuiCombine() {
        return this.ouiCombine;
    }

    @Generated
    public OuiProfileOpenApiVO setName(String name) {
        this.name = name;
        return this;
    }

    @Generated
    public OuiProfileOpenApiVO setOuiCombine(List<OuiCombineOpenApiVO> ouiCombine) {
        this.ouiCombine = ouiCombine;
        return this;
    }

    @Generated
    public String toString() {
        return "OuiProfileOpenApiVO(name=" + this.getName() + ", ouiCombine=" + this.getOuiCombine() + ")";
    }
}

