/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting;

import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.AclConfigOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.CustomAclOswOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.EtherTypeOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.OswAclPortOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.firewall.dto.AclVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;
import org.springframework.util.CollectionUtils;

@Schema(name="SwitchACLConfig")
public class OswConfigAclOpenApiVO
extends AclConfigOpenApiVO {
    @NotNull(message="sourceType must not be null")
    @Schema(name="sourceType", description="SourceType should be a value as follows: 0: network; 1: IP Group; 2: IP-Port Group; 4: SSID; 6: IPv6 Group; 7: IPv6-Port Group")
    @Range(min=0L, max=9L)
    private @NotNull(message="sourceType must not be null") @Range(min=0L, max=9L) Integer sourceType;
    @NotNull(message="destinationType must not be null")
    @Range(min=0L, max=10L)
    @Schema(name="destinationType", description="DestinationType should be a value as follows: 0: network; 1: IP Group; 2: IP-Port Group; 6: IPv6 Group; 7: IPv6-Port Group")
    private @NotNull(message="destinationType must not be null") @Range(min=0L, max=10L) Integer destinationType;
    @Range(min=0L, max=3L)
    @NotNull(message="bindingType must not be null")
    @Schema(name="bindingType", description="BindingType should be a value as follows: 0: all ports; 1: custom ports; 2: all switch vlan; 3: custom switch vlan")
    private @Range(min=0L, max=3L) @NotNull(message="bindingType must not be null") Integer bindingType;
    @Valid
    @Schema(name="customAclPorts", description="Only for bindingType is custom ports, select the custom port or LAG of the device")
    private List<OswAclPortOpenApiVO> customAclPorts;
    @Schema(name="networkId", description="Only for bindingType VLAN")
    private String networkId;
    @Schema(name="bindingBridgeVlan", description="Only for bindingType VLAN and network of bridge VLAN")
    private Integer bindingBridgeVlan;
    @Schema(name="customAclOsws", description="Only for bindingType is custom switch vlan, list of selected switch mac")
    private List<String> customAclOsws;
    @Schema(name="customAclStacks", description="Only for bindingType is custom switch vlan, list of selected stack id")
    private List<String> customAclStacks;
    @Schema(name="customAclDevices", description="Only for bindingType is custom switch vlan, list of selected device")
    private List<CustomAclOswOpenApiVO> customAclDevices;
    @Valid
    @Schema(name="etherType", description="Ethertype(4-hex number; 0-9\uff0cA-F) is only editable when the Source Type and Destination Type are both selected as MAC Group in the Rule.")
    @NotNull
    private EtherTypeOpenApiVO etherType;
    @Schema(name="timeRangeId", description="Time range profile ID")
    private String timeRangeId;
    @Schema(name="biDirectional", description="Whether to enable the bidirectional, this field required only when creating a new entry")
    private Boolean biDirectional;

    public static AclVO toWebVO(OswConfigAclOpenApiVO aclVO) {
        AclVO vo = AclVO.builder().name(aclVO.getDescription()).status(aclVO.getStatus()).policy(aclVO.getPolicy()).protocols(aclVO.getProtocols()).sourceType(aclVO.getSourceType()).sourceIds(aclVO.getSourceIds()).destinationType(aclVO.getDestinationType()).destinationIds(aclVO.getDestinationIds()).bindingType(aclVO.getBindingType()).timeRangeId(aclVO.getTimeRangeId()).biDirectional(aclVO.getBiDirectional()).build();
        if (aclVO.getEtherType() != null) {
            vo.setEtherType(EtherTypeOpenApiVO.toWebVO(aclVO.getEtherType()));
        }
        if (vo.getBindingType() == 1 && !CollectionUtils.isEmpty(aclVO.getCustomAclPorts())) {
            vo.setCustomAclPorts(aclVO.getCustomAclPorts().stream().map(OswAclPortOpenApiVO::toWebVO).collect(Collectors.toList()));
        }
        if (vo.getBindingType() == 2) {
            vo.setNetworkId(aclVO.getNetworkId());
            vo.setBindingBridgeVlan(aclVO.getBindingBridgeVlan());
        }
        if (vo.getBindingType() == 3) {
            vo.setCustomAclOsws(aclVO.getCustomAclOsws());
            vo.setCustomAclStacks(aclVO.getCustomAclStacks());
            if (!CollectionUtils.isEmpty(aclVO.getCustomAclDevices())) {
                vo.setCustomAclDevices(aclVO.getCustomAclDevices().stream().map(CustomAclOswOpenApiVO::toWebVO).collect(Collectors.toList()));
            }
        }
        return vo;
    }

    @Generated
    protected OswConfigAclOpenApiVO(OswConfigAclOpenApiVOBuilder<?, ?> b2) {
        super(b2);
        this.sourceType = b2.sourceType;
        this.destinationType = b2.destinationType;
        this.bindingType = b2.bindingType;
        this.customAclPorts = b2.customAclPorts;
        this.networkId = b2.networkId;
        this.bindingBridgeVlan = b2.bindingBridgeVlan;
        this.customAclOsws = b2.customAclOsws;
        this.customAclStacks = b2.customAclStacks;
        this.customAclDevices = b2.customAclDevices;
        this.etherType = b2.etherType;
        this.timeRangeId = b2.timeRangeId;
        this.biDirectional = b2.biDirectional;
    }

    @Generated
    public static OswConfigAclOpenApiVOBuilder<?, ?> builder() {
        return new OswConfigAclOpenApiVOBuilderImpl();
    }

    @Generated
    public Integer getSourceType() {
        return this.sourceType;
    }

    @Generated
    public Integer getDestinationType() {
        return this.destinationType;
    }

    @Generated
    public Integer getBindingType() {
        return this.bindingType;
    }

    @Generated
    public List<OswAclPortOpenApiVO> getCustomAclPorts() {
        return this.customAclPorts;
    }

    @Generated
    public String getNetworkId() {
        return this.networkId;
    }

    @Generated
    public Integer getBindingBridgeVlan() {
        return this.bindingBridgeVlan;
    }

    @Generated
    public List<String> getCustomAclOsws() {
        return this.customAclOsws;
    }

    @Generated
    public List<String> getCustomAclStacks() {
        return this.customAclStacks;
    }

    @Generated
    public List<CustomAclOswOpenApiVO> getCustomAclDevices() {
        return this.customAclDevices;
    }

    @Generated
    public EtherTypeOpenApiVO getEtherType() {
        return this.etherType;
    }

    @Generated
    public String getTimeRangeId() {
        return this.timeRangeId;
    }

    @Generated
    public Boolean getBiDirectional() {
        return this.biDirectional;
    }

    @Generated
    public OswConfigAclOpenApiVO setSourceType(Integer sourceType) {
        this.sourceType = sourceType;
        return this;
    }

    @Generated
    public OswConfigAclOpenApiVO setDestinationType(Integer destinationType) {
        this.destinationType = destinationType;
        return this;
    }

    @Generated
    public OswConfigAclOpenApiVO setBindingType(Integer bindingType) {
        this.bindingType = bindingType;
        return this;
    }

    @Generated
    public OswConfigAclOpenApiVO setCustomAclPorts(List<OswAclPortOpenApiVO> customAclPorts) {
        this.customAclPorts = customAclPorts;
        return this;
    }

    @Generated
    public OswConfigAclOpenApiVO setNetworkId(String networkId) {
        this.networkId = networkId;
        return this;
    }

    @Generated
    public OswConfigAclOpenApiVO setBindingBridgeVlan(Integer bindingBridgeVlan) {
        this.bindingBridgeVlan = bindingBridgeVlan;
        return this;
    }

    @Generated
    public OswConfigAclOpenApiVO setCustomAclOsws(List<String> customAclOsws) {
        this.customAclOsws = customAclOsws;
        return this;
    }

    @Generated
    public OswConfigAclOpenApiVO setCustomAclStacks(List<String> customAclStacks) {
        this.customAclStacks = customAclStacks;
        return this;
    }

    @Generated
    public OswConfigAclOpenApiVO setCustomAclDevices(List<CustomAclOswOpenApiVO> customAclDevices) {
        this.customAclDevices = customAclDevices;
        return this;
    }

    @Generated
    public OswConfigAclOpenApiVO setEtherType(EtherTypeOpenApiVO etherType) {
        this.etherType = etherType;
        return this;
    }

    @Generated
    public OswConfigAclOpenApiVO setTimeRangeId(String timeRangeId) {
        this.timeRangeId = timeRangeId;
        return this;
    }

    @Generated
    public OswConfigAclOpenApiVO setBiDirectional(Boolean biDirectional) {
        this.biDirectional = biDirectional;
        return this;
    }

    @Override
    @Generated
    public String toString() {
        return "OswConfigAclOpenApiVO(sourceType=" + this.getSourceType() + ", destinationType=" + this.getDestinationType() + ", bindingType=" + this.getBindingType() + ", customAclPorts=" + this.getCustomAclPorts() + ", networkId=" + this.getNetworkId() + ", bindingBridgeVlan=" + this.getBindingBridgeVlan() + ", customAclOsws=" + this.getCustomAclOsws() + ", customAclStacks=" + this.getCustomAclStacks() + ", customAclDevices=" + this.getCustomAclDevices() + ", etherType=" + this.getEtherType() + ", timeRangeId=" + this.getTimeRangeId() + ", biDirectional=" + this.getBiDirectional() + ")";
    }

    @Generated
    public OswConfigAclOpenApiVO(Integer sourceType, Integer destinationType, Integer bindingType, List<OswAclPortOpenApiVO> customAclPorts, String networkId, Integer bindingBridgeVlan, List<String> customAclOsws, List<String> customAclStacks, List<CustomAclOswOpenApiVO> customAclDevices, EtherTypeOpenApiVO etherType, String timeRangeId, Boolean biDirectional) {
        this.sourceType = sourceType;
        this.destinationType = destinationType;
        this.bindingType = bindingType;
        this.customAclPorts = customAclPorts;
        this.networkId = networkId;
        this.bindingBridgeVlan = bindingBridgeVlan;
        this.customAclOsws = customAclOsws;
        this.customAclStacks = customAclStacks;
        this.customAclDevices = customAclDevices;
        this.etherType = etherType;
        this.timeRangeId = timeRangeId;
        this.biDirectional = biDirectional;
    }

    @Generated
    public OswConfigAclOpenApiVO() {
    }

    @Generated
    public static abstract class OswConfigAclOpenApiVOBuilder<C extends OswConfigAclOpenApiVO, B extends OswConfigAclOpenApiVOBuilder<C, B>>
    extends AclConfigOpenApiVO.AclConfigOpenApiVOBuilder<C, B> {
        @Generated
        private Integer sourceType;
        @Generated
        private Integer destinationType;
        @Generated
        private Integer bindingType;
        @Generated
        private List<OswAclPortOpenApiVO> customAclPorts;
        @Generated
        private String networkId;
        @Generated
        private Integer bindingBridgeVlan;
        @Generated
        private List<String> customAclOsws;
        @Generated
        private List<String> customAclStacks;
        @Generated
        private List<CustomAclOswOpenApiVO> customAclDevices;
        @Generated
        private EtherTypeOpenApiVO etherType;
        @Generated
        private String timeRangeId;
        @Generated
        private Boolean biDirectional;

        @Generated
        public B sourceType(Integer sourceType) {
            this.sourceType = sourceType;
            return (B)this.self();
        }

        @Generated
        public B destinationType(Integer destinationType) {
            this.destinationType = destinationType;
            return (B)this.self();
        }

        @Generated
        public B bindingType(Integer bindingType) {
            this.bindingType = bindingType;
            return (B)this.self();
        }

        @Generated
        public B customAclPorts(List<OswAclPortOpenApiVO> customAclPorts) {
            this.customAclPorts = customAclPorts;
            return (B)this.self();
        }

        @Generated
        public B networkId(String networkId) {
            this.networkId = networkId;
            return (B)this.self();
        }

        @Generated
        public B bindingBridgeVlan(Integer bindingBridgeVlan) {
            this.bindingBridgeVlan = bindingBridgeVlan;
            return (B)this.self();
        }

        @Generated
        public B customAclOsws(List<String> customAclOsws) {
            this.customAclOsws = customAclOsws;
            return (B)this.self();
        }

        @Generated
        public B customAclStacks(List<String> customAclStacks) {
            this.customAclStacks = customAclStacks;
            return (B)this.self();
        }

        @Generated
        public B customAclDevices(List<CustomAclOswOpenApiVO> customAclDevices) {
            this.customAclDevices = customAclDevices;
            return (B)this.self();
        }

        @Generated
        public B etherType(EtherTypeOpenApiVO etherType) {
            this.etherType = etherType;
            return (B)this.self();
        }

        @Generated
        public B timeRangeId(String timeRangeId) {
            this.timeRangeId = timeRangeId;
            return (B)this.self();
        }

        @Generated
        public B biDirectional(Boolean biDirectional) {
            this.biDirectional = biDirectional;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "OswConfigAclOpenApiVO.OswConfigAclOpenApiVOBuilder(super=" + super.toString() + ", sourceType=" + this.sourceType + ", destinationType=" + this.destinationType + ", bindingType=" + this.bindingType + ", customAclPorts=" + this.customAclPorts + ", networkId=" + this.networkId + ", bindingBridgeVlan=" + this.bindingBridgeVlan + ", customAclOsws=" + this.customAclOsws + ", customAclStacks=" + this.customAclStacks + ", customAclDevices=" + this.customAclDevices + ", etherType=" + this.etherType + ", timeRangeId=" + this.timeRangeId + ", biDirectional=" + this.biDirectional + ")";
        }
    }

    @Generated
    private static final class OswConfigAclOpenApiVOBuilderImpl
    extends OswConfigAclOpenApiVOBuilder<OswConfigAclOpenApiVO, OswConfigAclOpenApiVOBuilderImpl> {
        @Generated
        private OswConfigAclOpenApiVOBuilderImpl() {
        }

        @Override
        @Generated
        protected OswConfigAclOpenApiVOBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public OswConfigAclOpenApiVO build() {
            return new OswConfigAclOpenApiVO(this);
        }
    }
}

