/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting;

import com.tplink.smb.omada.a.a;
import com.tplink.smb.omada.manager.configuration.api.web.site.firewall.dto.embed.AclPortVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import java.util.Set;
import lombok.Generated;

@Schema(name="Switch ACL port entity", description="only for bindingType custom ports")
public class OswAclPortOpenApiVO {
    @NotNull
    @Schema(name="mac", description="MAC")
    @a
    private String mac;
    @Schema(name="stackId", description="Stack ID")
    private String stackId;
    @NotNull
    @Schema(name="customPortIds", description="Custom port IDs")
    private Set<Integer> customPortIds;
    @Schema(name="standardCustomPortIds", description="Custom standard port IDs")
    private Set<String> standardCustomPortIds;
    @NotNull
    @Schema(name="customLagIds", description="Custom lag IDs")
    private Set<Integer> customLagIds;
    @Schema(name="vrfId", description="VRF ID")
    private String vrfId;
    @NotNull(message="vrf should not be null")
    @Pattern(regexp="^(?!(\\.|\\.\\.)$)[a-zA-Z0-9.\\-_@+]{1,15}$", message="Parameter [vrf] is invalid.")
    @Schema(name="vrf", description="VRF should be 1 to 15 characters consisting of numbers (0 to 9), uppercase and lowercase letters (A to Z, a to z), and symbols -_@.+ but cannot be . or .. only.", requiredMode=Schema.RequiredMode.REQUIRED)
    private @NotNull(message="vrf should not be null") @Pattern(regexp="^(?!(\\.|\\.\\.)$)[a-zA-Z0-9.\\-_@+]{1,15}$", message="Parameter [vrf] is invalid.") String vrf;

    public static OswAclPortOpenApiVO buildByWebVO(AclPortVO aclPortVO) {
        OswAclPortOpenApiVO oswAclPortOpenApiVO = new OswAclPortOpenApiVO();
        oswAclPortOpenApiVO.setMac(aclPortVO.getMac());
        oswAclPortOpenApiVO.setStackId(aclPortVO.getStackId());
        oswAclPortOpenApiVO.setCustomPortIds(aclPortVO.getCustomPortIds());
        oswAclPortOpenApiVO.setStandardCustomPortIds(aclPortVO.getStandardCustomPortIds());
        oswAclPortOpenApiVO.setCustomLagIds(aclPortVO.getCustomLagIds());
        oswAclPortOpenApiVO.setVrfId(aclPortVO.getVrfId());
        oswAclPortOpenApiVO.setVrf(aclPortVO.getVrf());
        return oswAclPortOpenApiVO;
    }

    public static AclPortVO toWebVO(OswAclPortOpenApiVO oswAclPortOpenApiVO) {
        AclPortVO aclPortVO = new AclPortVO();
        aclPortVO.setMac(oswAclPortOpenApiVO.getMac());
        aclPortVO.setStackId(oswAclPortOpenApiVO.getStackId());
        aclPortVO.setCustomLagIds(oswAclPortOpenApiVO.getCustomLagIds());
        aclPortVO.setCustomPortIds(oswAclPortOpenApiVO.getCustomPortIds());
        aclPortVO.setStandardCustomPortIds(oswAclPortOpenApiVO.getStandardCustomPortIds());
        aclPortVO.setVrfId(oswAclPortOpenApiVO.getVrfId());
        aclPortVO.setVrf(oswAclPortOpenApiVO.getVrf());
        return aclPortVO;
    }

    @Generated
    public String getMac() {
        return this.mac;
    }

    @Generated
    public String getStackId() {
        return this.stackId;
    }

    @Generated
    public Set<Integer> getCustomPortIds() {
        return this.customPortIds;
    }

    @Generated
    public Set<String> getStandardCustomPortIds() {
        return this.standardCustomPortIds;
    }

    @Generated
    public Set<Integer> getCustomLagIds() {
        return this.customLagIds;
    }

    @Generated
    public String getVrfId() {
        return this.vrfId;
    }

    @Generated
    public String getVrf() {
        return this.vrf;
    }

    @Generated
    public void setMac(String mac) {
        this.mac = mac;
    }

    @Generated
    public void setStackId(String stackId) {
        this.stackId = stackId;
    }

    @Generated
    public void setCustomPortIds(Set<Integer> customPortIds) {
        this.customPortIds = customPortIds;
    }

    @Generated
    public void setStandardCustomPortIds(Set<String> standardCustomPortIds) {
        this.standardCustomPortIds = standardCustomPortIds;
    }

    @Generated
    public void setCustomLagIds(Set<Integer> customLagIds) {
        this.customLagIds = customLagIds;
    }

    @Generated
    public void setVrfId(String vrfId) {
        this.vrfId = vrfId;
    }

    @Generated
    public void setVrf(String vrf) {
        this.vrf = vrf;
    }

    @Generated
    public String toString() {
        return "OswAclPortOpenApiVO(mac=" + this.getMac() + ", stackId=" + this.getStackId() + ", customPortIds=" + this.getCustomPortIds() + ", standardCustomPortIds=" + this.getStandardCustomPortIds() + ", customLagIds=" + this.getCustomLagIds() + ", vrfId=" + this.getVrfId() + ", vrf=" + this.getVrf() + ")";
    }

    @Generated
    public OswAclPortOpenApiVO(String mac, String stackId, Set<Integer> customPortIds, Set<String> standardCustomPortIds, Set<Integer> customLagIds, String vrfId, String vrf) {
        this.mac = mac;
        this.stackId = stackId;
        this.customPortIds = customPortIds;
        this.standardCustomPortIds = standardCustomPortIds;
        this.customLagIds = customLagIds;
        this.vrfId = vrfId;
        this.vrf = vrf;
    }

    @Generated
    public OswAclPortOpenApiVO() {
    }
}

