/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting;

import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.AclOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.CustomAclOswOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.EtherTypeOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.OswAclPortOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.firewall.dto.AclVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;
import org.springframework.util.CollectionUtils;

@Schema(name="SwitchACLInfo")
public class OswAclOpenApiVO
extends AclOpenApiVO {
    @NotNull(message="sourceType must not be null")
    @Schema(name="sourceType", description="SourceType should be a value as follows: 0: network; 1: IP Group; 2: IP-Port Group; 4: SSID; 6: IPv6 Group; 7: IPv6-Port Group")
    @Range(min=0L, max=9L)
    private @NotNull(message="sourceType must not be null") @Range(min=0L, max=9L) Integer sourceType;
    @NotNull(message="destinationType must not be null")
    @Range(min=0L, max=10L)
    @Schema(name="destinationType", description="DestinationType should be a value as follows: 0: network; 1: IP Group; 2: IP-Port Group; 6: IPv6 Group; 7: IPv6-Port Group")
    private @NotNull(message="destinationType must not be null") @Range(min=0L, max=10L) Integer destinationType;
    @Range(min=0L, max=3L)
    @NotNull(message="bindingType must not be null")
    @Schema(name="bindingType", description="BindingType should be a value as follows: 0: all ports; 1: custom ports; 2: all switch vlan; 3: custom switch vlan")
    private @Range(min=0L, max=3L) @NotNull(message="bindingType must not be null") Integer bindingType;
    @Valid
    @Schema(name="customAclPorts", description="Only for bindingType is custom ports, select the custom port or LAG of the device")
    private List<OswAclPortOpenApiVO> customAclPorts;
    @Schema(name="networkId", description="Only for bindingType VLAN")
    private String networkId;
    @Schema(name="bindingBridgeVlan", description="Only for bindingType VLAN and network of bridge VLAN")
    private Integer bindingBridgeVlan;
    @Schema(name="customAclOsws", description="Only for bindingType is custom switch vlan, list of selected switch mac")
    private List<String> customAclOsws;
    @Schema(name="customAclStacks", description="Only for bindingType is custom switch vlan, list of selected stack id")
    private List<String> customAclStacks;
    @Schema(name="customAclDevices", description="Only for bindingType is custom switch vlan, list of selected device")
    private List<CustomAclOswOpenApiVO> customAclDevices;
    @Valid
    @NotNull
    @Schema(name="etherType", description="Ethertype(4-hex number; 0-9\uff0cA-F) is only editable when the Source Type and Destination Type are both selected as MAC Group in the Rule.")
    private EtherTypeOpenApiVO etherType;
    @Schema(name="timeRangeId", description="Time range profile ID")
    private String timeRangeId;

    public static OswAclOpenApiVO buildByWebVO(AclVO aclVO) {
        AclOpenApiVO oswAclOpenApiVO = ((OswAclOpenApiVOBuilder)((OswAclOpenApiVOBuilder)((OswAclOpenApiVOBuilder)((AclOpenApiVO.AclOpenApiVOBuilder)((OswAclOpenApiVOBuilder)((AclOpenApiVO.AclOpenApiVOBuilder)((OswAclOpenApiVOBuilder)((OswAclOpenApiVOBuilder)((OswAclOpenApiVOBuilder)((OswAclOpenApiVOBuilder)((OswAclOpenApiVOBuilder)((OswAclOpenApiVOBuilder)OswAclOpenApiVO.builder().id(aclVO.getId())).index(aclVO.getIndex())).description(aclVO.getName())).status(aclVO.getStatus())).policy(aclVO.getPolicy())).protocols(aclVO.getProtocols())).sourceType(aclVO.getSourceType())).sourceIds(aclVO.getSourceIds())).destinationType(aclVO.getDestinationType())).destinationIds(aclVO.getDestinationIds())).bindingType(aclVO.getBindingType())).timeRangeId(aclVO.getTimeRangeId())).build();
        if (aclVO.getEtherType() != null) {
            ((OswAclOpenApiVO)oswAclOpenApiVO).setEtherType(EtherTypeOpenApiVO.buildByWebVO(aclVO.getEtherType()));
        }
        if (((OswAclOpenApiVO)oswAclOpenApiVO).getBindingType() == 1 && !CollectionUtils.isEmpty((Collection)aclVO.getCustomAclPorts())) {
            ((OswAclOpenApiVO)oswAclOpenApiVO).setCustomAclPorts(aclVO.getCustomAclPorts().stream().map(OswAclPortOpenApiVO::buildByWebVO).collect(Collectors.toList()));
        }
        if (((OswAclOpenApiVO)oswAclOpenApiVO).getBindingType() == 2) {
            ((OswAclOpenApiVO)oswAclOpenApiVO).setNetworkId(aclVO.getNetworkId());
            ((OswAclOpenApiVO)oswAclOpenApiVO).setBindingBridgeVlan(aclVO.getBindingBridgeVlan());
        }
        if (((OswAclOpenApiVO)oswAclOpenApiVO).getBindingType() == 3) {
            ((OswAclOpenApiVO)oswAclOpenApiVO).setCustomAclOsws(aclVO.getCustomAclOsws());
            ((OswAclOpenApiVO)oswAclOpenApiVO).setCustomAclStacks(aclVO.getCustomAclStacks());
            if (!CollectionUtils.isEmpty((Collection)aclVO.getCustomAclDevices())) {
                ((OswAclOpenApiVO)oswAclOpenApiVO).setCustomAclDevices(aclVO.getCustomAclDevices().stream().map(CustomAclOswOpenApiVO::buildByWebVO).collect(Collectors.toList()));
            }
        }
        return oswAclOpenApiVO;
    }

    @Generated
    protected OswAclOpenApiVO(OswAclOpenApiVOBuilder<?, ?> b2) {
        super(b2);
        this.sourceType = b2.sourceType;
        this.destinationType = b2.destinationType;
        this.bindingType = b2.bindingType;
        this.customAclPorts = b2.customAclPorts;
        this.networkId = b2.networkId;
        this.bindingBridgeVlan = b2.bindingBridgeVlan;
        this.customAclOsws = b2.customAclOsws;
        this.customAclStacks = b2.customAclStacks;
        this.customAclDevices = b2.customAclDevices;
        this.etherType = b2.etherType;
        this.timeRangeId = b2.timeRangeId;
    }

    @Generated
    public static OswAclOpenApiVOBuilder<?, ?> builder() {
        return new OswAclOpenApiVOBuilderImpl();
    }

    @Generated
    public Integer getSourceType() {
        return this.sourceType;
    }

    @Generated
    public Integer getDestinationType() {
        return this.destinationType;
    }

    @Generated
    public Integer getBindingType() {
        return this.bindingType;
    }

    @Generated
    public List<OswAclPortOpenApiVO> getCustomAclPorts() {
        return this.customAclPorts;
    }

    @Generated
    public String getNetworkId() {
        return this.networkId;
    }

    @Generated
    public Integer getBindingBridgeVlan() {
        return this.bindingBridgeVlan;
    }

    @Generated
    public List<String> getCustomAclOsws() {
        return this.customAclOsws;
    }

    @Generated
    public List<String> getCustomAclStacks() {
        return this.customAclStacks;
    }

    @Generated
    public List<CustomAclOswOpenApiVO> getCustomAclDevices() {
        return this.customAclDevices;
    }

    @Generated
    public EtherTypeOpenApiVO getEtherType() {
        return this.etherType;
    }

    @Generated
    public String getTimeRangeId() {
        return this.timeRangeId;
    }

    @Generated
    public OswAclOpenApiVO setSourceType(Integer sourceType) {
        this.sourceType = sourceType;
        return this;
    }

    @Generated
    public OswAclOpenApiVO setDestinationType(Integer destinationType) {
        this.destinationType = destinationType;
        return this;
    }

    @Generated
    public OswAclOpenApiVO setBindingType(Integer bindingType) {
        this.bindingType = bindingType;
        return this;
    }

    @Generated
    public OswAclOpenApiVO setCustomAclPorts(List<OswAclPortOpenApiVO> customAclPorts) {
        this.customAclPorts = customAclPorts;
        return this;
    }

    @Generated
    public OswAclOpenApiVO setNetworkId(String networkId) {
        this.networkId = networkId;
        return this;
    }

    @Generated
    public OswAclOpenApiVO setBindingBridgeVlan(Integer bindingBridgeVlan) {
        this.bindingBridgeVlan = bindingBridgeVlan;
        return this;
    }

    @Generated
    public OswAclOpenApiVO setCustomAclOsws(List<String> customAclOsws) {
        this.customAclOsws = customAclOsws;
        return this;
    }

    @Generated
    public OswAclOpenApiVO setCustomAclStacks(List<String> customAclStacks) {
        this.customAclStacks = customAclStacks;
        return this;
    }

    @Generated
    public OswAclOpenApiVO setCustomAclDevices(List<CustomAclOswOpenApiVO> customAclDevices) {
        this.customAclDevices = customAclDevices;
        return this;
    }

    @Generated
    public OswAclOpenApiVO setEtherType(EtherTypeOpenApiVO etherType) {
        this.etherType = etherType;
        return this;
    }

    @Generated
    public OswAclOpenApiVO setTimeRangeId(String timeRangeId) {
        this.timeRangeId = timeRangeId;
        return this;
    }

    @Override
    @Generated
    public String toString() {
        return "OswAclOpenApiVO(sourceType=" + this.getSourceType() + ", destinationType=" + this.getDestinationType() + ", bindingType=" + this.getBindingType() + ", customAclPorts=" + this.getCustomAclPorts() + ", networkId=" + this.getNetworkId() + ", bindingBridgeVlan=" + this.getBindingBridgeVlan() + ", customAclOsws=" + this.getCustomAclOsws() + ", customAclStacks=" + this.getCustomAclStacks() + ", customAclDevices=" + this.getCustomAclDevices() + ", etherType=" + this.getEtherType() + ", timeRangeId=" + this.getTimeRangeId() + ")";
    }

    @Generated
    public OswAclOpenApiVO(Integer sourceType, Integer destinationType, Integer bindingType, List<OswAclPortOpenApiVO> customAclPorts, String networkId, Integer bindingBridgeVlan, List<String> customAclOsws, List<String> customAclStacks, List<CustomAclOswOpenApiVO> customAclDevices, EtherTypeOpenApiVO etherType, String timeRangeId) {
        this.sourceType = sourceType;
        this.destinationType = destinationType;
        this.bindingType = bindingType;
        this.customAclPorts = customAclPorts;
        this.networkId = networkId;
        this.bindingBridgeVlan = bindingBridgeVlan;
        this.customAclOsws = customAclOsws;
        this.customAclStacks = customAclStacks;
        this.customAclDevices = customAclDevices;
        this.etherType = etherType;
        this.timeRangeId = timeRangeId;
    }

    @Generated
    public OswAclOpenApiVO() {
    }

    @Generated
    public static abstract class OswAclOpenApiVOBuilder<C extends OswAclOpenApiVO, B extends OswAclOpenApiVOBuilder<C, B>>
    extends AclOpenApiVO.AclOpenApiVOBuilder<C, B> {
        @Generated
        private Integer sourceType;
        @Generated
        private Integer destinationType;
        @Generated
        private Integer bindingType;
        @Generated
        private List<OswAclPortOpenApiVO> customAclPorts;
        @Generated
        private String networkId;
        @Generated
        private Integer bindingBridgeVlan;
        @Generated
        private List<String> customAclOsws;
        @Generated
        private List<String> customAclStacks;
        @Generated
        private List<CustomAclOswOpenApiVO> customAclDevices;
        @Generated
        private EtherTypeOpenApiVO etherType;
        @Generated
        private String timeRangeId;

        @Generated
        public B sourceType(Integer sourceType) {
            this.sourceType = sourceType;
            return (B)this.self();
        }

        @Generated
        public B destinationType(Integer destinationType) {
            this.destinationType = destinationType;
            return (B)this.self();
        }

        @Generated
        public B bindingType(Integer bindingType) {
            this.bindingType = bindingType;
            return (B)this.self();
        }

        @Generated
        public B customAclPorts(List<OswAclPortOpenApiVO> customAclPorts) {
            this.customAclPorts = customAclPorts;
            return (B)this.self();
        }

        @Generated
        public B networkId(String networkId) {
            this.networkId = networkId;
            return (B)this.self();
        }

        @Generated
        public B bindingBridgeVlan(Integer bindingBridgeVlan) {
            this.bindingBridgeVlan = bindingBridgeVlan;
            return (B)this.self();
        }

        @Generated
        public B customAclOsws(List<String> customAclOsws) {
            this.customAclOsws = customAclOsws;
            return (B)this.self();
        }

        @Generated
        public B customAclStacks(List<String> customAclStacks) {
            this.customAclStacks = customAclStacks;
            return (B)this.self();
        }

        @Generated
        public B customAclDevices(List<CustomAclOswOpenApiVO> customAclDevices) {
            this.customAclDevices = customAclDevices;
            return (B)this.self();
        }

        @Generated
        public B etherType(EtherTypeOpenApiVO etherType) {
            this.etherType = etherType;
            return (B)this.self();
        }

        @Generated
        public B timeRangeId(String timeRangeId) {
            this.timeRangeId = timeRangeId;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "OswAclOpenApiVO.OswAclOpenApiVOBuilder(super=" + super.toString() + ", sourceType=" + this.sourceType + ", destinationType=" + this.destinationType + ", bindingType=" + this.bindingType + ", customAclPorts=" + this.customAclPorts + ", networkId=" + this.networkId + ", bindingBridgeVlan=" + this.bindingBridgeVlan + ", customAclOsws=" + this.customAclOsws + ", customAclStacks=" + this.customAclStacks + ", customAclDevices=" + this.customAclDevices + ", etherType=" + this.etherType + ", timeRangeId=" + this.timeRangeId + ")";
        }
    }

    @Generated
    private static final class OswAclOpenApiVOBuilderImpl
    extends OswAclOpenApiVOBuilder<OswAclOpenApiVO, OswAclOpenApiVOBuilderImpl> {
        @Generated
        private OswAclOpenApiVOBuilderImpl() {
        }

        @Override
        @Generated
        protected OswAclOpenApiVOBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public OswAclOpenApiVO build() {
            return new OswAclOpenApiVO(this);
        }
    }
}

