/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting;

import com.tplink.smb.omada.manager.configuration.api.web.site.firewall.dto.OsgCustomAclVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;

@Schema(name="Gateway Custom ACL modify entity")
public class OsgCustomAclModifyOpenApiVO {
    @Schema(name="id", description="Custom ACL ID")
    @NotNull(message="Custom ACL ID must not be null")
    private @NotNull(message="Custom ACL ID must not be null") String id;
    @Schema(name="index", description="Custom ACL index")
    @NotNull
    @Range(min=1L, max=65535L, message="Valid index should be within the range of 1\u201365535")
    private @NotNull @Range(min=1L, max=65535L, message="Valid index should be within the range of 1\u201365535") Integer index;
    @Schema(name="status", description="Custom ACL status")
    @NotNull
    private Boolean status;
    @Schema(name="description", description="Custom ACL description should contain 1 to 512 characters.")
    @NotNull(message="description must not be null.")
    @Pattern(regexp="^[^ ]$|^[^ ].{0,510}[^ ]$", message="Parameter [description] should be 1 ~ 512 characters.")
    private @NotNull(message="description must not be null.") @Pattern(regexp="^[^ ]$|^[^ ].{0,510}[^ ]$", message="Parameter [description] should be 1 ~ 512 characters.") String description;
    @Schema(name="direction", description="Custom ACL direction should be a value as follows: 0: LAN-LAN; 1: LAN-WAN; 2: WAN-LAN; 3: LOCAL IN")
    @NotNull(message="direction must not be null.")
    private @NotNull(message="direction must not be null.") Integer direction;
    @Schema(name="policy", description="Custom ACL policy should be a value as follows: 0: Drop; 1:Allow")
    @NotNull(message="policy must not be null")
    @Range(min=0L, max=1L)
    private @NotNull(message="policy must not be null") @Range(min=0L, max=1L) Integer policy;
    @Schema(name="protocol", description="Custom ACL protocol. For the values of protocol, refer to section 5.5 of the Open API Access Guide.")
    @NotNull(message="protocol must not be null.")
    private @NotNull(message="protocol must not be null.") Integer protocol;
    @Schema(name="sourceList", description="Custom ACL source list.")
    @NotNull(message="sourceList must not be null.")
    private @NotNull(message="sourceList must not be null.") List<String> sourceList;
    @Schema(name="sourcePort", description="Custom ACL source port. when \"protocol\" is \"TCP\" or \"UDP\", port is valid.")
    private String sourcePort;
    @Schema(name="destinationList", description="Custom ACL destination list.")
    @NotNull(message="destinationList must not be null.")
    private @NotNull(message="destinationList must not be null.") List<String> destinationList;
    @Schema(name="destinationPort", description="Custom ACL destination port. when \"protocol\" is \"TCP\" or \"UDP\", port is valid.")
    private String destinationPort;
    @Schema(name="logStatus", description="Custom ACL log status")
    @NotNull(message="logStatus must not be null.")
    private @NotNull(message="logStatus must not be null.") Boolean logStatus;

    public static OsgCustomAclVO toWebVO(String omadacId, String siteId, OsgCustomAclModifyOpenApiVO openApiVO) {
        if (Objects.isNull(openApiVO)) {
            return null;
        }
        OsgCustomAclVO webVO = new OsgCustomAclVO();
        webVO.setId(openApiVO.getId());
        webVO.setOmadacId(omadacId);
        webVO.setSiteId(siteId);
        webVO.setIndex(openApiVO.getIndex());
        webVO.setStatus(openApiVO.getStatus());
        webVO.setDescription(openApiVO.getDescription());
        ArrayList<Integer> directions = new ArrayList<Integer>();
        if (Objects.nonNull(openApiVO.getDirection())) {
            directions.add(openApiVO.getDirection());
        }
        webVO.setDirections(directions);
        webVO.setPolicy(openApiVO.getPolicy());
        ArrayList<Integer> protocols = new ArrayList<Integer>();
        if (Objects.nonNull(openApiVO.getProtocol())) {
            protocols.add(openApiVO.getProtocol());
        }
        webVO.setProtocols(protocols);
        webVO.setSourceList(openApiVO.getSourceList());
        webVO.setSourcePort(openApiVO.getSourcePort());
        webVO.setDestinationList(openApiVO.getDestinationList());
        webVO.setDestinationPort(openApiVO.getDestinationPort());
        webVO.setLogStatus(openApiVO.getLogStatus());
        return webVO;
    }

    @Generated
    protected OsgCustomAclModifyOpenApiVO(OsgCustomAclModifyOpenApiVOBuilder<?, ?> b2) {
        this.id = b2.id;
        this.index = b2.index;
        this.status = b2.status;
        this.description = b2.description;
        this.direction = b2.direction;
        this.policy = b2.policy;
        this.protocol = b2.protocol;
        this.sourceList = b2.sourceList;
        this.sourcePort = b2.sourcePort;
        this.destinationList = b2.destinationList;
        this.destinationPort = b2.destinationPort;
        this.logStatus = b2.logStatus;
    }

    @Generated
    public static OsgCustomAclModifyOpenApiVOBuilder<?, ?> builder() {
        return new OsgCustomAclModifyOpenApiVOBuilderImpl();
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public Integer getIndex() {
        return this.index;
    }

    @Generated
    public Boolean getStatus() {
        return this.status;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public Integer getDirection() {
        return this.direction;
    }

    @Generated
    public Integer getPolicy() {
        return this.policy;
    }

    @Generated
    public Integer getProtocol() {
        return this.protocol;
    }

    @Generated
    public List<String> getSourceList() {
        return this.sourceList;
    }

    @Generated
    public String getSourcePort() {
        return this.sourcePort;
    }

    @Generated
    public List<String> getDestinationList() {
        return this.destinationList;
    }

    @Generated
    public String getDestinationPort() {
        return this.destinationPort;
    }

    @Generated
    public Boolean getLogStatus() {
        return this.logStatus;
    }

    @Generated
    public OsgCustomAclModifyOpenApiVO setId(String id) {
        this.id = id;
        return this;
    }

    @Generated
    public OsgCustomAclModifyOpenApiVO setIndex(Integer index) {
        this.index = index;
        return this;
    }

    @Generated
    public OsgCustomAclModifyOpenApiVO setStatus(Boolean status) {
        this.status = status;
        return this;
    }

    @Generated
    public OsgCustomAclModifyOpenApiVO setDescription(String description) {
        this.description = description;
        return this;
    }

    @Generated
    public OsgCustomAclModifyOpenApiVO setDirection(Integer direction) {
        this.direction = direction;
        return this;
    }

    @Generated
    public OsgCustomAclModifyOpenApiVO setPolicy(Integer policy) {
        this.policy = policy;
        return this;
    }

    @Generated
    public OsgCustomAclModifyOpenApiVO setProtocol(Integer protocol) {
        this.protocol = protocol;
        return this;
    }

    @Generated
    public OsgCustomAclModifyOpenApiVO setSourceList(List<String> sourceList) {
        this.sourceList = sourceList;
        return this;
    }

    @Generated
    public OsgCustomAclModifyOpenApiVO setSourcePort(String sourcePort) {
        this.sourcePort = sourcePort;
        return this;
    }

    @Generated
    public OsgCustomAclModifyOpenApiVO setDestinationList(List<String> destinationList) {
        this.destinationList = destinationList;
        return this;
    }

    @Generated
    public OsgCustomAclModifyOpenApiVO setDestinationPort(String destinationPort) {
        this.destinationPort = destinationPort;
        return this;
    }

    @Generated
    public OsgCustomAclModifyOpenApiVO setLogStatus(Boolean logStatus) {
        this.logStatus = logStatus;
        return this;
    }

    @Generated
    public String toString() {
        return "OsgCustomAclModifyOpenApiVO(id=" + this.getId() + ", index=" + this.getIndex() + ", status=" + this.getStatus() + ", description=" + this.getDescription() + ", direction=" + this.getDirection() + ", policy=" + this.getPolicy() + ", protocol=" + this.getProtocol() + ", sourceList=" + this.getSourceList() + ", sourcePort=" + this.getSourcePort() + ", destinationList=" + this.getDestinationList() + ", destinationPort=" + this.getDestinationPort() + ", logStatus=" + this.getLogStatus() + ")";
    }

    @Generated
    public OsgCustomAclModifyOpenApiVO(String id, Integer index, Boolean status, String description, Integer direction, Integer policy, Integer protocol, List<String> sourceList, String sourcePort, List<String> destinationList, String destinationPort, Boolean logStatus) {
        this.id = id;
        this.index = index;
        this.status = status;
        this.description = description;
        this.direction = direction;
        this.policy = policy;
        this.protocol = protocol;
        this.sourceList = sourceList;
        this.sourcePort = sourcePort;
        this.destinationList = destinationList;
        this.destinationPort = destinationPort;
        this.logStatus = logStatus;
    }

    @Generated
    public OsgCustomAclModifyOpenApiVO() {
    }

    @Generated
    public static abstract class OsgCustomAclModifyOpenApiVOBuilder<C extends OsgCustomAclModifyOpenApiVO, B extends OsgCustomAclModifyOpenApiVOBuilder<C, B>> {
        @Generated
        private String id;
        @Generated
        private Integer index;
        @Generated
        private Boolean status;
        @Generated
        private String description;
        @Generated
        private Integer direction;
        @Generated
        private Integer policy;
        @Generated
        private Integer protocol;
        @Generated
        private List<String> sourceList;
        @Generated
        private String sourcePort;
        @Generated
        private List<String> destinationList;
        @Generated
        private String destinationPort;
        @Generated
        private Boolean logStatus;

        @Generated
        public B id(String id) {
            this.id = id;
            return this.self();
        }

        @Generated
        public B index(Integer index) {
            this.index = index;
            return this.self();
        }

        @Generated
        public B status(Boolean status) {
            this.status = status;
            return this.self();
        }

        @Generated
        public B description(String description) {
            this.description = description;
            return this.self();
        }

        @Generated
        public B direction(Integer direction) {
            this.direction = direction;
            return this.self();
        }

        @Generated
        public B policy(Integer policy) {
            this.policy = policy;
            return this.self();
        }

        @Generated
        public B protocol(Integer protocol) {
            this.protocol = protocol;
            return this.self();
        }

        @Generated
        public B sourceList(List<String> sourceList) {
            this.sourceList = sourceList;
            return this.self();
        }

        @Generated
        public B sourcePort(String sourcePort) {
            this.sourcePort = sourcePort;
            return this.self();
        }

        @Generated
        public B destinationList(List<String> destinationList) {
            this.destinationList = destinationList;
            return this.self();
        }

        @Generated
        public B destinationPort(String destinationPort) {
            this.destinationPort = destinationPort;
            return this.self();
        }

        @Generated
        public B logStatus(Boolean logStatus) {
            this.logStatus = logStatus;
            return this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "OsgCustomAclModifyOpenApiVO.OsgCustomAclModifyOpenApiVOBuilder(id=" + this.id + ", index=" + this.index + ", status=" + this.status + ", description=" + this.description + ", direction=" + this.direction + ", policy=" + this.policy + ", protocol=" + this.protocol + ", sourceList=" + this.sourceList + ", sourcePort=" + this.sourcePort + ", destinationList=" + this.destinationList + ", destinationPort=" + this.destinationPort + ", logStatus=" + this.logStatus + ")";
        }
    }

    @Generated
    private static final class OsgCustomAclModifyOpenApiVOBuilderImpl
    extends OsgCustomAclModifyOpenApiVOBuilder<OsgCustomAclModifyOpenApiVO, OsgCustomAclModifyOpenApiVOBuilderImpl> {
        @Generated
        private OsgCustomAclModifyOpenApiVOBuilderImpl() {
        }

        @Override
        @Generated
        protected OsgCustomAclModifyOpenApiVOBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public OsgCustomAclModifyOpenApiVO build() {
            return new OsgCustomAclModifyOpenApiVO(this);
        }
    }
}

