/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting;

import com.tplink.smb.omada.manager.configuration.api.web.site.sitesetting.dto.RoamingSettingVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;

public class NewRoamingSettingOpenApiVO {
    @Schema(name="fastRoamingEnable", description="Whether to enable fast roaming")
    @NotNull(message="RoamingSetting parameter [fasterRoamingEnable] should not be null")
    private @NotNull(message="RoamingSetting parameter [fasterRoamingEnable] should not be null") Boolean fastRoamingEnable;
    @Schema(name="aiRoamingEnable", description="Whether to enable AI roaming, this configuration will take effect only when fast roaming is enabled")
    @NotNull(message="RoamingSetting parameter [aiRoamingEnable] should not be null")
    private @NotNull(message="RoamingSetting parameter [aiRoamingEnable] should not be null") Boolean aiRoamingEnable;
    @Schema(name="nonStickRoamingEnable", description="Whether to enable non-stick roaming")
    private Boolean nonStickRoamingEnable;
    @Schema(name="nonPingPongRoamingEnable", description="Whether to enable non-ping-pong roaming")
    private Boolean nonPingPongRoamingEnable;
    @Schema(name="pingPongAssocThreshold", description="Association frequency threshold of ping-pong roaming")
    @Range(min=2L, max=10L)
    private @Range(min=2L, max=10L) Integer pingPongAssocThreshold;

    public static RoamingSettingVO toWebVO(NewRoamingSettingOpenApiVO openApiVO) {
        if (openApiVO == null) {
            return null;
        }
        RoamingSettingVO vo = new RoamingSettingVO();
        vo.setFastRoamingEnable(openApiVO.getFastRoamingEnable());
        vo.setAiRoamingEnable(openApiVO.getAiRoamingEnable());
        vo.setNonStickRoamingEnable(openApiVO.getNonStickRoamingEnable());
        vo.setNonPingPongRoamingEnable(openApiVO.getNonPingPongRoamingEnable());
        vo.setPingPongAssocThreshold(openApiVO.getPingPongAssocThreshold());
        return vo;
    }

    public static NewRoamingSettingOpenApiVO fromWebVO(RoamingSettingVO webVO) {
        if (webVO == null) {
            return null;
        }
        NewRoamingSettingOpenApiVO newRoamingSettingOpenApiVO = new NewRoamingSettingOpenApiVO();
        newRoamingSettingOpenApiVO.setFastRoamingEnable(webVO.getFastRoamingEnable());
        newRoamingSettingOpenApiVO.setAiRoamingEnable(webVO.getAiRoamingEnable());
        newRoamingSettingOpenApiVO.setNonStickRoamingEnable(webVO.getNonStickRoamingEnable());
        newRoamingSettingOpenApiVO.setNonPingPongRoamingEnable(webVO.getNonPingPongRoamingEnable());
        newRoamingSettingOpenApiVO.setPingPongAssocThreshold(webVO.getPingPongAssocThreshold());
        return newRoamingSettingOpenApiVO;
    }

    @Generated
    public Boolean getFastRoamingEnable() {
        return this.fastRoamingEnable;
    }

    @Generated
    public Boolean getAiRoamingEnable() {
        return this.aiRoamingEnable;
    }

    @Generated
    public Boolean getNonStickRoamingEnable() {
        return this.nonStickRoamingEnable;
    }

    @Generated
    public Boolean getNonPingPongRoamingEnable() {
        return this.nonPingPongRoamingEnable;
    }

    @Generated
    public Integer getPingPongAssocThreshold() {
        return this.pingPongAssocThreshold;
    }

    @Generated
    public void setFastRoamingEnable(Boolean fastRoamingEnable) {
        this.fastRoamingEnable = fastRoamingEnable;
    }

    @Generated
    public void setAiRoamingEnable(Boolean aiRoamingEnable) {
        this.aiRoamingEnable = aiRoamingEnable;
    }

    @Generated
    public void setNonStickRoamingEnable(Boolean nonStickRoamingEnable) {
        this.nonStickRoamingEnable = nonStickRoamingEnable;
    }

    @Generated
    public void setNonPingPongRoamingEnable(Boolean nonPingPongRoamingEnable) {
        this.nonPingPongRoamingEnable = nonPingPongRoamingEnable;
    }

    @Generated
    public void setPingPongAssocThreshold(Integer pingPongAssocThreshold) {
        this.pingPongAssocThreshold = pingPongAssocThreshold;
    }

    @Generated
    public NewRoamingSettingOpenApiVO() {
    }

    @Generated
    public NewRoamingSettingOpenApiVO(Boolean fastRoamingEnable, Boolean aiRoamingEnable, Boolean nonStickRoamingEnable, Boolean nonPingPongRoamingEnable, Integer pingPongAssocThreshold) {
        this.fastRoamingEnable = fastRoamingEnable;
        this.aiRoamingEnable = aiRoamingEnable;
        this.nonStickRoamingEnable = nonStickRoamingEnable;
        this.nonPingPongRoamingEnable = nonPingPongRoamingEnable;
        this.pingPongAssocThreshold = pingPongAssocThreshold;
    }

    @Generated
    public String toString() {
        return "NewRoamingSettingOpenApiVO(fastRoamingEnable=" + this.getFastRoamingEnable() + ", aiRoamingEnable=" + this.getAiRoamingEnable() + ", nonStickRoamingEnable=" + this.getNonStickRoamingEnable() + ", nonPingPongRoamingEnable=" + this.getNonPingPongRoamingEnable() + ", pingPongAssocThreshold=" + this.getPingPongAssocThreshold() + ")";
    }
}

