/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting;

import com.tplink.smb.omada.manager.configuration.api.web.site.wired.lanprofile.BandCtrlVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.wired.lanprofile.DhcpL2RelayVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.wired.lanprofile.LanProfileVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.wired.lanprofile.StormCtrlVO;
import com.tplink.smb.omada.manager.device.api.web.osw.dto.SpanningTreeSettingVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;

public class LanProfileOpenApiVO {
    @Schema(name="id", description="LAN profile ID")
    private String id;
    @Schema(name="flag", description="Flag should be a value as follows: 0: default(all,disable,LAN), 1: native(generated by creating LAN network), 2: customize(created by users)")
    private Integer flag;
    @NotNull
    @Pattern(regexp="^[^ ]$|^[^ ].{0,126}[^ ]$", message="Parameter [name] should be between 1 and 128 characters.")
    @Schema(name="name", description="Name should contain 1 to 128 characters.")
    private @NotNull @Pattern(regexp="^[^ ]$|^[^ ].{0,126}[^ ]$", message="Parameter [name] should be between 1 and 128 characters.") String name;
    @NotNull
    @Range(min=0L, max=2L, message="Parameter [poe] should be within the range of {min}-{max}.")
    @Schema(name="poe", description="PoE should be a value as follows: 0: on, 1: off, 2: \"do not modify\"")
    private @NotNull @Range(min=0L, max=2L, message="Parameter [poe] should be within the range of {min}-{max}.") Integer poe;
    @Schema(name="nativeNetworkId", description="Native network ID, Native Network cannot be selected from Tagged Networks or Untagged Networks.")
    private String nativeNetworkId;
    @Schema(name="tagNetworkIds", description="Tag network IDs")
    private List<String> tagNetworkIds;
    @Schema(name="untagNetworkIds", description="Untag network IDs")
    private List<String> untagNetworkIds;
    @Schema(name="voiceNetworkId", description="Voice Network ID")
    private String voiceNetworkId;
    @NotNull
    @Range(min=0L, max=2L, message="Parameter [dot1x] should be within the range of {min}-{max}.")
    @Schema(name="dot1x", description="Dot1x should be a value as follows: 0: force unauthorized, 1: force authorized, 2:auto")
    private @NotNull @Range(min=0L, max=2L, message="Parameter [dot1x] should be within the range of {min}-{max}.") Integer dot1x;
    @NotNull
    @Schema(name="portIsolationEnable", description="Port-isolation enable status")
    private Boolean portIsolationEnable;
    @NotNull
    @Schema(name="lldpMedEnable", description="LLDP-MED enable status")
    private Boolean lldpMedEnable;
    @Schema(name="topoNotifyEnable", description="TopoNotify enable status")
    private Boolean topoNotifyEnable;
    @NotNull
    @Range(min=0L, max=2L, message="Parameter [bandWidthCtrlType] should be within the range of {min}-{max}")
    @Schema(name="bandWidthCtrlType", description="BandWidthCtrlType should be a value as follows: 0: off, 1: rate limit, 2: storming control")
    private @NotNull @Range(min=0L, max=2L, message="Parameter [bandWidthCtrlType] should be within the range of {min}-{max}") Integer bandWidthCtrlType;
    @Valid
    @Schema(name="stormCtrl", description="StormCtrl")
    private StormCtrlVO stormCtrl;
    @Valid
    @Schema(name="bandCtrl", description="BandCtrl")
    private BandCtrlVO bandCtrl;
    @NotNull
    @Schema(name="spanningTreeEnable", description="SpanningTree enable status")
    private Boolean spanningTreeEnable;
    @Valid
    @Schema(name="spanningTreeSetting", description="SpanningTree Settings")
    private SpanningTreeSettingVO spanningTreeSetting;
    @NotNull
    @Schema(name="loopbackDetectEnable", description="LoopbackDetect enable status")
    private Boolean loopbackDetectEnable;
    @Schema(name="eeeEnable", description="EEE enable status")
    private Boolean eeeEnable;
    @Schema(name="flowControlEnable", description="FlowControl enable status")
    private Boolean flowControlEnable;
    @Schema(name="loopbackDetectVlanBasedEnable", description="LoopbackDetectVLANBased enable status")
    private Boolean loopbackDetectVlanBasedEnable;
    @Schema(name="igmpFastLeaveEnable", description="Indicates whether igmp fast leave is enabled")
    private Boolean igmpFastLeaveEnable;
    @Schema(name="mldFastLeaveEnable", description="Indicates whether mld fast leave is enabled")
    private Boolean mldFastLeaveEnable;
    @Schema(name="dhcpL2RelaySettings", description="DHCPL2Relay Settings")
    private DhcpL2RelayVO dhcpL2RelaySettings;
    @Schema(name="fastLeaveEnable", description="IGMP Snooping fast leave enable status")
    private Boolean fastLeaveEnable;
    @Range(min=0L, max=7L, message="Parameter [dot1pPriority] should be within the range of {min}-{max}")
    @Schema(name="dot1pPriority", description="802.1p Priority")
    private @Range(min=0L, max=7L, message="Parameter [dot1pPriority] should be within the range of {min}-{max}") Integer dot1pPriority;
    @Range(min=0L, max=2L, message="Parameter [trustMode] should be within the range of {min}-{max}")
    @Schema(name="trustMode", description="Trust mode")
    private @Range(min=0L, max=2L, message="Parameter [trustMode] should be within the range of {min}-{max}") Integer trustMode;
    @Schema(name="type", description="Type should be a value as follows: 0: LAN profile-ALL, 1: LAN profile-Disable, 2: LAN Profile except ALL and Disable")
    private Integer type;
    @Schema(name="supportESEnable", description="Agile Series Switch enable status. The default value is false")
    private Boolean supportESEnable;
    @Schema(name="networkConflict", description="Indicates whether the VLAN configuration in the Profile is inconsistent with the VLAN configuration that is effective for the bound port.")
    private Boolean networkConflict;

    public static LanProfileOpenApiVO buildByDeviceVO(LanProfileVO vo) {
        LanProfileOpenApiVO lanProfileOpenApiVO = new LanProfileOpenApiVO();
        lanProfileOpenApiVO.setId(vo.getId());
        lanProfileOpenApiVO.setFlag(vo.getFlag());
        lanProfileOpenApiVO.setName(vo.getName());
        lanProfileOpenApiVO.setPoe(vo.getPoe());
        lanProfileOpenApiVO.setNativeNetworkId(vo.getNativeNetworkId());
        lanProfileOpenApiVO.setTagNetworkIds(vo.getTagNetworkIds());
        lanProfileOpenApiVO.setUntagNetworkIds(vo.getUntagNetworkIds());
        lanProfileOpenApiVO.setVoiceNetworkId(vo.getVoiceNetworkId());
        lanProfileOpenApiVO.setDot1x(vo.getDot1x());
        lanProfileOpenApiVO.setPortIsolationEnable(vo.getPortIsolationEnable());
        lanProfileOpenApiVO.setLldpMedEnable(vo.getLldpMedEnable());
        lanProfileOpenApiVO.setTopoNotifyEnable(vo.getTopoNotifyEnable());
        lanProfileOpenApiVO.setBandWidthCtrlType(vo.getBandWidthCtrlType());
        lanProfileOpenApiVO.setSpanningTreeEnable(vo.getSpanningTreeEnable());
        lanProfileOpenApiVO.setSpanningTreeSetting(vo.getSpanningTreeSetting());
        lanProfileOpenApiVO.setLoopbackDetectEnable(vo.getLoopbackDetectEnable());
        lanProfileOpenApiVO.setEeeEnable(vo.getEeeEnable());
        lanProfileOpenApiVO.setFlowControlEnable(vo.getFlowControlEnable());
        lanProfileOpenApiVO.setLoopbackDetectVlanBasedEnable(vo.getLoopbackDetectVlanBasedEnable());
        lanProfileOpenApiVO.setIgmpFastLeaveEnable(vo.getIgmpFastLeaveEnable());
        lanProfileOpenApiVO.setMldFastLeaveEnable(vo.getMldFastLeaveEnable());
        lanProfileOpenApiVO.setType(vo.getType());
        lanProfileOpenApiVO.setSupportESEnable(vo.getSupportESEnable());
        lanProfileOpenApiVO.setFastLeaveEnable(vo.getFastLeaveEnable());
        lanProfileOpenApiVO.setDot1pPriority(vo.getDot1pPriority());
        lanProfileOpenApiVO.setNetworkConflict(vo.getNetworkConflict());
        lanProfileOpenApiVO.setTrustMode(vo.getTrustMode());
        if (!Objects.isNull(vo.getStormCtrl())) {
            lanProfileOpenApiVO.setStormCtrl(vo.getStormCtrl());
        }
        if (!Objects.isNull(vo.getBandCtrl())) {
            lanProfileOpenApiVO.setBandCtrl(vo.getBandCtrl());
        }
        if (!Objects.isNull(vo.getDhcpL2RelaySettings())) {
            lanProfileOpenApiVO.setDhcpL2RelaySettings(vo.getDhcpL2RelaySettings());
        }
        return lanProfileOpenApiVO;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public Integer getFlag() {
        return this.flag;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Integer getPoe() {
        return this.poe;
    }

    @Generated
    public String getNativeNetworkId() {
        return this.nativeNetworkId;
    }

    @Generated
    public List<String> getTagNetworkIds() {
        return this.tagNetworkIds;
    }

    @Generated
    public List<String> getUntagNetworkIds() {
        return this.untagNetworkIds;
    }

    @Generated
    public String getVoiceNetworkId() {
        return this.voiceNetworkId;
    }

    @Generated
    public Integer getDot1x() {
        return this.dot1x;
    }

    @Generated
    public Boolean getPortIsolationEnable() {
        return this.portIsolationEnable;
    }

    @Generated
    public Boolean getLldpMedEnable() {
        return this.lldpMedEnable;
    }

    @Generated
    public Boolean getTopoNotifyEnable() {
        return this.topoNotifyEnable;
    }

    @Generated
    public Integer getBandWidthCtrlType() {
        return this.bandWidthCtrlType;
    }

    @Generated
    public StormCtrlVO getStormCtrl() {
        return this.stormCtrl;
    }

    @Generated
    public BandCtrlVO getBandCtrl() {
        return this.bandCtrl;
    }

    @Generated
    public Boolean getSpanningTreeEnable() {
        return this.spanningTreeEnable;
    }

    @Generated
    public SpanningTreeSettingVO getSpanningTreeSetting() {
        return this.spanningTreeSetting;
    }

    @Generated
    public Boolean getLoopbackDetectEnable() {
        return this.loopbackDetectEnable;
    }

    @Generated
    public Boolean getEeeEnable() {
        return this.eeeEnable;
    }

    @Generated
    public Boolean getFlowControlEnable() {
        return this.flowControlEnable;
    }

    @Generated
    public Boolean getLoopbackDetectVlanBasedEnable() {
        return this.loopbackDetectVlanBasedEnable;
    }

    @Generated
    public Boolean getIgmpFastLeaveEnable() {
        return this.igmpFastLeaveEnable;
    }

    @Generated
    public Boolean getMldFastLeaveEnable() {
        return this.mldFastLeaveEnable;
    }

    @Generated
    public DhcpL2RelayVO getDhcpL2RelaySettings() {
        return this.dhcpL2RelaySettings;
    }

    @Generated
    public Boolean getFastLeaveEnable() {
        return this.fastLeaveEnable;
    }

    @Generated
    public Integer getDot1pPriority() {
        return this.dot1pPriority;
    }

    @Generated
    public Integer getTrustMode() {
        return this.trustMode;
    }

    @Generated
    public Integer getType() {
        return this.type;
    }

    @Generated
    public Boolean getSupportESEnable() {
        return this.supportESEnable;
    }

    @Generated
    public Boolean getNetworkConflict() {
        return this.networkConflict;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setFlag(Integer flag) {
        this.flag = flag;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setPoe(Integer poe) {
        this.poe = poe;
    }

    @Generated
    public void setNativeNetworkId(String nativeNetworkId) {
        this.nativeNetworkId = nativeNetworkId;
    }

    @Generated
    public void setTagNetworkIds(List<String> tagNetworkIds) {
        this.tagNetworkIds = tagNetworkIds;
    }

    @Generated
    public void setUntagNetworkIds(List<String> untagNetworkIds) {
        this.untagNetworkIds = untagNetworkIds;
    }

    @Generated
    public void setVoiceNetworkId(String voiceNetworkId) {
        this.voiceNetworkId = voiceNetworkId;
    }

    @Generated
    public void setDot1x(Integer dot1x) {
        this.dot1x = dot1x;
    }

    @Generated
    public void setPortIsolationEnable(Boolean portIsolationEnable) {
        this.portIsolationEnable = portIsolationEnable;
    }

    @Generated
    public void setLldpMedEnable(Boolean lldpMedEnable) {
        this.lldpMedEnable = lldpMedEnable;
    }

    @Generated
    public void setTopoNotifyEnable(Boolean topoNotifyEnable) {
        this.topoNotifyEnable = topoNotifyEnable;
    }

    @Generated
    public void setBandWidthCtrlType(Integer bandWidthCtrlType) {
        this.bandWidthCtrlType = bandWidthCtrlType;
    }

    @Generated
    public void setStormCtrl(StormCtrlVO stormCtrl) {
        this.stormCtrl = stormCtrl;
    }

    @Generated
    public void setBandCtrl(BandCtrlVO bandCtrl) {
        this.bandCtrl = bandCtrl;
    }

    @Generated
    public void setSpanningTreeEnable(Boolean spanningTreeEnable) {
        this.spanningTreeEnable = spanningTreeEnable;
    }

    @Generated
    public void setSpanningTreeSetting(SpanningTreeSettingVO spanningTreeSetting) {
        this.spanningTreeSetting = spanningTreeSetting;
    }

    @Generated
    public void setLoopbackDetectEnable(Boolean loopbackDetectEnable) {
        this.loopbackDetectEnable = loopbackDetectEnable;
    }

    @Generated
    public void setEeeEnable(Boolean eeeEnable) {
        this.eeeEnable = eeeEnable;
    }

    @Generated
    public void setFlowControlEnable(Boolean flowControlEnable) {
        this.flowControlEnable = flowControlEnable;
    }

    @Generated
    public void setLoopbackDetectVlanBasedEnable(Boolean loopbackDetectVlanBasedEnable) {
        this.loopbackDetectVlanBasedEnable = loopbackDetectVlanBasedEnable;
    }

    @Generated
    public void setIgmpFastLeaveEnable(Boolean igmpFastLeaveEnable) {
        this.igmpFastLeaveEnable = igmpFastLeaveEnable;
    }

    @Generated
    public void setMldFastLeaveEnable(Boolean mldFastLeaveEnable) {
        this.mldFastLeaveEnable = mldFastLeaveEnable;
    }

    @Generated
    public void setDhcpL2RelaySettings(DhcpL2RelayVO dhcpL2RelaySettings) {
        this.dhcpL2RelaySettings = dhcpL2RelaySettings;
    }

    @Generated
    public void setFastLeaveEnable(Boolean fastLeaveEnable) {
        this.fastLeaveEnable = fastLeaveEnable;
    }

    @Generated
    public void setDot1pPriority(Integer dot1pPriority) {
        this.dot1pPriority = dot1pPriority;
    }

    @Generated
    public void setTrustMode(Integer trustMode) {
        this.trustMode = trustMode;
    }

    @Generated
    public void setType(Integer type) {
        this.type = type;
    }

    @Generated
    public void setSupportESEnable(Boolean supportESEnable) {
        this.supportESEnable = supportESEnable;
    }

    @Generated
    public void setNetworkConflict(Boolean networkConflict) {
        this.networkConflict = networkConflict;
    }

    @Generated
    public String toString() {
        return "LanProfileOpenApiVO(id=" + this.getId() + ", flag=" + this.getFlag() + ", name=" + this.getName() + ", poe=" + this.getPoe() + ", nativeNetworkId=" + this.getNativeNetworkId() + ", tagNetworkIds=" + this.getTagNetworkIds() + ", untagNetworkIds=" + this.getUntagNetworkIds() + ", voiceNetworkId=" + this.getVoiceNetworkId() + ", dot1x=" + this.getDot1x() + ", portIsolationEnable=" + this.getPortIsolationEnable() + ", lldpMedEnable=" + this.getLldpMedEnable() + ", topoNotifyEnable=" + this.getTopoNotifyEnable() + ", bandWidthCtrlType=" + this.getBandWidthCtrlType() + ", stormCtrl=" + this.getStormCtrl() + ", bandCtrl=" + this.getBandCtrl() + ", spanningTreeEnable=" + this.getSpanningTreeEnable() + ", spanningTreeSetting=" + this.getSpanningTreeSetting() + ", loopbackDetectEnable=" + this.getLoopbackDetectEnable() + ", eeeEnable=" + this.getEeeEnable() + ", flowControlEnable=" + this.getFlowControlEnable() + ", loopbackDetectVlanBasedEnable=" + this.getLoopbackDetectVlanBasedEnable() + ", igmpFastLeaveEnable=" + this.getIgmpFastLeaveEnable() + ", mldFastLeaveEnable=" + this.getMldFastLeaveEnable() + ", dhcpL2RelaySettings=" + this.getDhcpL2RelaySettings() + ", fastLeaveEnable=" + this.getFastLeaveEnable() + ", dot1pPriority=" + this.getDot1pPriority() + ", trustMode=" + this.getTrustMode() + ", type=" + this.getType() + ", supportESEnable=" + this.getSupportESEnable() + ", networkConflict=" + this.getNetworkConflict() + ")";
    }

    @Generated
    public LanProfileOpenApiVO(String id, Integer flag, String name, Integer poe, String nativeNetworkId, List<String> tagNetworkIds, List<String> untagNetworkIds, String voiceNetworkId, Integer dot1x, Boolean portIsolationEnable, Boolean lldpMedEnable, Boolean topoNotifyEnable, Integer bandWidthCtrlType, StormCtrlVO stormCtrl, BandCtrlVO bandCtrl, Boolean spanningTreeEnable, SpanningTreeSettingVO spanningTreeSetting, Boolean loopbackDetectEnable, Boolean eeeEnable, Boolean flowControlEnable, Boolean loopbackDetectVlanBasedEnable, Boolean igmpFastLeaveEnable, Boolean mldFastLeaveEnable, DhcpL2RelayVO dhcpL2RelaySettings, Boolean fastLeaveEnable, Integer dot1pPriority, Integer trustMode, Integer type, Boolean supportESEnable, Boolean networkConflict) {
        this.id = id;
        this.flag = flag;
        this.name = name;
        this.poe = poe;
        this.nativeNetworkId = nativeNetworkId;
        this.tagNetworkIds = tagNetworkIds;
        this.untagNetworkIds = untagNetworkIds;
        this.voiceNetworkId = voiceNetworkId;
        this.dot1x = dot1x;
        this.portIsolationEnable = portIsolationEnable;
        this.lldpMedEnable = lldpMedEnable;
        this.topoNotifyEnable = topoNotifyEnable;
        this.bandWidthCtrlType = bandWidthCtrlType;
        this.stormCtrl = stormCtrl;
        this.bandCtrl = bandCtrl;
        this.spanningTreeEnable = spanningTreeEnable;
        this.spanningTreeSetting = spanningTreeSetting;
        this.loopbackDetectEnable = loopbackDetectEnable;
        this.eeeEnable = eeeEnable;
        this.flowControlEnable = flowControlEnable;
        this.loopbackDetectVlanBasedEnable = loopbackDetectVlanBasedEnable;
        this.igmpFastLeaveEnable = igmpFastLeaveEnable;
        this.mldFastLeaveEnable = mldFastLeaveEnable;
        this.dhcpL2RelaySettings = dhcpL2RelaySettings;
        this.fastLeaveEnable = fastLeaveEnable;
        this.dot1pPriority = dot1pPriority;
        this.trustMode = trustMode;
        this.type = type;
        this.supportESEnable = supportESEnable;
        this.networkConflict = networkConflict;
    }

    @Generated
    public LanProfileOpenApiVO() {
    }
}

